/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.mwclient.sentinel.model;

import com.yonyou.cloud.mwclient.sentinel.EntryManager;
import com.yonyou.cloud.mwclient.sentinel.model.AutoSwitch;
import com.yonyou.cloud.mwclient.sentinel.model.CountArray;
import com.yonyou.cloud.mwclient.sentinel.model.StatEntry;
import com.yonyou.cloud.mwclient.sentinel.model.cluster.ClusterEntryStrategy;
import com.yonyou.cloud.mwclient.sentinel.model.exception.SentinelBlockedException;
import java.text.DateFormat;
import java.util.Date;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;

public class Entry {
    private static DateFormat fullDateFormat = DateFormat.getDateTimeInstance(0, 0);
    private static final int DEFALUT_UNIT_MILLS = 50;
    private static Long secondDivCount = 10L;
    private static Long millisForSecond = 1000L;
    private static Long slotMills = millisForSecond / secondDivCount;
    private String desc;
    private CountArray countArray;
    private AutoSwitch autoSwitch;
    private AtomicLong threadCount = new AtomicLong(0L);
    private AtomicLong currentMills;
    private ClusterEntryStrategy clusterEntryStrategy;
    private LinkedBlockingDeque<StatEntry> statEntries = new LinkedBlockingDeque(10);
    private String rootDesc;

    public static Long getSecondDivCount() {
        return secondDivCount;
    }

    public static void setSecondDivCount(Long secondDivCount) {
        Entry.secondDivCount = secondDivCount;
    }

    public static Long getMillisForSecond() {
        return millisForSecond;
    }

    public static void setMillisForSecond(Long millisForSecond) {
        Entry.millisForSecond = millisForSecond;
    }

    public static Long getSlotMills() {
        return slotMills;
    }

    public static void setSlotMills(Long slotMills) {
        Entry.slotMills = slotMills;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public CountArray getCountArray() {
        return this.countArray;
    }

    public void setCountArray(CountArray countArray) {
        this.countArray = countArray;
    }

    public AutoSwitch getAutoSwitch() {
        return this.autoSwitch;
    }

    public void setAutoSwitch(AutoSwitch autoSwitch) {
        this.autoSwitch = autoSwitch;
    }

    public AtomicLong getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(AtomicLong threadCount) {
        this.threadCount = threadCount;
    }

    public AtomicLong getCurrentMills() {
        return this.currentMills;
    }

    public void setCurrentMills(AtomicLong currentMills) {
        this.currentMills = currentMills;
    }

    public ClusterEntryStrategy getClusterEntryStrategy() {
        return this.clusterEntryStrategy;
    }

    public void setClusterEntryStrategy(ClusterEntryStrategy clusterEntryStrategy) {
        this.clusterEntryStrategy = clusterEntryStrategy;
    }

    public LinkedBlockingDeque<StatEntry> getStatEntries() {
        return this.statEntries;
    }

    public void setStatEntries(LinkedBlockingDeque<StatEntry> statEntries) {
        this.statEntries = statEntries;
    }

    public String getRootDesc() {
        return this.rootDesc;
    }

    public void setRootDesc(String rootDesc) {
        this.rootDesc = rootDesc;
    }

    public static int getDefalutUnitMills() {
        return 50;
    }

    public Entry(String name) {
        this.desc = name;
        this.currentMills = new AtomicLong(new Date().getTime());
        this.countArray = CountArray.build(-1L, 50);
        this.autoSwitch = AutoSwitch.newInstance(name);
        EntryManager.addEntry(this);
    }

    public void reload(long qps, long threadCount) {
        if (this.clusterEntryStrategy == null) {
            this.clusterEntryStrategy = new ClusterEntryStrategy(this.desc);
        }
        this.clusterEntryStrategy.setQps(qps);
        this.clusterEntryStrategy.setThreadCount(threadCount);
        if (qps != this.countArray.getTotalCount().get()) {
            this.countArray = CountArray.build(qps, 50);
        }
    }

    public static Entry enter(String name) {
        Entry entry = EntryManager.getEntry(name);
        if (entry == null) {
            entry = new Entry(name);
        }
        if (!entry.autoSwitch.off()) {
            entry.enterEntry();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statTrace(String traceKey) {
        StatEntry statEntry = this.statEntries.peekLast();
        long now = new Date().getTime();
        if (statEntry == null) {
            LinkedBlockingDeque<StatEntry> linkedBlockingDeque = this.statEntries;
            synchronized (linkedBlockingDeque) {
                statEntry = new StatEntry(now);
                statEntry.stat(traceKey);
                this.statEntries.addLast(statEntry);
            }
        } else if (statEntry.getTimestamp() - now > millisForSecond) {
            LinkedBlockingDeque<StatEntry> linkedBlockingDeque = this.statEntries;
            synchronized (linkedBlockingDeque) {
                statEntry = new StatEntry(now);
                statEntry.stat(traceKey);
                if (!this.statEntries.offer(statEntry)) {
                    this.statEntries.removeFirst();
                }
                this.statEntries.addLast(statEntry);
            }
        } else {
            statEntry.stat(traceKey);
        }
    }

    public void enterEntry() {
        this.threadCount.incrementAndGet();
        long tCount = this.threadCount.longValue();
        if (this.clusterEntryStrategy != null) {
            if (this.countArray.overLimit()) {
                throw new SentinelBlockedException("qps exceed, qps is: " + this.countArray.totalCount());
            }
            if (tCount > this.clusterEntryStrategy.getThreadCount()) {
                this.threadCount.decrementAndGet();
                throw new SentinelBlockedException("thread count exceed, thread count is: " + tCount);
            }
        }
    }

    public void exit() {
        this.threadCount.decrementAndGet();
        this.countArray.exit();
    }

    public void exit(boolean result) {
        this.autoSwitch.stat(result);
        this.exit();
    }

    public String info() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(fullDateFormat.format(new Date())).append("   ").append("desc: ").append(this.desc).append("\n").append("qps: ").append(this.countArray.getTotalCount()).append("\n").append("threadCount: ").append(this.threadCount.get()).append("\n").append("executeInfo: \n").append("     ");
        for (StatEntry statEntry : this.statEntries) {
            sb.append(statEntry.toString()).append("\n").append("     ");
        }
        return sb.toString();
    }
}

