/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.mwclient.sentinel.proteus;

import com.yonyou.cloud.middleware.AppRuntimeEnvironment;
import com.yonyou.cloud.middleware.embed.proteus.client.common.annotations.DisconfFile;
import com.yonyou.cloud.middleware.embed.proteus.client.common.annotations.DisconfUpdateService;
import com.yonyou.cloud.middleware.embed.proteus.client.common.update.IDisconfUpdate;
import com.yonyou.cloud.middleware.model.ILogger;
import com.yonyou.cloud.middleware.model.MwLogFactory;
import com.yonyou.cloud.mwclient.sentinel.EntryManager;
import com.yonyou.cloud.mwclient.sentinel.model.Entry;
import com.yonyou.cloud.mwclient.sentinel.model.strategy.StrategyConfigure;
import com.yonyou.cloud.mwclient.sentinel.model.strategy.StrategyDesc;
import com.yonyou.cloud.utils.CollectionUtils;
import com.yonyou.cloud.utils.GsonUtilHolder;
import com.yonyou.cloud.utils.StringUtils;
import java.util.List;

@DisconfFile(group="mwclient", filename="strategy.json", copy2TargetDirPath="/etc/config/mwclient")
@DisconfUpdateService(group="mwclient", confFileKeys={"strategy.json"})
public class StrategyListener
implements IDisconfUpdate {
    ILogger logger = MwLogFactory.getLogger(StrategyListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload(Object data) throws Exception {
        Entry entry = null;
        try {
            List<StrategyDesc> strategyDescList;
            String strategy = (String)data;
            if (StringUtils.isBlank(strategy)) {
                this.logger.warn("\u7b56\u7565\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a!");
                return;
            }
            StrategyConfigure strategyConfigure = GsonUtilHolder.fromJson(strategy, StrategyConfigure.class);
            if (!StringUtils.equalsIgnoreCase(AppRuntimeEnvironment.getAppCode(), strategyConfigure.getAppName())) {
                this.logger.error("app name not match, register app name: " + AppRuntimeEnvironment.getAppCode() + ", configure file app name: " + strategyConfigure.getAppName());
            }
            if (CollectionUtils.isEmpty(strategyDescList = strategyConfigure.getStrategy())) {
                return;
            }
            for (StrategyDesc desc : strategyDescList) {
                String apiMethod = StrategyListener.formatDesc(desc.getDesc());
                entry = EntryManager.getEntry(apiMethod, desc.getRoot());
                if (entry == null) {
                    entry = Entry.enter(apiMethod);
                }
                entry.reload(desc.getQps(), desc.getThreadCount());
            }
        }
        catch (Exception e) {
            this.logger.error("reload failed, sentinel data: " + data, e);
        }
        finally {
            if (entry != null) {
                entry.exit();
            }
        }
    }

    private static String formatDesc(String desc) {
        if (!StringUtils.contains(desc, "#")) {
            return desc;
        }
        return StringUtils.replace(desc, "#", ".");
    }

    public static void main(String[] args) {
        String desc = "com.yonyou.cloud.sentinel#api(java.lang.String, java.lang.Integer)";
        System.out.print(StrategyListener.formatDesc(desc));
    }
}

