/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.plugin;

import com.yonyou.cloud.exception.PluginExceptionHandler;
import com.yonyou.cloud.plugin.IPlugin;
import com.yonyou.cloud.plugin.InvokeChain;
import com.yonyou.cloud.plugin.InvokeRequest;
import com.yonyou.cloud.plugin.InvokeResponse;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public abstract class AbstractPluginManager {
    static Logger LOG = Logger.getLogger(AbstractPluginManager.class.getName());
    public final Map<String, IPlugin[]> PLUGINS = new ConcurrentHashMap<String, IPlugin[]>();

    protected abstract List<IPlugin> lookupPlugins(Class<? extends IPlugin> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPlugin[] getPlugins(Class<? extends IPlugin> clazz) {
        IPlugin[] plugins = this.PLUGINS.get(clazz.getName());
        if (plugins == null) {
            Class<? extends IPlugin> clazz2 = clazz;
            synchronized (clazz2) {
                if (plugins == null) {
                    List<IPlugin> list = this.lookupPlugins(clazz);
                    Collections.sort(list, new Comparator<IPlugin>(){

                        @Override
                        public int compare(IPlugin o1, IPlugin o2) {
                            if (o1.order() > o2.order()) {
                                return 1;
                            }
                            if (o1.order() < o2.order()) {
                                return -1;
                            }
                            return 0;
                        }
                    });
                    plugins = list.toArray(new IPlugin[0]);
                    StringBuffer sb = new StringBuffer("\u6269\u5c55\u70b9:").append(clazz.getName()).append("\u7684\u5b9e\u73b0:[");
                    for (IPlugin plugin : list) {
                        sb.append(plugin.getPluginName()).append(" -> ").append(plugin.getClass().getName()).append(",");
                    }
                    sb.append("]");
                    LOG.info(sb.toString());
                    this.PLUGINS.put(clazz.getName(), plugins);
                }
            }
        }
        return plugins;
    }

    public InvokeResponse invoke(Class<? extends IPlugin> clazz, InvokeRequest request, InvokeResponse response, InvokeChain chain) {
        chain.setPlugins(this.getPlugins(clazz));
        chain.run(request, response, chain);
        return response;
    }

    public InvokeResponse invoke(Class<? extends IPlugin> clazz) {
        InvokeRequest request = new InvokeRequest();
        InvokeResponse response = new InvokeResponse();
        this.invoke(clazz, request, response);
        return response;
    }

    public InvokeResponse invoke(Class<? extends IPlugin> clazz, InvokeRequest request, InvokeResponse response) {
        try {
            InvokeChain chain = new InvokeChain();
            chain.setPlugins(this.getPlugins(clazz));
            chain.run(request, response, chain);
        }
        catch (RuntimeException ex) {
            PluginExceptionHandler.processPluginException(ex);
        }
        return response;
    }
}

