/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.construction.icop.config.utils;

import com.yonyou.construction.icop.config.exception.ConfigException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcopConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(IcopConfigUtils.class);
    private static volatile Properties cache = null;

    private IcopConfigUtils() {
    }

    public static String getValue(String key) {
        String value = (String)System.getProperties().get(key);
        if (null == value || "".equals(value)) {
            value = System.getenv(key);
        }
        return value;
    }

    public static boolean isReadLocalFile() {
        boolean local = false;
        String profile = IcopConfigUtils.getValue("spring.cloud.config.profile");
        if (null == profile || "".equals(profile)) {
            log.info("profile is null,load properties from local...");
            local = true;
        } else {
            log.info("profile is " + profile + ",load properties from git server");
        }
        return local;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties getFromServer() {
        if (null != cache) return cache;
        Class<IcopConfigUtils> clazz = IcopConfigUtils.class;
        synchronized (IcopConfigUtils.class) {
            String application;
            String label;
            if (null != cache) return cache;
            log.info("cache-is-null-load-properties-from-server");
            String profile = IcopConfigUtils.getParameter("spring.cloud.config.profile");
            String configServer = IcopConfigUtils.getParameter("spring.cloud.config.uri");
            if (null == configServer) {
                throw new ConfigException("configServer \u914d\u7f6e\u9519\u8bef");
            }
            if (!configServer.endsWith("/")) {
                configServer = configServer + "/";
            }
            if ((label = IcopConfigUtils.getParameter("spring.cloud.config.label")) == null) {
                label = "master";
            }
            if (null == (application = IcopConfigUtils.getParameter("spring.cloud.config.name"))) {
                throw new ConfigException("applicationName \u914d\u7f6e\u9519\u8bef");
            }
            cache = IcopConfigUtils.getFromServer(configServer, application, profile, label);
            String propsStr = cache.entrySet().stream().map(e -> e.getKey() + " = " + e.getValue()).collect(Collectors.joining("\n"));
            log.info("\u4ece\u670d\u52a1\u5668\u7aef\u8bfb\u53d6\u7aef\u914d\u7f6e\u4fe1\u606f\uff1a\n\n{}\n", (Object)propsStr);
            // ** MonitorExit[var0] (shouldn't be in output)
            return cache;
        }
    }

    public static String getParameter(String key) {
        String value = System.getProperty(key);
        if (null == value || "".equals(value)) {
            value = System.getenv(key);
        }
        return "".equals(value) ? null : value;
    }

    private static Properties getFromServer(String configServer, String application, String profile, String label) {
        String verStr = IcopConfigUtils.getParameter("yyjz.config.agent.version");
        if (null == verStr || verStr == "") {
            verStr = "1.1";
        }
        double ver = 1.0;
        try {
            ver = Double.parseDouble(verStr);
        }
        catch (Exception err) {
            ver = 1.1;
            log.error("config-agent\u7248\u672c\u53f7\u6709\u8bef", (Throwable)err);
        }
        Properties prop = new Properties();
        if (ver > 1.0) {
            prop.putAll((Map<?, ?>)IcopConfigUtils.getPropertiesInLoop(configServer + application + "-share.properties", true));
            Properties appProp = IcopConfigUtils.getPropertiesInLoop(configServer + application + "-" + profile + ".properties", false);
            if (appProp != null) {
                prop.putAll((Map<?, ?>)appProp);
            }
        } else {
            prop.putAll((Map<?, ?>)IcopConfigUtils.getPropertiesInLoop(configServer + application + "-" + profile + ".properties", true));
        }
        Properties commons = IcopConfigUtils.getPropertiesInLoop(configServer + "commons-" + profile + ".properties", true);
        commons.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            if (k.toString().startsWith("public.config")) {
                prop.put(k, v);
            }
        }));
        return IcopConfigUtils.dealCommons(prop, commons);
    }

    private static Properties dealCommons(Properties prop, Properties commons) {
        prop.entrySet().forEach(e -> commons.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> e.setValue(((String)e.getValue()).replace("${" + k + "}", (String)v)))));
        return prop;
    }

    private static Properties getPropertiesInLoop(String serverurl, boolean isRetry) {
        int count = 0;
        while (true) {
            try {
                log.info("\u7b2c" + (count + 1) + "\u6b21\u4ece " + serverurl + "\u8bfb\u53d6\u914d\u7f6e");
                return IcopConfigUtils.getProperties(serverurl);
            }
            catch (Exception e) {
                if (!isRetry) {
                    return null;
                }
                if (++count >= 8) {
                    throw new ConfigException("\u591a\u6b21\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38,\u8bf7\u68c0\u67e5\u76f8\u5173\u7f51\u7edc\u6216\u670d\u52a1\u7b49", e);
                }
                try {
                    long waitSeconds = (long)Math.pow(2.0, count);
                    log.info("\u7b49\u5f85" + waitSeconds + "s,\u518d\u6b21\u5904\u7406...");
                    long waittime = waitSeconds * 1000L;
                    Thread.sleep(waittime);
                    continue;
                }
                catch (InterruptedException e1) {
                    log.error("Thread.sleep--InterruptedException-->", (Throwable)e);
                    continue;
                }
            }
            break;
        }
    }

    private static Properties getProperties(String serverurl) {
        try {
            URL url = new URL(serverurl);
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            huc.setDoOutput(true);
            huc.setConnectTimeout(6000);
            huc.setRequestProperty("Content-Type", "text/json; charset=ISO-8859-1");
            huc.setRequestMethod("GET");
            huc.setRequestProperty("Accept", "*/*");
            huc.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; CIBA)");
            huc.setRequestProperty("Accept-Language", "zh-cn");
            huc.connect();
            int code = huc.getResponseCode();
            if (code >= 200 && code < 300) {
                Properties prop = new Properties();
                try (InputStream is = huc.getInputStream();
                     InputStreamReader reader = new InputStreamReader(is, "ISO-8859-1");){
                    prop.load(reader);
                }
                return prop;
            }
            log.error("\u7f51\u7edc\u5f02\u5e38:" + serverurl + "," + code);
            throw new ConfigException("\u7f51\u7edc\u5f02\u5e38:" + serverurl + "," + code);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38-->", (Throwable)e);
            throw new ConfigException("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\uff0c", e);
        }
    }
}

