/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.dubbo.rpc.filter;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.yonyou.iuap.context.InvocationInfoProxy;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.MDC;

@Activate(order=999999)
public class LogContextFilter
implements Filter {
    private static final String IUAP_TOKEN = "iuap_token";
    private static final Logger logger = LoggerFactory.getLogger(LogContextFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Result result = null;
        RpcContext context = RpcContext.getContext();
        this.doBeforeInvoke(context);
        try {
            result = invoker.invoke(invocation);
        }
        catch (RpcException e) {
            throw e;
        }
        finally {
            this.doAfterInvoke(context);
        }
        return result;
    }

    private void doBeforeInvoke(RpcContext context) {
        try {
            if (context.isConsumerSide()) {
                Map contextMap = MDC.getCopyOfContextMap();
                if (contextMap != null && !contextMap.isEmpty()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("put MDC info to RpcContext ,data is " + contextMap);
                    }
                    for (Map.Entry entry : contextMap.entrySet()) {
                        context.setAttachment((String)entry.getKey(), (String)entry.getValue());
                    }
                    Iterator invocationSummrys = InvocationInfoProxy.getSummry();
                    while (invocationSummrys.hasNext()) {
                        Map.Entry invocationSummry = (Map.Entry)invocationSummrys.next();
                        if ("token".equals(invocationSummry.getKey())) {
                            context.setAttachment(IUAP_TOKEN, (String)invocationSummry.getValue());
                            continue;
                        }
                        context.setAttachment((String)invocationSummry.getKey(), (String)invocationSummry.getValue());
                    }
                }
            } else {
                Map contextMap = context.getAttachments();
                if (contextMap != null && !contextMap.isEmpty()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("debug RpcContext info in MDC ,data is " + contextMap);
                    }
                    for (Map.Entry entry : contextMap.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        MDC.put((String)key, (String)value);
                        if (StringUtils.isEquals((String)key, (String)"sysid")) {
                            InvocationInfoProxy.setSysid((String)value);
                            continue;
                        }
                        if (StringUtils.isEquals((String)key, (String)IUAP_TOKEN)) {
                            InvocationInfoProxy.setToken((String)value);
                            continue;
                        }
                        if (StringUtils.isEquals((String)key, (String)"tenantid")) {
                            InvocationInfoProxy.setTenantid((String)value);
                            continue;
                        }
                        if (StringUtils.isEquals((String)key, (String)"userid")) {
                            InvocationInfoProxy.setUserid((String)value);
                            continue;
                        }
                        if (StringUtils.isEquals((String)key, (String)"callid")) {
                            InvocationInfoProxy.setCallid((String)value);
                            continue;
                        }
                        if (StringUtils.isEquals((String)key, (String)"locale")) {
                            InvocationInfoProxy.setLocale((String)value);
                            continue;
                        }
                        if (StringUtils.isEquals((String)key, (String)"logints")) {
                            InvocationInfoProxy.setLogints((String)value);
                            continue;
                        }
                        InvocationInfoProxy.setParameter((String)key, (String)value);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn("Exception in LogContextFilter, rpc url is {}" + context.getUrl(), (Throwable)e);
        }
    }

    private void doAfterInvoke(RpcContext context) {
        try {
            if (context.isProviderSide()) {
                InvocationInfoProxy.reset();
                Map contextMap = MDC.getCopyOfContextMap();
                if (contextMap != null && !contextMap.isEmpty()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("put MDC info to RpcContext ,data is " + contextMap);
                    }
                    for (Map.Entry entry : contextMap.entrySet()) {
                        context.removeAttachment((String)entry.getKey());
                    }
                }
                MDC.clear();
                if (logger.isDebugEnabled()) {
                    logger.debug("clear MDC info success ! ");
                }
            }
        }
        catch (Exception e) {
            logger.warn("Exception in LogContextFilter when clear info of RpcContext and MDC. rpc url is " + context.getUrl(), (Throwable)e);
        }
    }
}

