/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.msg.sign;

import com.yonyou.iuap.security.rest.api.Signer;
import com.yonyou.iuap.security.rest.exception.UAPSecurityException;
import com.yonyou.iuap.security.rest.rsa.client.RSAClientSigner;
import com.yonyou.iuap.security.rest.utils.ClientCredentialGenerator;
import com.yonyou.uap.msg.sign.DigestSigner;
import com.yonyou.uap.msg.utils.MsgPropertyUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSignFactory {
    private static final Logger logger = LoggerFactory.getLogger(ClientSignFactory.class);

    public static Signer getSigner(String prefix) throws UAPSecurityException {
        String clientCredientialPath = null;
        if (StringUtils.isNotBlank((String)prefix)) {
            clientCredientialPath = MsgPropertyUtil.getPropertyByKey(prefix + "." + "client.credential.path");
        }
        if (StringUtils.isBlank(clientCredientialPath)) {
            logger.info("find credential file path without prefix.");
            clientCredientialPath = MsgPropertyUtil.getPropertyByKey("client.credential.path");
        }
        String signAlg = MsgPropertyUtil.getInnerPropertyByKey("UAP.AUTH.ALG");
        if (StringUtils.isBlank(clientCredientialPath) || StringUtils.isBlank((String)signAlg)) {
            String msg = "please check config for credential file url and signalg.";
            logger.error(msg);
            throw new UAPSecurityException(msg);
        }
        logger.info("credential file path is {}.", (Object)clientCredientialPath);
        if ("HMAC".equals(signAlg)) {
            return new DigestSigner(ClientCredentialGenerator.loadCredential((String)clientCredientialPath));
        }
        if ("RSA".equals(signAlg)) {
            return new RSAClientSigner(ClientCredentialGenerator.loadCredential((String)clientCredientialPath));
        }
        throw new UAPSecurityException("\u7b7e\u540d\u7b97\u6cd5" + signAlg + "\u4e0d\u5339\u914d!");
    }
}

