/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.msg.sign;

import com.yonyou.iuap.security.rest.common.SignProp;
import com.yonyou.iuap.security.rest.utils.PostParamsHelper;
import com.yonyou.iuap.security.rest.utils.SignPropGenerator;
import com.yonyou.uap.msg.sign.ClientSignFactory;
import com.yonyou.uap.msg.sign.SignEntity;
import com.yonyou.uap.msg.utils.MsgPropertyUtil;
import com.yonyou.uap.msg.utils.RestAPIUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignMake {
    private static Logger log = LoggerFactory.getLogger(SignMake.class);
    private static Properties properties;
    public static String SIGNPOST;
    public static String SIGNGET;
    public static final String PREFIX = "msg";

    public static String signURL(String reqURL) {
        try {
            reqURL = reqURL.contains("?") ? reqURL + "&" : reqURL + "?";
            reqURL = SignMake.genator(reqURL);
            SignProp prop = SignPropGenerator.genSignProp((String)reqURL);
            String sign = ClientSignFactory.getSigner(PREFIX).sign(prop);
            reqURL = reqURL + "&sign=" + sign;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return reqURL;
    }

    public static SignEntity signEntity(String reqURL, Map<String, ?> paramsMap, String type) {
        try {
            SignEntity signEntity = new SignEntity();
            reqURL = reqURL.contains("?") ? reqURL + "&" : reqURL + "?";
            reqURL = SignMake.genator(reqURL);
            SignProp prop = SignPropGenerator.genSignProp((String)reqURL);
            if (type.equals(SIGNPOST)) {
                prop.setPostParamsStr(PostParamsHelper.genParamsStrByMap(paramsMap));
                long length = RestAPIUtils.getContentLength(paramsMap);
                prop.setContentLength(length);
            }
            String sign = ClientSignFactory.getSigner(PREFIX).sign(prop);
            signEntity.setSignURL(reqURL);
            signEntity.setSign(sign);
            return signEntity;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static SignEntity signEntity(String reqURL, String json) {
        try {
            SignEntity signEntity = new SignEntity();
            reqURL = reqURL.contains("?") ? reqURL + "&" : reqURL + "?";
            reqURL = SignMake.genator(reqURL);
            SignProp prop = SignPropGenerator.genSignProp((String)reqURL);
            prop.setPostParamsStr("");
            long length = json.getBytes("UTF-8").length;
            prop.setContentLength(length);
            String sign = ClientSignFactory.getSigner(PREFIX).sign(prop);
            signEntity.setSignURL(reqURL);
            signEntity.setSign(sign);
            return signEntity;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String genator(String requestPath) {
        String appId;
        String ts = System.currentTimeMillis() + "";
        try {
            SignMake.loadFiles(MsgPropertyUtil.getPropertyByKey("msg.client.credential.path"));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        requestPath = requestPath + "ts=" + ts;
        String userName = properties.getProperty("username");
        if (StringUtils.isNotBlank((String)userName)) {
            requestPath = requestPath + "&username=" + userName;
        }
        if (!StringUtils.isNotBlank((String)(appId = (String)properties.get("appId")))) {
            log.error("appId is empty");
            return null;
        }
        requestPath = requestPath + "&appId=" + appId;
        return requestPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadFiles(String path) throws IOException {
        if (null != properties) return;
        Class<SignMake> clazz = SignMake.class;
        synchronized (SignMake.class) {
            if (null != properties) return;
            try (FileInputStream in = null;){
                in = new FileInputStream(path);
                properties = new Properties();
                properties.load(in);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        SIGNPOST = "POST";
        SIGNGET = "GET";
    }
}

