/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.msg.utils;

import com.yonyou.uap.msg.utils.MsgPropertyUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpTookit {
    private static final CloseableHttpClient httpClient;
    public static final String CHARSET = "UTF-8";

    public static boolean initParms() {
        return true;
    }

    public static String doGet(String url, Map<String, String> params) {
        return HttpTookit.doGet(url, params, null, CHARSET);
    }

    public static String doPost(String url, Map<String, String> params) {
        return HttpTookit.doPost(url, params, null, CHARSET);
    }

    public static String doDelete(String url, Map<String, String> params) {
        return HttpTookit.doDelete(url, params, null, CHARSET);
    }

    public static String doPut(String url, Map<String, String> params) {
        return HttpTookit.doPut(url, params, null, CHARSET);
    }

    public static String doGet(String url, Map<String, String> params, Map<String, String> headers) {
        return HttpTookit.doGet(url, params, headers, CHARSET);
    }

    public static String doPost(String url, Map<String, String> params, Map<String, String> headers) {
        return HttpTookit.doPost(url, params, headers, CHARSET);
    }

    public static String doDelete(String url, Map<String, String> params, Map<String, String> headers) {
        return HttpTookit.doDelete(url, params, headers, CHARSET);
    }

    public static String doPostWithJson(String url, String json, Map<String, String> headers) {
        return HttpTookit.doPostWithJson(url, json, headers, CHARSET);
    }

    public static String doPut(String url, Map<String, String> params, Map<String, String> headers) {
        return HttpTookit.doPut(url, params, headers, CHARSET);
    }

    public static String doPostFile(String url, Map<String, String> params, Map<String, String> headers, String filepath) {
        return HttpTookit.doPostFile(url, params, headers, filepath, CHARSET);
    }

    public static String doGet(String url, Map<String, String> params, Map<String, String> headers, String charset) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            if (params != null && !params.isEmpty()) {
                ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair(entry.getKey(), value));
                }
                url = url + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(pairs, charset));
            }
            HttpGet httpGet = new HttpGet(url);
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpGet.addHeader(entry.getKey(), entry.getValue());
                }
            }
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(360000).setConnectTimeout(360000).build();
            httpGet.setConfig(requestConfig);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpGet.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
            }
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            httpGet.releaseConnection();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String doPost(String url, Map<String, String> params, Map<String, String> headers, String charset) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            CloseableHttpResponse response;
            int n;
            ArrayList<BasicNameValuePair> pairs = null;
            if (params != null && !params.isEmpty()) {
                pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String string = (String)entry.getValue();
                    if (string == null) continue;
                    pairs.add(new BasicNameValuePair((String)entry.getKey(), string));
                }
            }
            HttpPost httpPost = new HttpPost(url);
            if (pairs != null && pairs.size() > 0) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, CHARSET));
            }
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry entry : headers.entrySet()) {
                    httpPost.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if ((n = (response = httpClient.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode()) != 200) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + n);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
            }
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            httpPost.releaseConnection();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String doPostFile(String url, Map<String, String> params, Map<String, String> headers, String filepath, String charset) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            CloseableHttpResponse response;
            int statusCode;
            FileBody bin = new FileBody(new File(filepath));
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addPart("file", (ContentBody)bin);
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity(builder.build());
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((statusCode = (response = httpClient.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode()) != 200) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
            }
            EntityUtils.consume((HttpEntity)entity);
            httpPost.releaseConnection();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String doPostWithJson(String url, String json, Map<String, String> headers, String charset) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            HttpPost httpPost = new HttpPost(url);
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            JSONObject jsonObj = JSONObject.fromObject((Object)json);
            StringEntity s = new StringEntity(jsonObj.toString(), CHARSET);
            s.setContentEncoding(CHARSET);
            s.setContentType("application/json");
            httpPost.setEntity((HttpEntity)s);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
            }
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            httpPost.releaseConnection();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String doDelete(String url, Map<String, String> params, Map<String, String> headers, String charset) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            if (params != null && !params.isEmpty()) {
                ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair(entry.getKey(), value));
                }
                url = url + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(pairs, charset));
            }
            HttpDelete httpDelete = new HttpDelete(url);
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpDelete.addHeader(entry.getKey(), entry.getValue());
                }
            }
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(360000).setConnectTimeout(360000).build();
            httpDelete.setConfig(requestConfig);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpDelete);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpDelete.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
            }
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            httpDelete.releaseConnection();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String doPut(String url, Map<String, String> params, Map<String, String> headers, String charset) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            CloseableHttpResponse response;
            int n;
            ArrayList<BasicNameValuePair> pairs = null;
            if (params != null && !params.isEmpty()) {
                pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String string = (String)entry.getValue();
                    if (string == null) continue;
                    pairs.add(new BasicNameValuePair((String)entry.getKey(), string));
                }
            }
            HttpPut httpPut = new HttpPut(url);
            if (pairs != null && pairs.size() > 0) {
                httpPut.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, CHARSET));
            }
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry entry : headers.entrySet()) {
                    httpPut.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if ((n = (response = httpClient.execute((HttpUriRequest)httpPut)).getStatusLine().getStatusCode()) != 200) {
                httpPut.abort();
                throw new RuntimeException("HttpClient,error status code :" + n);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
            }
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            httpPut.releaseConnection();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        String MaxTotal = MsgPropertyUtil.getPropertyByKey("httpclient.MaxTotal");
        String MaxPerRoute = MsgPropertyUtil.getPropertyByKey("httpclient.MaxPerRoute");
        if (StringUtils.isBlank((String)MaxTotal) || !StringUtils.isNumeric((String)MaxTotal)) {
            MaxTotal = "";
        }
        if (StringUtils.isBlank((String)MaxPerRoute) || !StringUtils.isNumeric((String)MaxPerRoute)) {
            MaxPerRoute = "";
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(360000).setSocketTimeout(360000).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(Integer.valueOf(MaxTotal).intValue());
        cm.setDefaultMaxPerRoute(Integer.valueOf(MaxPerRoute).intValue());
        httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)cm).build();
    }
}

