/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.msg.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class MsgPropertyUtil {
    private static Properties outerprop = null;
    private static Properties innerprop = null;
    private static String outerPropertyName = "msg-sdk.properties";
    private static String innerPropertyName = "msg-sdk-inner.properties";

    public static void setOuterPropertyName(String outerPropertyName) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{outerPropertyName})) {
            // empty if block
        }
    }

    private static void initOuterProperty() {
        if (outerprop == null) {
            String filePath = System.getenv("msg-sdk-filepath");
            if (StringUtils.isBlank((CharSequence)filePath)) {
                filePath = System.getProperty("msg-sdk-filepath");
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{filePath})) {
                outerPropertyName = filePath;
            }
            outerprop = new Properties();
            try {
                InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(outerPropertyName);
                outerprop.load(in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void initInnerProperty() {
        if (innerprop == null) {
            innerprop = new Properties();
            try {
                InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(innerPropertyName);
                innerprop.load(in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getPropertyByKey(String key) {
        MsgPropertyUtil.initOuterProperty();
        String value = outerprop.getProperty(key);
        return StringUtils.isBlank((CharSequence)value) ? "" : value;
    }

    public static String getInnerPropertyByKey(String key) {
        MsgPropertyUtil.initInnerProperty();
        String value = innerprop.getProperty(key);
        return StringUtils.isBlank((CharSequence)value) ? "" : value;
    }
}

