/*
 * Decompiled with CFR 0.152.
 */
package com.iuap.log.security.mq;

import com.iuap.log.security.mq.EventConfigUtil;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractRabbitmq {
    protected static Logger logger = LoggerFactory.getLogger(AbstractRabbitmq.class);
    protected Connection connection;
    protected ConnectionFactory factory = new ConnectionFactory();

    public AbstractRabbitmq() {
        this.factory.setUsername(EventConfigUtil.getPropertie((String)"mq.username"));
        this.factory.setPassword(EventConfigUtil.getPropertie((String)"mq.password"));
    }

    protected Connection getConnection() throws IOException, TimeoutException {
        Address[] addrs = this.getAddress();
        if (this.connection == null || !this.connection.isOpen()) {
            this.connection = this.factory.newConnection(addrs);
        }
        return this.connection;
    }

    private Address[] getAddress() {
        String addressStr = EventConfigUtil.getPropertie((String)"mq.address");
        String[] addrs = addressStr.split(",");
        ArrayList<Address> addrsList = new ArrayList<Address>();
        for (String addr : addrs) {
            String[] hostAndPost = addr.split(":");
            Address address = new Address(hostAndPost[0], Integer.valueOf(hostAndPost[1]).intValue());
            addrsList.add(address);
        }
        if (addrsList.size() > 0) {
            return addrsList.toArray(new Address[0]);
        }
        return null;
    }

    protected Channel getChannel(String queueName) throws IOException, TimeoutException {
        Channel channel = this.getConnection().createChannel();
        channel.queueDeclare(queueName, true, false, false, null);
        return channel;
    }

    protected Channel getChannel() throws IOException, TimeoutException {
        Channel channel = this.getConnection().createChannel();
        return channel;
    }
}

