/*
 * Decompiled with CFR 0.152.
 */
package com.iuap.log.security.rabbitmq;

import com.iuap.log.security.entities.SecurityLog;
import com.iuap.log.security.exception.SecurityLogException;
import com.iuap.log.security.service.SecurityLogService;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SecuritylogMqListener
implements MessageListener {
    private static Logger logger = LoggerFactory.getLogger(SecuritylogMqListener.class);
    public static int num;
    @Autowired
    private SecurityLogService service;

    public void onMessage(Message message) {
        String securityStr = new String(message.getBody());
        JSONObject jsonObj = JSONObject.fromObject((Object)securityStr);
        SecurityLog securitylog = (SecurityLog)JSONObject.toBean((JSONObject)jsonObj, SecurityLog.class);
        try {
            this.service.saveLog(securitylog);
            logger.debug("save success,securitylog=" + securityStr);
        }
        catch (SecurityLogException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }
}

