/**
 * Created by chief on 2015/10/21.
 */

define([],function() {
    var template = require('art');
    var minlayout = require('html!../../pages/widget.html');

    var init = function(options){
        var options = $.extend({},options);
        $(function(){

            var url = contextRoot+'/widget/list?random='+Math.random();

            function getCatels(value){
                var value = value||'';
                $.ajax({
                    url: contextRoot + "/widget/catels",
                    dataType: 'json',
                    type: 'get',
                    contentType: 'application/json',
                    success: function (res) {
                        var str = [];
                        //str.push('<option selected  value="all">全部分类</option>');
                        $.each(res, function (i, item) {
                            
                            str.push('<option '+(item.id==value?"selected":"")+' value="' + item.id + '">' + item.name + '</option>');
                            
                        });
                        $('.category-list').html(str.join(''));
                    },
                    error: function (XMLHttpRequest) {
                        errorLogin(XMLHttpRequest);
                }
                });
            }

            function getWidgets(url){
                $.ptAjax({
                    url: url,
                    dataType: 'json',
                    type:'get',
                    contentType:'application/json',
                    success: function(res) {
                        var str = [];

                        var render = template.compile(minlayout);
                        var html  = render({list:res,backUrl:options.backUrl});
                        $('#content').html('').html(html);


                        var ipad= navigator.userAgent.indexOf("iPad");

                        if(ipad!=-1){
                            $('#widgetList .icon-pencil').hide();
                            $('#widgetList .icons-l').removeClass('icons-l');
                        }

                        $('#widget-form input').placeholder();

                        //$("#widget-list").append(str.join(''));
                        $('.widget-content').data("list",res);

                        getCatels();

                        $('.wtype').on('change',function(){
                            edit($(this));
                        });

                        $('#widgetList').on('focus','input',function(){
                            $(this).closest('form').find('#errorMessage').html('');
                        });



                        $('#examplePositionCenter').on('hidden.bs.modal', function () {
                            init(options);
                        });

                        $('#widgetList').on('click','#widget-create,#edit-widget',function(e){
                            e.preventDefault();
                            var data = {};
                            var element= $(this).closest('.site-items').find('.form-control');
                            $.each(element,function(i,item){
                                var key = $(item).attr("name");
                                var value = $(item).val();
                                data[key] = value;
                            });
                            data = JSON.stringify(data);
                            var _this  = this;

                            function checkForm() {
                                var fields = $(_this).closest('form').find('.field:visible');
                                var success = false;
                                $.each(fields,function(i,item){
                                    var input = $(item).prev();
                                    if($.trim(input.val())==""){
                                        $(_this).closest('form').find('#errorMessage').html('请填写必填项！');
                                        success = true;
                                        return false;
                                    }
                                });
                                return success;
                            }

                            if(checkForm()){
                                return false;
                            }



                            var url = contextRoot+'/widget/save';
                            if($(this).attr('id')=='edit-widget'){
                                 var id =  $('#examplePositionCenter').data('id');
                                url = contextRoot+'/widget/save/'+id;
                            }
                            $.ajax({
                                url: url,
                                dataType: 'json',
                                data:data,
                                type:'post',
                                contentType:'application/json',
                                success: function(res) {
                                    if(res.status=='0'){
                                        alert(res.message);
                                        return false;
                                    }
                                    else {
                                        $('.page-header-actions').removeClass('open');

                                        if($(_this).attr('id')=='edit-widget'){
                                            $('#widget-body input').val('');
                                            $('#examplePositionCenter').modal('hide');
                                            return false;
                                        }
                                        else {
                                            alert('提交成功');
                                            init(options);
                                        }

                                    }
                                    //location.reload(true);
                                },
                                error: function (XMLHttpRequest) {
                                    errorLogin(XMLHttpRequest);
                                }
                            });

                        });


                        $('#widgetDel .btn-del').click(function(){
                            var _this = this;
                            var  id = $(this).attr("data-id");
                            var data = {id:id}
                            data = JSON.stringify(data);
                            $.ajax({
                                url: contextRoot+"/widget/delete/"+id,
                                dataType: 'json',
                                type:'get',
                                contentType:'application/json',
                                success: function(res) {
                                    if(res.status=="0"){
                                        $('#widgetDel').modal('hide');
                                        alert(res.message);
                                        return false;
                                    }
                                    else {
                                        $('#widgetDel').on('hidden.bs.modal', function () {
                                            init(options);
                                        })
                                        $('#widgetDel').modal('hide');
                                    }

                                    //$(_this).closest('.col-md-3').remove();
                                },
                                error: function (XMLHttpRequest) {
                                    errorLogin(XMLHttpRequest);
                                }
                            });
                        });


                        $('.widget-del').on('click',function(){
                            var _this = this;
                            var  id = $(this).attr("data-id");
                            $('#widgetDel').modal('show');
                            $('#widgetDel .btn-del').attr('data-id',id);
                        });

                        function edit(element){
                            var _this = element;
                            var val = $(_this).val();
                            var parent = $(_this).closest('.site-items');

                            if (val == 'htmlfragment') {
                                parent.find('.wtype-url,.wtype-xml').addClass('hide');
                                parent.find('.wtype-html').removeClass('hide');
                            }
                            else if(val.search(/(url)/)!=-1) {
                                parent.find('.wtype-html,.wtype-xml').addClass('hide');
                                parent.find('.wtype-url').removeClass('hide');
                            }
                            else if(val.search(/(xml)/)!=-1){
                                parent.find('.wtype-html,.wtype-url').addClass('hide');
                                parent.find('.wtype-xml').removeClass('hide').find('.control-label').text(val)
                            }
                        }

                        $('.widget-edit').on('click',function(){
                            var _this = this;
                            var data = $(".widget-content").data("list");

                            var createwidget = require('html!../../pages/createwidget.html');


                            var pkWidget = $(this).attr("data-id");
                            var items = {};

                            $.each(data,function(i,item){
                                if(item.pkWidget==pkWidget){
                                    items = item;
                                }
                            });

                            $('#examplePositionCenter').data('id',items.id);

                            var render = template.compile(createwidget);
                            var html  = render({item:items});




                            $('.widget-edit-body').html(html);

                            $('#examplePositionCenter input').placeholder();

                            getCatels(items.category);
                            //$('#widget-body').html(str);
                            $('#examplePositionCenter .wtype').on('change',function(){
                                edit($(this));
                            });
                            $('.wtype-url').show().find('.control-label').text($('#wtype').val());

                        })

                    }
                });
            }
            getWidgets(url);

        })
    }


    return {
        init:init
    }
})