--/
DECLARE PT_LAYOUTExist INT;
BEGIN
select count(table_name) INTO PT_LAYOUTExist from user_tables where table_name = 'PT_LAYOUT';
IF PT_LAYOUTExist > 0 THEN
execute immediate 'drop table PT_LAYOUT';  
END IF;
END;
/
CREATE TABLE PT_LAYOUT ( 
	TEMPLATEID VARCHAR2(50), 
	SETTING CLOB, PK_LAYOUT VARCHAR2(22) NOT NULL, 
	ID VARCHAR2(50) NOT NULL, 
	NAME VARCHAR2(100) NOT NULL, 
	CTIME DATE NOT NULL, 
	PARENTID VARCHAR2(50), 
	USERID VARCHAR2(50), 
	SYSTEM VARCHAR2(50), 
	TENANT VARCHAR2(50), 
	ISDEFAULT CHAR(1), 
	MODIFYTIME DATE, 
	ISENABLE CHAR(1), 
	RND VARCHAR2(30), 
	WLEVEL CHAR(1), PRIMARY KEY (PK_LAYOUT) 
);
--/
DECLARE PT_LAYOUT_TEMPLATEExist INT;
BEGIN
select count(table_name) INTO PT_LAYOUT_TEMPLATEExist from user_tables where table_name = 'PT_LAYOUT_TEMPLATE';
IF PT_LAYOUT_TEMPLATEExist > 0 THEN
execute immediate 'drop table PT_LAYOUT_TEMPLATE';  
END IF;
END;
/
CREATE TABLE PT_LAYOUT_TEMPLATE ( 
	ID VARCHAR2(50) NOT NULL, 
	NAME VARCHAR2(100) NOT NULL, 
	TPL CLOB NOT NULL, 
	PK_LAYOUT_TEMPLATE VARCHAR2(22) NOT NULL, 
	I18N VARCHAR2(100), 
	SYSTEM VARCHAR2(50), 
	TENANT VARCHAR2(50), 
	PRIMARY KEY (PK_LAYOUT_TEMPLATE) 
);
--/
DECLARE PT_WIDGETExist INT;
BEGIN
select count(table_name) INTO PT_WIDGETExist from user_tables where table_name = 'PT_WIDGET';
IF PT_WIDGETExist > 0 THEN
execute immediate 'drop table PT_WIDGET';  
END IF;
END;
/
CREATE TABLE PT_WIDGET ( 
	ID VARCHAR2(50) NOT NULL, 
	NAME VARCHAR2(100) NOT NULL, 
	DESCR VARCHAR2(300), 
	CATEGORY VARCHAR2(50) NOT NULL, 
	WTYPE VARCHAR2(50) NOT NULL, 
	URL VARCHAR2(300) NOT NULL, 
	PK_WIDGET VARCHAR2(22) NOT NULL, 
	ISENABLE CHAR(1), 
	SYSTEM VARCHAR2(50), 
	TENANT VARCHAR2(50), 
	CTIME DATE, 
	CNF CLOB, 
	MODIFYTIME DATE, 
	PRIMARY KEY (PK_WIDGET) 
);
--/
DECLARE PT_WIDGET_CATEGORYExist INT;
BEGIN
select count(table_name) INTO PT_WIDGET_CATEGORYExist from user_tables where table_name = 'PT_WIDGET_CATEGORY';
IF PT_WIDGET_CATEGORYExist > 0 THEN
execute immediate 'drop table PT_WIDGET_CATEGORY';  
END IF;
END;
/
CREATE TABLE PT_WIDGET_CATEGORY ( 
	PK_CATEGORY VARCHAR2(22) NOT NULL, 
	ID VARCHAR2(50) NOT NULL, 
	NAME VARCHAR2(100) NOT NULL, 
	I18N VARCHAR2(100), 
	ISENABLE CHAR(1), 
	SORT INTEGER, 
	SYSTEM VARCHAR2(50), 
	TENANT VARCHAR2(50), 
	PRIMARY KEY (PK_CATEGORY) 
);
--/
DECLARE PT_WIDGET_PREFERENCEExist INT;
BEGIN
select count(table_name) INTO PT_WIDGET_PREFERENCEExist from user_tables where table_name = 'PT_WIDGET_PREFERENCE';
IF PT_WIDGET_PREFERENCEExist > 0 THEN
execute immediate 'drop table PT_WIDGET_PREFERENCE';  
END IF;
END;
/
CREATE TABLE PT_WIDGET_PREFERENCE (
	WIDGETID VARCHAR2(50) NOT NULL, 
	VIEWID VARCHAR2(50) NOT NULL, 
	ID VARCHAR2(50) NOT NULL, 
	NAME VARCHAR2(100), 
	VALUE VARCHAR2(100), 
	CTIME DATE, 
	PK_WIDGET_PREFERENCE VARCHAR2(22) NOT NULL, 
	USERID VARCHAR2(50), 
	SYSTEM VARCHAR2(50), 
	TENANT VARCHAR2(50), 
	PRIMARY KEY (PK_WIDGET_PREFERENCE) 
);
