/*!
 * Remark (http://getbootstrapadmin.com/remark)
 * Copyright 2015 amazingsurge
 * Licensed under the Themeforest Standard Licenses
 */
!function (window, document, $) {
    "use strict";
    var $body = $("body"), $html = $("html");
    $.site.menubar = {
        opened: null, folded: null, top: !1, foldAlt: !1, $instance: null, auto: !0, init: function () {
            if ($html.removeClass("css-menubar").addClass("js-menubar"), this.$instance = $(".site-menubar"), 0 !== this.$instance.length) {
                var self = this;
                $body.is(".site-menubar-top") && (this.top = !0), $body.is(".site-menubar-fold-alt") && (this.foldAlt = !0), ($body.data("autoMenubar") === !1 || $body.is(".site-menubar-keep")) && ($body.hasClass("site-menubar-fold") ? this.auto = "fold" : $body.hasClass("site-menubar-unfold") && (this.auto = "unfold")), this.$instance.on("changed.site.menubar", function () {
                    self.update()
                }), this.change()
            }
        }, change: function () {
            var breakpoint = Breakpoints.current();
            if (this.auto !== !0)switch (this.auto) {
                case"fold":
                    return this.reset(), void("xs" == breakpoint.name ? this.hide() : this.fold());
                case"unfold":
                    return this.reset(), void("xs" == breakpoint.name ? this.hide() : this.unfold())
            }
            if (this.reset(), breakpoint)switch (breakpoint.name) {
                case"lg":
                case"md":
                case"sm":
                    this.fold();
                    break;
                case"xs":
                    this.hide()
            }
        }, animate: function (doing, callback) {
            var self = this;
            $body.addClass("site-menubar-changing"), doing.call(self), this.$instance.trigger("changing.site.menubar"), setTimeout(function () {
                callback.call(self), $body.removeClass("site-menubar-changing"), self.$instance.trigger("changed.site.menubar")
            }, 500)
        }, reset: function () {
            this.opened = null, this.folded = null, $body.removeClass("site-menubar-hide site-menubar-open site-menubar-fold site-menubar-unfold"), $html.removeClass("disable-scrolling")
        }, open: function () {
            this.opened !== !0 && this.animate(function () {
                $body.removeClass("site-menubar-hide").addClass("site-menubar-open site-menubar-unfold"), this.opened = !0, $html.addClass("disable-scrolling")
            }, function () {
                this.scrollable.enable()
            })
        }, hide: function () {
            this.opened !== !1 && this.animate(function () {
                $html.removeClass("disable-scrolling"), $body.removeClass("site-menubar-open").addClass("site-menubar-hide site-menubar-unfold"), this.opened = !1
            }, function () {
                this.scrollable.enable()
            })
        }, unfold: function () {
            this.folded !== !1 && this.animate(function () {
                $body.removeClass("site-menubar-fold").addClass("site-menubar-unfold"), this.folded = !1, this.hoverTriggerOff()
            }, function () {
                this.scrollable.enable(), null !== this.folded && $.site.resize()
            })
        }, fold: function () {
            this.scrollable.disable(), this.folded !== !0 && this.animate(function () {
                $body.removeClass("site-menubar-unfold").addClass("site-menubar-fold"), this.folded = !0, this.hoverTrigger()
            }, function () {
                null !== this.folded && $.site.resize()
            })
        }, hoverTrigger: function () {
            var self = this;
            this.folded && this.$instance.on("mouseenter", function () {
                $body.addClass("site-menubar-hover"), setTimeout(function () {
                    self.scrollable.enable()
                }, 500)
            }).on("mouseleave", function () {
                $body.removeClass("site-menubar-hover");
                var api = self.$instance.data("mmenu");
                api && api.openPanel($("#mm-0")), setTimeout(function () {
                    self.scrollable.disable()
                }, 500)
            })
        }, hoverTriggerOff: function () {
            this.$instance.off("mouseenter"), this.$instance.off("mouseleave")
        }, toggle: function () {
            var breakpoint = Breakpoints.current(), folded = this.folded, opened = this.opened;
            switch (breakpoint.name) {
                case"lg":
                case"md":
                case"sm":
                    null === folded || folded === !0 ? this.unfold() : this.fold();
                    break;
                case"xs":
                    null === opened || opened === !1 ? this.open() : this.hide()
            }
        }, update: function () {
            this.scrollable.update()
        }, scrollable: {
            api: null, "native": !1, init: function () {
                return $body.is(".site-menubar-native") ? void(this["native"] = !0) : void(this.api = $.site.menubar.$instance.children(".mm-panels").asScrollable({
                    namespace: "scrollable",
                    skin: "scrollable-inverse",
                    direction: "vertical",
                    contentSelector: ">",
                    containerSelector: ">"
                }).data("asScrollable"))
            }, update: function () {
                this.api && this.api.update()
            }, enable: function () {
                this["native"] || (this.api || this.init(), this.api && this.api.enable())
            }, disable: function () {
                this.api && this.api.disable()
            }
        }
    }
}(window, document, jQuery);
