var sites = require('html!../../pages/layoutList.html');
var art = require('art');

var init = function () {
    var layoutInit = arguments.callee;

    $.ajax({
        url: contextRoot + "/layout/list?random="+Math.random(),
        dataType: 'json',
        type: 'get',
        contentType: 'application/json',
        success: function (res) {
            //var res = [{"pkLayout":"1212313","id":"test","name":"test","category":"test","template":"test1","desc":"","i18n":null}];
            for(var i=0;i<res.length;i++){
                if(res[i].modifytime){
                    res[i].modifytime = encodeURIComponent(res[i].modifytime);
                }
            }
            var data = {list: res};
            var render = art.compile(sites);
            var html = render(data);

            $('#content').html(html);

            $('#layoutList input').placeholder();

            var ipad= navigator.userAgent.indexOf("iPad");

            if(ipad!=-1||getBrowserVersion()=='IE8'){
                $('#site-save-open').hide();
                $('.page-content .icon-pencil').hide();
                $('.page-content .icons-l').removeClass('icons-l');
            }
            eventInit();
        },
        error: function (XMLHttpRequest) {
            errorLogin(XMLHttpRequest);
        }
    });

    function eventInit() {
        $('#layoutDel .btn-del').click(function(){
            var _this = this;
            var  id = $(this).attr("data-id");
            var data = {id:id}
            data = JSON.stringify(data);
            $('#layoutDel').on('hidden.bs.modal', function () {
                $.ajax({
                    url: contextRoot + "/layout/del/" + id+'?random='+Math.random(),
                    dataType: 'json',
                    type: 'get',
                    contentType: 'application/json',
                    success: function (res) {
                        //parent.remove();
                        layoutInit();
                    },
                    error: function (XMLHttpRequest) {
                        errorLogin(XMLHttpRequest);
                    }
                });
            })
            $('#layoutDel').modal('hide');
        });


        $('#layoutList').on('click','.layout-del',function () {


            var parent = $(this).closest('.col-md-3');
            var id = $(this).attr("data-id");

            $('#layoutDel').modal('show');
            $('#layoutDel .btn-del').attr('data-id',id);
        });





        $('#site-save-open,#site-save').on('click', function (e) {
            e.preventDefault();
            var _this = $(this);
            var name = $('#exampleName').val();
            var code = $('#code').val();
            var data = {name: name,id:code};
            var parm = JSON.stringify(data);


            var inputs = $('.dropdown-layout input');

            inputs.focus(function(){
                $('#errorMessage').html("");
            })
            function checkForm(){
                var success = false;
                $.each(inputs,function(i,item){
                    if($.trim($(item).val())==''){
                        $('#errorMessage').html('请输入必填项！');
                        success = true;
                        return true;
                    }
                })
                return success;
            }

            if(checkForm()){
                return false;
            }

            $.ajax({
                url: contextRoot + "/layout/save",
                dataType: 'json',
                type: 'post',
                data: parm,
                contentType: 'application/json',
                success: function (res) {


                    var minlayout = require('html!../../pages/minlayout.html');


                    if(res.status=='1'){
                        $('#exampleName').val('');
                    }
                    else {
                        alert(res.message);
                        return false;
                    }

                    var data = [
                        {
                            "id": res.data.id,
                            "name": name
                        }
                    ]
                    var render = art.compile(minlayout);
                    var html = render({list: data});


                    //console.log(html);
                    //$('.page-content .row').prepend(html);
                    //layoutInit();

                    if (_this.attr('id') == 'site-save-open'&&res.status=="1") {
                        setTimeout(function(){
                            location.href = '#/layout/'+res.data.id;
                            location.href = '#/layout/'+res.data.id+'/'+(res.data.modifytime||'modifytime')+'/back/layouts';
                        },100)
                        layoutInit();
                    }
                    else {
                        layoutInit();
                    }
                },
                error: function (XMLHttpRequest) {
                    errorLogin(XMLHttpRequest);
                }
            });
        });

    }

};

module.exports = {
    init: init
};