/*
 * Decompiled with CFR 0.152.
 */
package iuap.uitemplate.base.context;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import iuap.uitemplate.base.context.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class ContextLoaderListener
implements ServletContextListener {
    public void contextDestroyed(ServletContextEvent event) {
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext sc = event.getServletContext();
        String ctxPath = StringUtils.substringBeforeLast((String)sc.getRealPath("/"), (String)"\\");
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        lc.reset();
        try {
            configurator.doConfigure(ctxPath + "/WEB-INF/conf/log-conf/logback.xml");
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)lc);
            Platform.getUITemplatLogger().debug("===================UI\u6a21\u677f\u65e5\u5fd7\u5728D:/uitemplate_log/\u4e0b=====================================");
        }
        catch (JoranException e) {
            Platform.getUITemplatLogger().error(e.getMessage(), (Throwable)e);
        }
        try {
            InputStream in = sc.getResourceAsStream("/WEB-INF/conf/uitemplate.properties");
            Properties pro = new Properties();
            pro.load(in);
            String url = pro.getProperty("url");
            String username = pro.getProperty("username");
            String password = pro.getProperty("password");
            System.out.println(url);
            System.out.println(username);
            System.out.println(password);
        }
        catch (IOException e) {
            Platform.getUITemplatLogger().error("\u6a21\u677f\u914d\u7f6e\u6587\u4ef6\u9519\u8bef", (Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)Platform.getBaseHome())) {
            Platform.setBaseHome(ctxPath);
        }
        if (StringUtils.isEmpty((CharSequence)Platform.getTemplateBaseHome())) {
            String templatePath = StringUtils.substringBeforeLast((String)ctxPath, (String)"\\") + "\\uitemplate_web";
            Platform.setTemplateBaseHome(templatePath);
        }
        if (StringUtils.isEmpty((CharSequence)Platform.getTemplateQueryStrategy())) {
            Platform.setTemplateQueryStrategy("1");
        }
    }
}

