/*
 * Decompiled with CFR 0.152.
 */
package iuap.uitemplate.base.profile;

import com.yonyou.iuap.cache.SaasCacheManager;
import iuap.uitemplate.base.context.ContextHolder;
import iuap.uitemplate.base.context.InvocationInfoProxy;
import iuap.uitemplate.base.context.Platform;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SaasCacheAdaptor<V extends Serializable> {
    private Map<String, V> cache = null;
    private SaasCacheManager saasCacheMgr;
    private boolean isRedisType = false;
    private String coverup = "";

    public SaasCacheAdaptor(String pCoverup) {
        this.coverup = pCoverup + ":";
        if (StringUtils.endsWithIgnoreCase((String)Platform.getCacheType(), (String)"1")) {
            this.cache = new HashMap<String, V>();
        } else if (StringUtils.endsWithIgnoreCase((String)Platform.getCacheType(), (String)"2")) {
            this.saasCacheMgr = (SaasCacheManager)ContextHolder.getContext().getBean(SaasCacheManager.class);
            this.isRedisType = true;
        }
    }

    public V get(String key) {
        if (this.isRedisType) {
            return (V)this.saasCacheMgr.hget(InvocationInfoProxy.getInstance().getTenantId(), this.coverup, key);
        }
        return (V)((Serializable)this.cache.get(this.coverup + key));
    }

    public void put(String key, V value) {
        if (this.isRedisType) {
            this.saasCacheMgr.hset(InvocationInfoProxy.getInstance().getTenantId(), this.coverup, key, value);
        } else {
            this.cache.put(this.coverup + key, value);
        }
    }
}

