/*
 * Decompiled with CFR 0.152.
 */
package iuap.uitemplate.base.render;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import iuap.uitemplate.base.context.Platform;
import iuap.uitemplate.base.ex.BusinessException;
import iuap.uitemplate.base.render.TemplateFreeMarkerConfigurer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class RenderEngine {
    @Autowired
    TemplateFreeMarkerConfigurer cfg;

    public String render(Template template, SimpleHash root, boolean clearCache) throws BusinessException {
        try {
            if (clearCache) {
                this.cfg.getConfiguration().clearTemplateCache();
            }
            StringWriter out = new StringWriter();
            template.process((Object)root, (Writer)out);
            return ((Object)out).toString();
        }
        catch (TemplateException e) {
            Platform.getUITemplatLogger().error(e.getMessage(), (Throwable)e);
            throw new BusinessException(template.getName() + e.getMessage() + e.getFTLInstructionStack(), e.getCause());
        }
        catch (IOException e) {
            Platform.getUITemplatLogger().error(e.getMessage(), (Throwable)e);
            throw new BusinessException(e.getMessage(), e.getCause());
        }
    }

    public long getTplLastModify(String templateName) {
        TemplateLoader lader = this.cfg.getConfiguration().getTemplateLoader();
        try {
            return lader.getLastModified(lader.findTemplateSource(templateName));
        }
        catch (IOException e) {
            Platform.getUITemplatLogger().error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public String render(File templateFile, SimpleHash root) throws BusinessException {
        return this.render(templateFile, root, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String render(File templateFile, SimpleHash root, boolean clearCache) throws BusinessException {
        String string;
        FileInputStream in = null;
        try {
            in = new FileInputStream(templateFile);
            InputStreamReader reader = new InputStreamReader((InputStream)in, "UTF-8");
            if (clearCache) {
                this.cfg.getConfiguration().clearTemplateCache();
            }
            Template template = new Template(templateFile.getName(), (Reader)reader, this.cfg.getConfiguration());
            StringWriter out = new StringWriter();
            template.process((Object)root, (Writer)out);
            string = ((Object)out).toString();
        }
        catch (TemplateException e) {
            try {
                Platform.getUITemplatLogger().error(e.getMessage(), (Throwable)e);
                throw new BusinessException(templateFile.getName() + e.getMessage() + e.getFTLInstructionStack(), e.getCause());
                catch (IOException e2) {
                    Platform.getUITemplatLogger().error(e2.getMessage(), (Throwable)e2);
                    throw new BusinessException(e2.getMessage(), e2.getCause());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }

    public String render(String templateName, SimpleHash root, Configuration cfg) throws BusinessException {
        try {
            Template t = cfg.getTemplate(templateName);
            return this.render(t, root, false);
        }
        catch (IOException e) {
            Platform.getUITemplatLogger().error(e.getMessage(), (Throwable)e);
            throw new BusinessException(e.getMessage(), e.getCause());
        }
    }

    public String render(String templateName, SimpleHash root, boolean clearCache) throws BusinessException {
        try {
            Template t = this.cfg.getConfiguration().getTemplate(templateName);
            return this.render(t, root, clearCache);
        }
        catch (IOException e) {
            Platform.getUITemplatLogger().error(e.getMessage(), (Throwable)e);
            throw new BusinessException(e.getMessage(), e.getCause());
        }
    }

    public String render(String templateName, SimpleHash root) throws BusinessException {
        try {
            Template t = this.cfg.getConfiguration().getTemplate(templateName);
            return this.render(t, root, false);
        }
        catch (IOException e) {
            Platform.getUITemplatLogger().error(e.getMessage(), (Throwable)e);
            throw new BusinessException(e.getMessage(), e.getCause());
        }
    }
}

