/*
 * Decompiled with CFR 0.152.
 */
package iuap.uitemplate.base.render;

import freemarker.template.Configuration;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModelEx;
import iuap.uitemplate.base.context.Platform;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

public class TemplateFreeMarkerConfigurer
extends FreeMarkerConfigurer {
    private static String EXT_PATH = "classpath*:/uap/iweb/render/expansions/*.class";
    private static String EXT_PKG = "uap.iweb.render.expansions.";

    protected void postProcessConfiguration(Configuration config) throws IOException, TemplateException {
        super.postProcessConfiguration(config);
        TemplateFreeMarkerConfigurer.loadFreeMarkerFunctions(config);
    }

    private static void loadFreeMarkerFunctions(Configuration config) {
        PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();
        Resource[] ress = null;
        try {
            ress = patternResolver.getResources(EXT_PATH);
        }
        catch (IOException ex) {
            Platform.getUITemplatLogger().error("get freemarker extesion error  :" + ex.getMessage(), (Throwable)ex);
            return;
        }
        for (Resource res : ress) {
            String filename = res.getFilename();
            if (filename.indexOf("$") != -1) continue;
            String className = EXT_PKG + filename.substring(0, filename.length() - 6);
            try {
                Class<?> clazz = Class.forName(className);
                if (!TemplateMethodModelEx.class.isAssignableFrom(clazz) && !TemplateDirectiveModel.class.isAssignableFrom(clazz)) continue;
                String functionName = StringUtils.uncapitalize((String)clazz.getSimpleName());
                config.setSharedVariable(functionName, clazz.newInstance());
            }
            catch (Exception ex) {
                Platform.getUITemplatLogger().error("load freemarker function(" + className + ") error:" + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

