/*
 * Decompiled with CFR 0.152.
 */
package iuap.uitemplate.base.util.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import iuap.uitemplate.base.context.Platform;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Json2ObjectUtils {
    public static final String MAIN_TABLE = "maintable";
    public static final String SUB_TABLE = "subtable";
    public static final String HEAD_FORM = "headform";
    public static final String BODY_FORM = "bodyform";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFile(String path) {
        File file = new File(path);
        FileInputStream ins = null;
        String content = "";
        try {
            ins = new FileInputStream(file);
            byte[] byteArray = new byte[ins.available()];
            ins.read(byteArray);
            content = new String(byteArray, Charset.forName("UTF-8"));
        }
        catch (Exception e) {
            Platform.getUITemplatLogger().error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    Platform.getUITemplatLogger().error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return content;
    }

    public Map generateMap(String json) {
        String jsonString = this.readFile(json);
        Map<String, Object> jsonDataFileContent = Json2ObjectUtils.string2Map(jsonString);
        return jsonDataFileContent;
    }

    public List genetateListByMap(Map layDetailData) {
        Map layoutDetailAllData = (Map)layDetailData.get("formLayout");
        ArrayList<Object> result = new ArrayList<Object>();
        if (layoutDetailAllData.isEmpty()) {
            return result;
        }
        String layDelStr = (String)layoutDetailAllData.get("layoutDetail");
        Map<String, Object> layDelmap = Json2ObjectUtils.string2Map(layDelStr);
        Json2ObjectUtils.getDataJson(layDelmap, result);
        return result;
    }

    public Map generateMapByMap(Map layDetailData) {
        Map layoutDetailAllData = (Map)layDetailData.get("formLayout");
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList mainList = new ArrayList();
        ArrayList childList = new ArrayList();
        result.put(HEAD_FORM, mainList);
        Object layDelStr = layoutDetailAllData.get("layoutDetail");
        Map<String, Object> layDelmap = null;
        layDelmap = layDelStr instanceof Map ? (Map<String, Object>)layDelStr : Json2ObjectUtils.string2Map(layDelStr == null ? "" : layDelStr.toString());
        Json2ObjectUtils.getDataJsonMap(layDelmap, result, true);
        return result;
    }

    private static void getDataJsonMap(Map templateAllDataMap, Map<String, Object> resultMap, boolean isMain) {
        Object layoutDetail = templateAllDataMap.get("layoutDetail");
        if (layoutDetail != null && layoutDetail instanceof ArrayList) {
            ArrayList alist = (ArrayList)layoutDetail;
            int subLen = 0;
            for (Object o : alist) {
                if (!(o instanceof Map)) continue;
                Map map = (Map)o;
                boolean isSubTable = Json2ObjectUtils.isSubTable((String)map.get("componentKey"));
                Object sonDetail = map.get("layoutDetail");
                if ("GroupTable".equals(String.valueOf(map.get("componentKey")))) {
                    Json2ObjectUtils.getDataJsonMap((Map)((ArrayList)map.get("layoutDetail")).get(0), resultMap, isMain);
                    continue;
                }
                if (sonDetail != null) {
                    ArrayList sonlist;
                    if (!isSubTable) {
                        sonlist = (ArrayList)sonDetail;
                        for (Object sonl : sonlist) {
                            if (!(sonl instanceof Map)) continue;
                            Json2ObjectUtils.getDataJson((Map)sonl, (List)resultMap.get(HEAD_FORM));
                        }
                        continue;
                    }
                    if (!isSubTable) continue;
                    ++subLen;
                    sonlist = (ArrayList)sonDetail;
                    Object defaultRows = map.get("defaultRows");
                    Object borderColor = map.get("borderColor");
                    Object subFormId = map.get("subFormId");
                    String bodyformId = "bodyform_" + subFormId.toString();
                    for (Object sonl : sonlist) {
                        if (!(sonl instanceof Map)) continue;
                        if (defaultRows != null) {
                            ((Map)sonl).put("defaultRows", defaultRows);
                        }
                        if (borderColor != null && !"".equals(borderColor)) {
                            ((Map)sonl).put("subBorderColor", borderColor);
                        }
                        if (!resultMap.containsKey(bodyformId)) {
                            resultMap.put(bodyformId.toString(), new ArrayList());
                        }
                        Json2ObjectUtils.getDataJson((Map)sonl, (List)resultMap.get(bodyformId));
                    }
                    continue;
                }
                if (sonDetail != null || isSubTable) continue;
                ((List)resultMap.get(HEAD_FORM)).add(map);
            }
        } else {
            boolean isBase = Json2ObjectUtils.isBaseComp((String)templateAllDataMap.get("componentKey"));
            if (isBase) {
                ((List)resultMap.get(HEAD_FORM)).add(templateAllDataMap);
            }
        }
    }

    private static void getDataJson(Map templateAllDataMap, List<Object> list) {
        boolean isBase;
        Object layoutDetail = templateAllDataMap.get("layoutDetail");
        if (layoutDetail != null && layoutDetail instanceof ArrayList) {
            ArrayList alist = (ArrayList)layoutDetail;
            for (Object o : alist) {
                if (!(o instanceof Map)) continue;
                Map map = (Map)o;
                boolean isBase2 = Json2ObjectUtils.isBaseComp((String)map.get("componentKey"));
                boolean isSubTable = Json2ObjectUtils.isSubTable((String)map.get("componentKey"));
                Object sonDetail = map.get("layoutDetail");
                if (sonDetail != null) {
                    ArrayList sonlist;
                    if (!isBase2) {
                        sonlist = (ArrayList)sonDetail;
                        for (Object sonl : sonlist) {
                            if (!(sonl instanceof Map)) continue;
                            Json2ObjectUtils.getDataJson((Map)sonl, list);
                        }
                        continue;
                    }
                    if (!isSubTable) continue;
                    sonlist = (ArrayList)sonDetail;
                    for (Object sonl : sonlist) {
                        if (!(sonl instanceof Map)) continue;
                        Json2ObjectUtils.getDataJson((Map)sonl, list);
                    }
                    continue;
                }
                if (sonDetail != null || !isBase2) continue;
                list.add(map);
            }
        } else if (templateAllDataMap.get("componentKey") != null && !"".equals(templateAllDataMap.get("componentKey")) && (isBase = Json2ObjectUtils.isBaseComp((String)templateAllDataMap.get("componentKey")))) {
            list.add(templateAllDataMap);
        }
    }

    private static boolean isBaseComp(String componentKey) {
        return !"ColumnPanel".equals(componentKey) && !"TableLayout".equals(componentKey);
    }

    private static boolean isSubTable(String componentKey) {
        return "DataTable".equals(componentKey) || "Table".equals(componentKey) || "Form".equals(componentKey) || "Grid".equals(componentKey) || "GroupTable".equals(componentKey);
    }

    public static Map<String, Object> string2Map(String jsonString) {
        ObjectMapper maper = new ObjectMapper();
        HashMap<String, Object> jsonDataFileContent = new HashMap();
        try {
            jsonDataFileContent = (Map)maper.readValue(jsonString, HashMap.class);
        }
        catch (IOException e) {
            Platform.getUITemplatLogger().error(e.getMessage(), (Throwable)e);
        }
        return jsonDataFileContent;
    }
}

