/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.bpm.trace;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.MDC;

public class LoggingTracer {
    private static boolean enable = false;
    private Set<String> traceKeys = new HashSet<String>();

    private LoggingTracer() {
    }

    public void set(String key, String value) {
        if (enable && key != null && value != null) {
            MDC.put((String)key, (String)value);
            this.traceKeys.add(key);
        }
    }

    public void remove(String key) {
        MDC.remove((String)key);
        this.traceKeys.remove(key);
    }

    public void clear() {
        for (String key : this.traceKeys) {
            MDC.remove((String)key);
        }
    }

    protected void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }

    public static LoggingTracer newLocalTrace() {
        return new LoggingTracer();
    }

    public static void setTrace(String key, String value) {
        if (enable && key != null && value != null) {
            MDC.put((String)key, (String)value);
        }
    }

    public static String getTrace(String key) {
        if (enable) {
            return MDC.get((String)key);
        }
        return null;
    }

    public static void removeTrace(String key) {
        MDC.remove((String)key);
    }

    public static void clearTrace() {
        MDC.clear();
    }

    public static boolean isEnable() {
        return enable;
    }

    public static void setEnable(boolean enable) {
        LoggingTracer.enable = enable;
    }
}

