/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.bpm.trace;

import com.yonyou.bpm.trace.TraceValueResolve;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public class TraceValueResolves {
    public static final String SINGLE_VALUE = "com.yonyou.bpm.trace.TraceValueResolves.SingleValueResolver";
    public static final String COLLECTION_VALUE = "com.yonyou.bpm.trace.TraceValueResolves.CollectionValueResolver";
    public static final TraceValueResolve SINGLE_VALUE_RESOLVER = new SingleValueResolver();
    public static final TraceValueResolve COLLECTION_VALUE_RESOLVER = new SingleValueResolver();

    public static class CollectionValueResolver
    implements TraceValueResolve {
        private static final String PREFIX = "[";
        private static final String SUBFIX = "]";
        private static final String SEPERATOR = ",";

        @Override
        public String resolve(Object arg) {
            if (arg == null) {
                return "NULL";
            }
            StringBuilder strValue = new StringBuilder();
            if (arg instanceof Collection) {
                Collection coll = (Collection)arg;
                strValue.append(PREFIX);
                Iterator args = coll.iterator();
                if (!coll.isEmpty()) {
                    strValue.append(SINGLE_VALUE_RESOLVER.resolve(args.next()));
                }
                while (args.hasNext()) {
                    strValue.append(SEPERATOR);
                    strValue.append(SINGLE_VALUE_RESOLVER.resolve(args.next()));
                }
                strValue.append(SUBFIX);
            } else if (arg.getClass().isArray()) {
                strValue.append(PREFIX);
                int len = Array.getLength(arg);
                if (len > 0) {
                    strValue.append(SINGLE_VALUE_RESOLVER.resolve(Array.get(arg, 0)));
                }
                for (int i = 1; i < len; ++i) {
                    strValue.append(SEPERATOR);
                    strValue.append(SINGLE_VALUE_RESOLVER.resolve(Array.get(arg, i)));
                }
                strValue.append(SUBFIX);
            } else {
                strValue.append(SINGLE_VALUE_RESOLVER.resolve(arg));
            }
            return strValue.toString();
        }
    }

    public static class SingleValueResolver
    implements TraceValueResolve {
        @Override
        public String resolve(Object arg) {
            return arg == null ? "NULL" : arg.toString();
        }
    }
}

