/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.bpm.utils;

import org.springframework.core.env.Environment;

public class EnvironmentProperties {
    private Environment env;

    public EnvironmentProperties(Environment env) {
        this.env = env;
    }

    public String getString(String name) {
        return this.env.getProperty(name);
    }

    public String getString(String name, String defaultValue) {
        return this.env.getProperty(name, defaultValue);
    }

    public String getTrimedString(String name) {
        return this.getTrimedString(name, "");
    }

    public String getTrimedString(String name, String defaultValue) {
        String value = this.env.getProperty(name, defaultValue);
        return value == null ? "" : value.trim();
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public int getInt(String name, int defaultValue) {
        String value = this.getTrimedString(name);
        return value.length() == 0 ? defaultValue : Integer.parseInt(value);
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.getTrimedString(name);
        return value.length() == 0 ? defaultValue : Boolean.parseBoolean(value);
    }
}

