/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.bpm.utils;

import com.yonyou.bpm.utils.EncodingUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5InputStream
extends InputStream {
    private DigestInputStream digestInputStream;
    private String md5 = null;

    public MD5InputStream(InputStream innerInput) {
        try {
            this.digestInputStream = new DigestInputStream(innerInput, MessageDigest.getInstance("MD5"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public int read() throws IOException {
        return this.digestInputStream.read();
    }

    public String getMD5() {
        if (this.md5 == null) {
            throw new IllegalStateException("The md5 of stream is not generated before close stream!");
        }
        return this.md5;
    }

    @Override
    public void close() throws IOException {
        if (this.md5 == null) {
            MessageDigest digest = this.digestInputStream.getMessageDigest();
            byte[] md5Bytes = digest.digest();
            this.md5 = EncodingUtil.md5ByteToBase64String(md5Bytes);
            this.digestInputStream.close();
        }
    }
}

