/*** Eclipse Class Decompiler plugin, copyright (c) 2016 Chen Chao (cnfree2000@hotmail.com) ***/
package com.yonyou.bpm.core.impl;

import com.yonyou.bpm.core.cmdimpl.BpmUserFilterQueryImpl;
import com.yonyou.bpm.core.userfilter.UserFilter;
import com.yonyou.bpm.core.userfilter.UserFilterService;
import com.yonyou.bpm.utils.BeanUtils;
import java.util.List;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.apache.ibatis.session.SqlSessionFactory;

public class UserFilterServiceImpl implements UserFilterService {
	private static final String NAMESPACE = "com.yonyou.bpm.engine.mapper.UserFilterMapper";
	private SqlSessionFactory sqlSessionFactory;
	private CommandExecutor commandExecutor;

	public UserFilterServiceImpl(SqlSessionFactory sqlSessionFactory) {
		this.sqlSessionFactory = sqlSessionFactory;
	}

	public List<? extends UserFilter> query(UserFilterQueryParam queryParam) {
		BpmUserFilterQueryImpl queryImpl = new BpmUserFilterQueryImpl();
		BeanUtils.copyProperties(queryImpl, queryParam);
		queryImpl.setCommandExecutor(this.commandExecutor);
		return queryImpl.listPage(queryParam.getFirstResult(), queryParam.getMaxResults());
	}

	public CommandExecutor getCommandExecutor() {
		return this.commandExecutor;
	}

	public void setCommandExecutor(CommandExecutor commandExecutor) {
		this.commandExecutor = commandExecutor;
	}
}