package com.yonyou.bpm.editor.language.json.converter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.JsonParser.NumberType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yonyou.bpm.core.category.Category;
import com.yonyou.bpm.message.config.MessageSendConfig;
import com.yonyou.bpm.message.defaultImpl.DefaultMessageSendAdateper;
import com.yonyou.bpm.model.ApproveUserTask;
import com.yonyou.bpm.participant.ProcessParticipant;
import com.yonyou.bpm.participant.ProcessParticipantDetail;
import com.yonyou.bpm.participant.ProcessParticipantItem;
import com.yonyou.bpm.participant.config.ParticipantConfig;
import com.yonyou.bpm.server.BpmServiceUtils;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class ApproveUserTaskJsonConverter extends BaseBpmnJsonConverter
{
  protected static final Logger LOGGER = LoggerFactory.getLogger(BaseBpmnJsonConverter.class);

  public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap)
  {
    fillJsonTypes(convertersToBpmnMap);
    fillBpmnTypes(convertersToJsonMap);
  }

  public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
    convertersToBpmnMap.put("ApproveUserTask", ApproveUserTaskJsonConverter.class);
  }

  public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
    convertersToJsonMap.put(ApproveUserTask.class, ApproveUserTaskJsonConverter.class);
  }

  protected String getStencilId(BaseElement baseElement)
  {
    return "ApproveUserTask";
  }

  protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement)
  {
    ApproveUserTask userTask = (ApproveUserTask)baseElement;
    String currentUser = null;
    if (userTask.getLoopCharacteristics() != null)
      currentUser = userTask.getLoopCharacteristics().getInputDataItem();
    ObjectMapper objectMapper = new ObjectMapper();

    JsonNode allNode = null;
    boolean participant = false;
    if (currentUser != null)
    {
      if (currentUser.indexOf("${bpmBean.getUser") != -1)
      {
        currentUser = currentUser.substring(currentUser.indexOf("${bpmBean.getUser") + "${bpmBean.getUser(\"".length(), currentUser.length() - 3);
        currentUser = currentUser.replaceAll("'", "\"");
        if ((currentUser != null) && (!currentUser.isEmpty()) && (currentUser.length() > 0))
        {
          try {
            allNode = objectMapper.readTree(currentUser);
          } catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), e);
          } catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
          }
          int len = allNode == null ? 0 : allNode.get("processParticipantItems") == null ? 0 : allNode.get("processParticipantItems").size();
          for (int i = 0; i < len; i++)
          {
            if ((allNode.get("processParticipantItems").get(i) != null) && (!allNode.get("processParticipantItems").get(i).isNull()))
            {
              Map userServiceImpl = BpmServiceUtils.getBpmEngineConfiguration().getParticipantService().getParticipantConfigs();
              Collection c = userServiceImpl.values();
              Iterator it = c.iterator();
              while (it.hasNext()) {
                ParticipantConfig tempConfig = (ParticipantConfig)it.next();
                if (allNode.get("processParticipantItems").get(i).get("sameorg").asBoolean())
                {
                  setPropertyValue("issameorg", "true", propertiesNode);
                }
                if (allNode.get("processParticipantItems").get(i).get("type").asText().equals(tempConfig.getCode()))
                {
                  List jsonArray = new ArrayList();
                  JsonNode otherObject = allNode.get("processParticipantItems").get(i).get("details");
                  boolean typeBoolean = true;
                  for (int j = 0; j < otherObject.size(); j++)
                  {
                    typeBoolean = false;
                    if ((otherObject.get(0).get("others") != null) && (!otherObject.get(0).get("others").toString().equals("{}")) && (!otherObject.get(0).get("others").toString().equals("null")))
                      jsonArray.add(otherObject.get(j).get("others").toString());
                  }
                  if ((jsonArray != null) && (jsonArray.size() > 0))
                  {
                    ObjectNode participantNode = BpmnJsonConverterUtil.convertRefValue(jsonArray);
                    propertiesNode.put(tempConfig.getCode().toLowerCase(), participantNode);
                    participant = true;
                  }
                  else if (typeBoolean)
                  {
                    propertiesNode.put(tempConfig.getCode().toLowerCase(), true);
                    participant = true;
                  }
                }
              }
            }
          }
        }
      }

    }

    if (userTask.isForCompensation())
      setPropertyValue("forcompensation", "true", propertiesNode);
    else
      setPropertyValue("forcompensation", "false", propertiesNode);
    if (userTask.getPriority() != null) {
      setPropertyValue("multiinstance_priority", userTask.getPriority().toString(), propertiesNode);
    }
    if (StringUtils.isNotEmpty(userTask.getFormKey())) {
      setPropertyValue("formkeydefinition", userTask.getFormKey(), propertiesNode);
    }
    if ((userTask.getAssignAble() != null) && (userTask.getAssignAble().booleanValue()))
      setPropertyValue("assignable", userTask.getAssignAble().toString(), propertiesNode);
    if ((userTask.getIsformEditable() != null) && (userTask.getIsformEditable().booleanValue()))
      setPropertyValue("isformeditable", userTask.getIsformEditable().toString(), propertiesNode);
    if ((userTask.getAddsignAble() != null) && (userTask.getAddsignAble().booleanValue()))
      setPropertyValue("addsignable", userTask.getAddsignAble().toString(), propertiesNode);
    if ((userTask.getRejectAble() != null) && (userTask.getRejectAble().booleanValue()))
      setPropertyValue("rejectable", userTask.getRejectAble().toString(), propertiesNode);
    if ((userTask.getDelegateAble() != null) && (userTask.getDelegateAble().booleanValue()))
      setPropertyValue("delegateable", userTask.getDelegateAble().toString(), propertiesNode);
    setPropertyValue("duedatedefinition", userTask.getDueDate(), propertiesNode);
    setPropertyValue("categorydefinition", userTask.getCategory(), propertiesNode);
    if (userTask.getApproveType() != null) {
      setPropertyValue("approveType", userTask.getApproveType(), propertiesNode);
    }

    if (userTask.getLoopCharacteristics() != null) {
      MultiInstanceLoopCharacteristics loopDef = userTask.getLoopCharacteristics();
      if ((StringUtils.isNotEmpty(loopDef.getLoopCardinality())) || (StringUtils.isNotEmpty(loopDef.getInputDataItem())) || (StringUtils.isNotEmpty(loopDef.getCompletionCondition())))
      {
    	  if (loopDef.getParticipantType()!=null)
              propertiesNode.put("multiinstance_person", loopDef.getParticipantType());
       
        if (loopDef.isSequential())
          propertiesNode.put("multiinstance_model", "Sequential");
        else if ((loopDef.getCompletionCondition() != null) && (loopDef.getCompletionCondition().equals("${nrOfCompletedInstances==1}")))
          propertiesNode.put("multiinstance_model", "Grab");
        else if ((loopDef.getCompletionCondition() != null) && (loopDef.getCompletionCondition().equals("${nrOfCompletedInstances/nrOfInstances==1}")))
          propertiesNode.put("multiinstance_model", "Sign");
        else {
          propertiesNode.put("multiinstance_model", "Parallel");
        }

        if (StringUtils.isNotEmpty(loopDef.getLoopCardinality())) {
          propertiesNode.put("multiinstance_cardinality", loopDef.getLoopCardinality());
        }
        if ((!participant) && (StringUtils.isNotEmpty(loopDef.getInputDataItem()))) {
          propertiesNode.put("multiinstance_collection", loopDef.getInputDataItem());
        }

        if (StringUtils.isNotEmpty(loopDef.getElementVariable())) {
          propertiesNode.put("multiinstance_variable", loopDef.getElementVariable());
        }
        if (StringUtils.isNotEmpty(loopDef.getCompletionCondition())) {
          propertiesNode.put("multiinstance_condition", loopDef.getCompletionCondition());
        }
      }
    }
    addFormProperties(userTask.getFormProperties(), propertiesNode);
  }

  protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap)
  {
    ApproveUserTask task = new ApproveUserTask();
    task.setPriority(getPropertyValueAsString("multiinstance_priority", elementNode));
    String formKey = getPropertyValueAsString("formkeydefinition", elementNode);
    if (StringUtils.isNotEmpty(formKey)) {
      task.setFormKey(formKey);
    }
    String cashier = getPropertyValueAsString("approveType", elementNode);
    if (cashier == null)
      cashier = getPropertyValueAsString("approvetype", elementNode);
    if (StringUtils.isNotEmpty(cashier)) {
      task.setApproveType(cashier);
    }
    String duedate=getPropertyValueAsString(PROPERTY_USERTASK_PARAM_DUEDATE, elementNode);
    
    String duedateday=getPropertyValueAsString(PROPERTY_USERTASK_DAY_DUEDATE, elementNode);
    String duedatehour=getPropertyValueAsString(PROPERTY_USERTASK_HOUR_DUEDATE, elementNode);
    String dayAndHour="";
    if(duedateday!=null&&StringUtils.isNotEmpty(duedateday)){
    	int day=Integer.parseInt(duedateday);
    	if(day>0)
    		dayAndHour=day+"day";
    }
    if(duedatehour!=null&&StringUtils.isNotEmpty(duedatehour)){
    	int hour=Integer.parseInt(duedatehour);
    	if(hour>0)
    		dayAndHour=dayAndHour+hour+"hour";
    }
    if(!dayAndHour.equals("")&&dayAndHour.length()>0)
    	task.setDueDate(dayAndHour);
    else if(duedate!=null&&StringUtils.isNotEmpty(duedate))
    	task.setDueDate(duedate);
    else
    	task.setDueDate(getPropertyValueAsString(PROPERTY_USERTASK_DUEDATE, elementNode));

    task.setCategory(getPropertyValueAsString("categorydefinition", elementNode));

    if ((task.getCategory() == null) && (modelNode.get("category") != null)) {
      String category = modelNode.get("category").asText();
      task.setCategory(category);
    }
    JsonNode isSameorgJsonNode = getProperty("issameorg", elementNode);
    Boolean isSameorg = Boolean.valueOf(false);
    if (isSameorgJsonNode != null) {
      isSameorg = Boolean.valueOf(isSameorgJsonNode.asBoolean());
    }

    JsonNode allUser = getProperty("multiinstance_collection", elementNode);
    String allUserString = null;

    String userfiltertype = getPropertyValueAsString("userfiltertype", elementNode);
    String multiInstancePerson = getPropertyValueAsString("multiinstance_person", elementNode);
    ProcessParticipantItem participantXmlNode = null;
    ProcessParticipant processParticipant = new ProcessParticipant();
    List processParticipantItemList = new ArrayList();
    Map userServiceImpl = BpmServiceUtils.getBpmEngineConfiguration().getParticipantService().getParticipantConfigs();
    Collection c = userServiceImpl.values();
    Iterator it = c.iterator();
    while (it.hasNext()) {
      ParticipantConfig tempConfig = (ParticipantConfig)it.next();
      JsonNode participantNode = getProperty(tempConfig.getCode().toLowerCase(), elementNode);
      if (participantNode != null&&multiInstancePerson.equalsIgnoreCase(tempConfig.getCode())) {
        JsonNode participantDefNode = participantNode.get("refResultData");        
        if(multiInstancePerson.equals("HEADPENSER")){
        	//部门负责人       	
        	ProcessParticipantItem xmlNode = new ProcessParticipantItem();
        	xmlNode.setType(tempConfig.getCode());
             if (isSameorg.booleanValue())
            	 xmlNode.setSameorg(true);            
             processParticipantItemList.add(xmlNode);
        }else if((participantDefNode != null) && (participantDefNode.size() > 0)) {
          participantXmlNode = BpmnJsonConverterUtil.convertRefDataToXmlData(participantDefNode);
          participantXmlNode.setType(tempConfig.getCode());
          if (isSameorg.booleanValue())
            participantXmlNode.setSameorg(true);
          //�û�������
          if ((userfiltertype != null) && (!(userfiltertype.equals("none"))))
              participantXmlNode.setUserfilter(userfiltertype);
          processParticipantItemList.add(participantXmlNode);
          
          
        } else if (participantNode.asBoolean())
        {
          participantXmlNode = new ProcessParticipantItem();
          participantXmlNode.setType(tempConfig.getCode());
          if (isSameorg.booleanValue())
            participantXmlNode.setSameorg(true);
          processParticipantItemList.add(participantXmlNode);
        }

      }

    }

    if (processParticipantItemList.size() == 0)
    {
      String candidateids = getPropertyValueAsString("candidateids", elementNode);
      String usergroupids = getPropertyValueAsString("usergroupids", elementNode);
      String userorgids = getPropertyValueAsString("userorgids", elementNode);
      String deptmanager = getPropertyValueAsString("deptmanager", elementNode);
      String userpostids = getPropertyValueAsString("userpostids", elementNode);
      if ((candidateids != null) && (candidateids.length() > 1))
      {
        String[] candidateArray = candidateids.split(";");
        if (candidateArray.length > 0)
        {
          ProcessParticipantItem candidateXmlNode = new ProcessParticipantItem();
          candidateXmlNode.setType("USER");
          ProcessParticipantDetail[] processParticipantDetail = new ProcessParticipantDetail[candidateArray.length];
          for (int i = 0; i < candidateArray.length; i++)
          {
            if (candidateArray[i].trim().length() > 0)
            {
              processParticipantDetail[i] = new ProcessParticipantDetail();
              processParticipantDetail[i].setId(candidateArray[i].trim());
            }
          }
          candidateXmlNode.setDetails(processParticipantDetail);
          if (isSameorg.booleanValue())
            candidateXmlNode.setSameorg(true);
          //�û�������
          if (userfiltertype != null)
              candidateXmlNode.setUserfilter(userfiltertype);
          processParticipantItemList.add(candidateXmlNode);
        }
      }
      if ((usergroupids != null) && (usergroupids.length() > 1))
      {
        String[] usergroupArray = usergroupids.split(";");
        if (usergroupArray.length > 0)
        {
          ProcessParticipantItem usergroupXmlNode = new ProcessParticipantItem();
          usergroupXmlNode.setType("USERGROUPS");
          ProcessParticipantDetail[] processParticipantDetail = new ProcessParticipantDetail[usergroupArray.length];
          for (int i = 0; i < usergroupArray.length; i++)
          {
            if (usergroupArray[i].trim().length() > 0)
            {
              processParticipantDetail[i] = new ProcessParticipantDetail();
              processParticipantDetail[i].setId(usergroupArray[i].trim());
            }
          }
          usergroupXmlNode.setDetails(processParticipantDetail);
          if (isSameorg.booleanValue())
            usergroupXmlNode.setSameorg(true);
          //�û�������
          if (userfiltertype != null)
              usergroupXmlNode.setUserfilter(userfiltertype);
          processParticipantItemList.add(usergroupXmlNode);
        }
      }
      if ((userorgids != null) && (userorgids.length() > 1))
      {
        String[] userorgArray = userorgids.split(";");
        if (userorgArray.length > 0)
        {
          ProcessParticipantItem userorgXmlNode = new ProcessParticipantItem();
          userorgXmlNode.setType("USERORGS");
          ProcessParticipantDetail[] processParticipantDetail = new ProcessParticipantDetail[userorgArray.length];
          for (int i = 0; i < userorgArray.length; i++)
          {
            if (userorgArray[i].trim().length() > 0)
            {
              processParticipantDetail[i] = new ProcessParticipantDetail();
              processParticipantDetail[i].setId(userorgArray[i].trim());
            }
          }
          userorgXmlNode.setDetails(processParticipantDetail);
          if (isSameorg.booleanValue())
        	  userorgXmlNode.setSameorg(true);
          //�û�������
          if (userfiltertype != null)
        	  userorgXmlNode.setUserfilter(userfiltertype);
          processParticipantItemList.add(userorgXmlNode);
        }
      }
      if ((userpostids != null) && (userpostids.length() > 1))
      {
        String[] userpostArray = userpostids.split(";");
        if (userpostArray.length > 0)
        {
          ProcessParticipantItem userpostXmlNode = new ProcessParticipantItem();
          userpostXmlNode.setType("POSTS");
          ProcessParticipantDetail[] processParticipantDetail = new ProcessParticipantDetail[userpostArray.length];
          for (int i = 0; i < userpostArray.length; i++)
          {
            if (userpostArray[i].trim().length() > 0)
            {
              processParticipantDetail[i] = new ProcessParticipantDetail();
              processParticipantDetail[i].setId(userpostArray[i].trim());
            }
          }
          userpostXmlNode.setDetails(processParticipantDetail);
          if (isSameorg.booleanValue())
            userpostXmlNode.setSameorg(true);
        //�û�������
          if (userfiltertype != null)
        	  userpostXmlNode.setUserfilter(userfiltertype);
          processParticipantItemList.add(userpostXmlNode);
        }
      }
      if ((deptmanager != null) && (deptmanager.equals("true")))
      {
        ProcessParticipantItem deptmanagerXmlNode = new ProcessParticipantItem();
        deptmanagerXmlNode.setType("ORGMGR");
        if (isSameorg.booleanValue())
          deptmanagerXmlNode.setSameorg(true);
        //�û�������
        if (userfiltertype != null)
        	deptmanagerXmlNode.setUserfilter(userfiltertype);
        processParticipantItemList.add(deptmanagerXmlNode);
      }
    }
    if (processParticipantItemList.size() > 0) {
      processParticipant.setProcessParticipantItems((ProcessParticipantItem[])processParticipantItemList.toArray(new ProcessParticipantItem[processParticipantItemList.size()]));
      String json = processParticipant.toJSONStr().replaceAll("\"", "'");
      allUserString = "${bpmBean.getUser(\"" + json + "\")}";
    }
    String multiInstanceType = getPropertyValueAsString("multiinstance_model", elementNode);
    String multiInstanceCardinality = getPropertyValueAsString("multiinstance_cardinality", elementNode);
    String multiInstanceCondition = getPropertyValueAsString("multiinstance_condition", elementNode);

    String multiInstanceVariable = getPropertyValueAsString("multiinstance_variable", elementNode);

    MultiInstanceLoopCharacteristics multiInstanceObject = new MultiInstanceLoopCharacteristics();

    multiInstanceObject.setLoopCardinality(multiInstanceCardinality);
    if (allUserString != null)
      multiInstanceObject.setInputDataItem(allUserString);
    else if ((allUser != null) && (allUser.asText() != null))
      multiInstanceObject.setInputDataItem(allUser.asText());
    multiInstanceObject.setElementVariable("assignee");
    if (processParticipantItemList.size() > 0)
    {
        if(multiInstanceCondition==null||multiInstanceCondition.length()==0)
            multiInstanceCondition="${nrOfCompletedInstances==1}";
         multiInstanceObject.setSequential(false);
      
          if ("Grab".equalsIgnoreCase(multiInstanceType)&&multiInstanceObject.getInputDataItem()!=null) {
              multiInstanceObject.setSequential(false);
              multiInstanceCondition="${nrOfCompletedInstances==1}";
          } else if("Sign".equalsIgnoreCase(multiInstanceType)&&multiInstanceObject.getInputDataItem()!=null){
              multiInstanceObject.setSequential(false);
              multiInstanceCondition="${nrOfCompletedInstances/nrOfInstances==1}";
          } else if("Sequential".equalsIgnoreCase(multiInstanceType)){
              multiInstanceObject.setSequential(true);
              multiInstanceCondition="";
          } else if("Parallel".equalsIgnoreCase(multiInstanceType)){
              multiInstanceObject.setSequential(false);
          }
          multiInstanceObject.setCompletionCondition(multiInstanceCondition);
          task.setLoopCharacteristics(multiInstanceObject);
       
    }

    if (allUser != null) {
      task.setAssignee("${assignee}");
    }
    JsonNode jsonNode = getProperty("assignable", elementNode);
    Boolean assignAble = null;
    if (jsonNode != null) {
      assignAble = Boolean.valueOf(jsonNode.asBoolean());
    }
    if ((assignAble != null) && (assignAble.booleanValue()))
      task.setAssignAble(assignAble);
    else {
      task.setAssignAble(Boolean.valueOf(false));
    }

    jsonNode = getProperty("isformeditable", elementNode);
    Boolean isformEditable = null;
    if (jsonNode != null) {
      isformEditable = Boolean.valueOf(jsonNode.asBoolean());
    }
    if ((isformEditable != null) && (isformEditable.booleanValue()))
      task.setIsformEditable(isformEditable);
    else {
      task.setIsformEditable(Boolean.valueOf(false));
    }

    jsonNode = getProperty("addsignable", elementNode);
    Boolean addsignable = null;
    if (jsonNode != null) {
      addsignable = Boolean.valueOf(jsonNode.asBoolean());
    }
    if ((addsignable != null) && (addsignable.booleanValue()))
      task.setAddsignAble(addsignable);
    else {
      task.setAddsignAble(Boolean.valueOf(false));
    }
    jsonNode = getProperty("rejectable", elementNode);
    Boolean rejectAble = null;
    if (jsonNode != null) {
      rejectAble = Boolean.valueOf(jsonNode.asBoolean());
    }
    if ((rejectAble != null) && (rejectAble.booleanValue()))
      task.setRejectAble(rejectAble);
    else
      task.setRejectAble(Boolean.valueOf(false));
    jsonNode = getProperty("delegateable", elementNode);
    Boolean delegateAble = null;
    if (jsonNode != null) {
      delegateAble = Boolean.valueOf(jsonNode.asBoolean());
    }
    if ((delegateAble != null) && (delegateAble.booleanValue()))
      task.setDelegateAble(delegateAble);
    else
      task.setDelegateAble(Boolean.valueOf(false));
    if ((modelNode.get("category") != null) && (!modelNode.get("category").isNull()))
    {
      Category category = BpmServiceUtils.getCategoryService().getCategoryById(modelNode.get("category").asText());
      if (category != null)
      {
        String operations = category.getOperations();
        if (operations != null)
        {
          JSONArray array = JSONArray.fromObject(operations);
          String operationsSelected = "";
          String operationsUnSelected = "";
          for (int i = 0; i < array.size(); i++)
          {
            JSONObject operate = JSONObject.fromObject(array.get(i));
            jsonNode = getProperty(operate.getString("code").toString(), elementNode);
            Boolean selected = Boolean.valueOf(false);
            if (jsonNode != null) {
              selected = Boolean.valueOf(jsonNode.asBoolean());
            }
            if ((selected != null) && (selected.booleanValue()))
            {
              if (operationsSelected == "")
                operationsSelected = operate.getString("code");
              else {
                operationsSelected = operationsSelected + "," + operate.getString("code");
              }

            }
            else if (operationsUnSelected == "")
              operationsUnSelected = operate.getString("code");
            else {
              operationsUnSelected = operationsUnSelected + "," + operate.getString("code");
            }
          }
          task.setOperations(operationsSelected);
          task.setOperationsUnselected(operationsUnSelected);
        }
      }
    }
    for (int i = 1; i <= 100; i++)
    {
      jsonNode = getProperty("taskevent" + i, elementNode);
      JsonNode taskeventmestype = getProperty("taskevent" + i + "mestype", elementNode);
      if (jsonNode != null)
      {
        ActivitiListener litener = new ActivitiListener();
        litener.setId("taskevent" + i);
        litener.setEvent(jsonNode.get("unit").asText());
        if (taskeventmestype == null)
          litener.setImplementation(DefaultMessageSendAdateper.class.getName());
        else
          litener.setImplementation(((MessageSendConfig)BpmServiceUtils.getBpmEngineConfiguration().getMessageSendService().getMessageSendConfigs().get(taskeventmestype.get("unit").asText())).getAdapterClazz());
        litener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
        task.getTaskListeners().add(litener);
      }
    }
    
  //�н����������
//    ActivitiListener litener=new ActivitiListener();
//     litener.setId("taskeventDefaultDel");
//     litener.setEvent("delete");
//     litener.setImplementation("com.yyjz.icop.bpmcenter.sendmessage.service.UnCommitSendMessageService");
//     litener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
//     task.getTaskListeners().add(litener);
//     
//     litener=new ActivitiListener();
//     litener.setId("taskeventDefaultWithdraw");
//     litener.setEvent("withdraw");
//     litener.setImplementation("com.yyjz.icop.bpmcenter.sendmessage.service.UnApproveSendMessageService");
//     litener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
//     task.getTaskListeners().add(litener);
//     
//     litener=new ActivitiListener();
//     litener.setId("taskeventDefaultJump");
//     litener.setEvent("jump");
//     litener.setImplementation("com.yyjz.icop.bpmcenter.sendmessage.service.DoRejectSendMessageService");
//     litener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
//     task.getTaskListeners().add(litener);

    JsonNode candidateusergroup = getProperty("candidateusergroupids", elementNode);
    JsonNode candidateuser = getProperty("candidateuserids", elementNode);
    List candidateGroups = new ArrayList();
    if ((candidateusergroup != null) && (!candidateusergroup.isNull()))
    {
      String[] candidateusergroups = candidateusergroup.textValue().split(",");
      for (int i = 0; i < candidateusergroups.length; i++)
      {
        if ((candidateusergroups[i] != null) && (!candidateusergroups[i].trim().equals(",")))
          candidateGroups.add(candidateusergroups[i]);
      }
      task.setCandidateGroups(candidateGroups);
    }
    List candidateUsers = new ArrayList();
    if ((candidateuser != null) && (!candidateuser.isNull()))
    {
      String[] candidateusers = candidateuser.textValue().split(",");
      for (int i = 0; i < candidateusers.length; i++)
      {
        if ((candidateusers[i] != null) && (!candidateusers[i].trim().equals(",")))
          candidateUsers.add(candidateusers[i]);
      }
      task.setCandidateUsers(candidateUsers);
    }
    return task;
  }
}