/*** Eclipse Class Decompiler plugin, copyright (c) 2016 Chen Chao (cnfree2000@hotmail.com) ***/
package com.yonyou.bpm.engine.cmd;

import com.yonyou.bpm.core.assign.AssignInfo;
import com.yonyou.bpm.core.tenant.TenantLimit;
import com.yonyou.bpm.engine.impl.runtime.BpmProcessInstanceBuilderImpl;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.history.HistoryLevel;
import org.activiti.engine.impl.history.HistoryManager;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntityManager;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.runtime.ProcessInstanceBuilderImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;

public class StartProcessInstanceCmd<T> extends org.activiti.engine.impl.cmd.StartProcessInstanceCmd<T>
		implements TenantLimit<Void> {
	private static final long serialVersionUID = 1L;
	protected String superProcessInstancId;
	protected AssignInfo assignInfo;

	public StartProcessInstanceCmd(String processDefinitionKey, String processDefinitionId, String businessKey,
			Map<String, Object> variables) {
		super(processDefinitionKey, processDefinitionId, businessKey, variables);
	}

	public StartProcessInstanceCmd(String processDefinitionKey, String processDefinitionId, String businessKey,
			Map<String, Object> variables, String tenantId) {
		this(processDefinitionKey, processDefinitionId, businessKey, variables);
		this.tenantId = tenantId;
	}

	public StartProcessInstanceCmd(String processDefinitionKey, String processDefinitionId, String businessKey,
			Map<String, Object> variables, AssignInfo assignInfo) {
		super(processDefinitionKey, processDefinitionId, businessKey, variables);
		this.assignInfo = assignInfo;
	}

	public StartProcessInstanceCmd(ProcessInstanceBuilderImpl processInstanceBuilder) {
		super(processInstanceBuilder);
		if (processInstanceBuilder instanceof BpmProcessInstanceBuilderImpl) {
			BpmProcessInstanceBuilderImpl bpmProcessInstanceBuilderImpl = (BpmProcessInstanceBuilderImpl) processInstanceBuilder;
			this.assignInfo = bpmProcessInstanceBuilderImpl.getAssignInfo();
			this.superProcessInstancId = bpmProcessInstanceBuilderImpl.getSuperProcessInstancId();
		}
	}

	public StartProcessInstanceCmd(String processDefinitionKey, String processDefinitionId, String businessKey,
			Map<String, Object> variables, String tenantId, AssignInfo assignInfo) {
		super(processDefinitionKey, processDefinitionId, businessKey, variables, tenantId);

		this.assignInfo = assignInfo;
	}

	public StartProcessInstanceCmd(ProcessInstanceBuilderImpl processInstanceBuilder, AssignInfo assignInfo) {
		super(processInstanceBuilder);
		this.assignInfo = assignInfo;
	}

	public ProcessInstance execute(CommandContext commandContext) {
		commandContext.addAttribute("bpmAssigninfo_", this.assignInfo);
		commandContext.addAttribute("bpmAssigninfoNeed_",true);
		return superExe(commandContext);
	}

	public AssignInfo getAssignInfo() {
		return this.assignInfo;
	}

	public ProcessInstance superExe(CommandContext commandContext) {
		DeploymentManager deploymentCache = commandContext.getProcessEngineConfiguration().getDeploymentManager();

		ProcessDefinitionEntity processDefinition = null;
		if (this.processDefinitionId != null) {
			processDefinition = deploymentCache.findDeployedProcessDefinitionById(this.processDefinitionId);

			if (processDefinition == null) {
				throw new ActivitiObjectNotFoundException(
						"No process definition found for id = '" + this.processDefinitionId + "'",
						ProcessDefinition.class);
			}

		} else if ((this.processDefinitionKey != null) && (((this.tenantId == null) || ("".equals(this.tenantId))))) {
			processDefinition = deploymentCache.findDeployedLatestProcessDefinitionByKey(this.processDefinitionKey);

			if (processDefinition == null) {
				throw new ActivitiObjectNotFoundException(
						"No process definition found for key '" + this.processDefinitionKey + "'",
						ProcessDefinition.class);
			}

		} else if ((this.processDefinitionKey != null) && (this.tenantId != null) && (!("".equals(this.tenantId)))) {
			processDefinition = deploymentCache
					.findDeployedLatestProcessDefinitionByKeyAndTenantId(this.processDefinitionKey, this.tenantId);

			if (processDefinition == null) {
				throw new ActivitiObjectNotFoundException("No process definition found for key '"
						+ this.processDefinitionKey + "' for tenant identifier " + this.tenantId,
						ProcessDefinition.class);
			}

		} else {
			throw new ActivitiIllegalArgumentException("processDefinitionKey and processDefinitionId are null");
		}

		if (processDefinition.isSuspended()) {
			throw new ActivitiException("Cannot start process instance. Process definition "
					+ processDefinition.getName() + " (id = " + processDefinition.getId() + ") is suspended");
		}

		ExecutionEntity processInstance = processDefinition.createProcessInstance(this.businessKey);

		if (this.variables != null) {
			processInstance.setVariables(this.variables);
		}

		if (this.processInstanceName != null) {
			processInstance.setName(this.processInstanceName);
			Context.getCommandContext().getHistoryManager()
					.recordProcessInstanceNameChange(processInstance.getProcessInstanceId(), this.processInstanceName);
		}

		ExecutionEntity superExecution = null;
		if ((this.superProcessInstancId != null) && (!("".equals(this.superProcessInstancId.trim())))) {
			HistoricProcessInstanceEntity historicSuperProcessInstance = null;
			if (Context.getCommandContext().getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
				historicSuperProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager()
						.findHistoricProcessInstance(this.superProcessInstancId);
			}

			if (historicSuperProcessInstance == null) {
				throw new ActivitiException("no superProcessInstancId find in historicProcessInstanceEntities");
			}
			superExecution = new ExecutionEntity();
			superExecution.setId(this.superProcessInstancId);
			processInstance.setSuperExecution(superExecution);

			HistoricProcessInstanceEntity historicProcessInstance = Context.getCommandContext()
					.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(processInstance.getId());
			if (historicProcessInstance != null) {
				historicProcessInstance.setSuperProcessInstanceId(this.superProcessInstancId);
			}

		}

		processInstance.start();

		return processInstance;
	}

	public Void tenantId(String tenantId) {
		this.tenantId = tenantId;
		return null;
	}

	public String getSuperProcessInstancId() {
		return this.superProcessInstancId;
	}

	public void setSuperProcessInstancId(String superProcessInstancId) {
		this.superProcessInstancId = superProcessInstancId;
	}

	public void setAssignInfo(AssignInfo assignInfo) {
		this.assignInfo = assignInfo;
	}
}