/*** Eclipse Class Decompiler plugin, copyright (c) 2016 Chen Chao (cnfree2000@hotmail.com) ***/
package com.yonyou.bpm.engine.conf;

import com.yonyou.bpm.BpmException;
import com.yonyou.bpm.core.entity.post.PostServiceImpl;
import com.yonyou.bpm.core.form.IBpmFormService;
import com.yonyou.bpm.core.freeflow.FreeFlowInstanceService;
import com.yonyou.bpm.core.impl.AgentServiceImpl;
import com.yonyou.bpm.core.impl.CategoryServiceImpl;
import com.yonyou.bpm.core.impl.DocServiceImpl;
import com.yonyou.bpm.core.impl.FreeFlowInstanceServiceImpl;
import com.yonyou.bpm.core.impl.OrgServiceImpl;
import com.yonyou.bpm.core.impl.ProcessAccessServiceImpl;
import com.yonyou.bpm.core.impl.RegisterServiceImpl;
import com.yonyou.bpm.core.impl.TenantServiceImpl;
import com.yonyou.bpm.core.impl.UserGroupServiceImpl;
import com.yonyou.bpm.core.impl.UserServiceImpl;
import com.yonyou.bpm.core.impl.VariableServiceImpl;
import com.yonyou.bpm.core.impl.WeixinUserServiceImpl;
import com.yonyou.bpm.core.processaccess.IBpmProcessAccessService;
import com.yonyou.bpm.core.register.RegisterService;
import com.yonyou.bpm.core.user.IUserService;
import com.yonyou.bpm.core.variables.IVariableService;
import com.yonyou.bpm.core.weixinuser.WeixinUserService;
import com.yonyou.bpm.deploy.MD5ResourceMapper;
import com.yonyou.bpm.engine.BpmProcessEngine;
import com.yonyou.bpm.engine.query.IListQuery;
import com.yonyou.bpm.engine.service.BpmHistoryServiceImpl;
import com.yonyou.bpm.engine.service.BpmIdentityServiceImpl;
import com.yonyou.bpm.engine.service.BpmManagementServiceImpl;
import com.yonyou.bpm.engine.service.BpmProcessEngineImpl;
import com.yonyou.bpm.engine.service.BpmRepositoryServiceImpl;
import com.yonyou.bpm.engine.service.BpmRuntimeServiceImpl;
import com.yonyou.bpm.engine.service.BpmTaskServiceImpl;
import com.yonyou.bpm.message.MessageSendService;
import com.yonyou.bpm.message.defaultImpl.MQProperties;
import com.yonyou.bpm.message.defaultImpl.MQSender;
import com.yonyou.bpm.message.defaultImpl.MessageSendServiceImpl;
import com.yonyou.bpm.message.defaultImpl.SMSProperties;
import com.yonyou.bpm.participant.ParticipantService;
import com.yonyou.bpm.participant.adapter.ParticipantAdapter;
import com.yonyou.bpm.participant.defaultImpl.DefaultUserAdapter;
import com.yonyou.bpm.participant.defaultImpl.ParticipantServiceImpl;
import com.yonyou.bpm.trace.LoggingTracer;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.sql.DataSource;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.cfg.ProcessEngineConfigurator;
import org.activiti.engine.impl.bpmn.deployer.BpmnDeployer;
import org.activiti.engine.impl.bpmn.parser.BpmnParseHandlers;
import org.activiti.engine.impl.bpmn.parser.BpmnParser;
import org.activiti.engine.impl.bpmn.parser.factory.ActivityBehaviorFactory;
import org.activiti.engine.impl.bpmn.parser.factory.DefaultActivityBehaviorFactory;
import org.activiti.engine.impl.bpmn.parser.factory.DefaultListenerFactory;
import org.activiti.engine.impl.cfg.DefaultBpmnParseFactory;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.activiti.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.interceptor.CommandConfig;
import org.activiti.engine.impl.interceptor.CommandInterceptor;
import org.activiti.engine.impl.jobexecutor.JobExecutor;
import org.activiti.engine.impl.persistence.deploy.Deployer;
import org.activiti.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.rules.RulesDeployer;
import org.activiti.engine.impl.util.ReflectUtil;
import org.activiti.engine.impl.variable.EntityManagerSession;
import org.activiti.engine.parse.BpmnParseHandler;
import org.activiti.image.ProcessDiagramGenerator;
import org.activiti.rest.form.MonthFormType;
import org.activiti.rest.form.ProcessDefinitionFormType;
import org.activiti.rest.form.UserFormType;
import org.activiti.spring.SpringEntityManagerSessionFactory;
import org.activiti.spring.SpringExpressionManager;
import org.activiti.spring.SpringTransactionContextFactory;
import org.activiti.spring.SpringTransactionInterceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;
import com.yonyou.bpm.core.impl.UserFilterServiceImpl;

public class BpmEngineConfiguration extends ProcessEngineConfigurationImpl implements ApplicationContextAware {
	public static final String DEFAULT_MYBATIS_MAPPING_FILE_BPM = "com/yonyou/bpm/db/mapping/mappings.xml";
	public static final String PROP_ENGINE_SCHEMA_UPDATE = "engine.schema.update";
	public static final String PROP_ENGINE_ACTIVATE_JOBEXECUTOR = "engine.activate.jobexecutor";
	public static final String PROP_ENGINE_HISTORY_LEVEL = "engine.history.level";
	public static final String PROP_MAIL_SERVER_HOST = "mail.server.host";
	public static final String PROP_MAIL_SERVER_PORT = "mail.server.port";
	public static final String PROP_MAIL_SERVER_USERNAME = "mail.server.username";
	public static final String PROP_MAIL_SERVER_PASSWORD = "mail.server.password";
	public static final String PROP_MAIL_SERVER_SSL = "mail.server.ssl";
	public static final String PROP_MAIL_SERVER_TLS = "mail.server.tls";
	public static final String PROP_MAIL_DEFAULT_FROM = "mail.default.from";
	public static final String PROP_DIAGRAM_FONT = "diagram.font";
	public static final String PROP_DIAGRAM_FONT_LABEL = "diagram.font.label";
	private static final String[] DATABASE_TYPES = { "db2", "h2", "mssql", "mysql", "oracle", "postgres" };

	@Autowired
	private Environment environment;

	@Autowired(required = false)
	private Resource customLibDirectory;
	protected PlatformTransactionManager transactionManager;
	protected ApplicationContext applicationContext;
	protected Integer transactionSynchronizationAdapterOrder = null;
	protected CategoryServiceImpl categoryService;
	protected RegisterService registerService;
	protected AgentServiceImpl agentService;
	protected TenantServiceImpl tenantService;
	protected ParticipantService participantService;
	private IBpmFormService bpmFormService;
	private IVariableService variableService;
	private UserServiceImpl userService;
	private UserGroupServiceImpl userGroupService;
	private OrgServiceImpl orgService;
	private PostServiceImpl postService;
	private DocServiceImpl docService;
	private WeixinUserServiceImpl weixinUserServiceImpl;
	private MessageSendService messageSendService;
	private FreeFlowInstanceService freeFlowInstanceService;
	private IBpmProcessAccessService bpmProcessAccessService;
	protected Map<String, IListQuery> listQueries = new HashMap();

	protected List<String> chiefAdminRoleCodes = new ArrayList(0);

	protected Map<String, String[]> chiefAdminViewAndAppCodes = new HashMap(0);

	protected String[] generalAdminViewCodes = new String[0];
	protected Properties msgProperties;
	protected Properties mqProperties;
	protected MQSender mqSender;
	
	private UserFilterServiceImpl userFilterService;

	public BpmEngineConfiguration() {
		setDatabaseSchemaUpdate("false");

		setTransactionsExternallyManaged(true);
	}

	protected void init() {
		this.bpmnParseFactory = new BpmnParseFactoryImpl();

		initBeans();

		extInitialization();

		super.init();
	}

	protected void initServices() {
		super.initServices();
	}

	protected void initSqlSessionFactory() {
		super.initSqlSessionFactory();
		initServicesWithSqlSessionFactory();
	}

	protected InputStream getMyBatisXmlConfigurationSteam() {
		return ReflectUtil.getResourceAsStream("com/yonyou/bpm/db/mapping/mappings.xml");
	}

	protected void initServicesWithSqlSessionFactory() {
		SqlSessionFactory sqlSessionFactory = getSqlSessionFactory();
		String defaultDir = null;
		if (this.environment != null) {
			defaultDir = this.environment.getProperty("dir.server.conf");
		}
		this.msgProperties = SMSProperties.getProperties(defaultDir);

		this.mqProperties = MQProperties.getProperties(defaultDir);
		this.mqSender = new MQSender(this.mqProperties);

		ParticipantServiceImpl participantServiceImpl = new ParticipantServiceImpl();
		participantServiceImpl.setCommandExecutor(this.commandExecutor);
		ParticipantAdapter userAdapter = new DefaultUserAdapter(this);
		participantServiceImpl.setUserAdapter(userAdapter);
		this.participantService = participantServiceImpl;

		this.messageSendService = new MessageSendServiceImpl();

		this.categoryService = new CategoryServiceImpl(sqlSessionFactory);
		this.categoryService.setCommandExecutor(this.commandExecutor);

		this.registerService = new RegisterServiceImpl(sqlSessionFactory);
		((RegisterServiceImpl) this.registerService).setCommandExecutor(this.commandExecutor);

		this.tenantService = new TenantServiceImpl(this.commandExecutor);

		this.agentService = new AgentServiceImpl(sqlSessionFactory);
		this.agentService.setCommandExecutor(this.commandExecutor);

		this.userService = new UserServiceImpl(sqlSessionFactory);
		this.userService.setCommandExecutor(this.commandExecutor);

		this.userGroupService = new UserGroupServiceImpl(sqlSessionFactory);
		this.userGroupService.setCommandExecutor(this.commandExecutor);

		this.orgService = new OrgServiceImpl(sqlSessionFactory);
		this.orgService.setCommandExecutor(this.commandExecutor);

		this.postService = new PostServiceImpl(sqlSessionFactory);
		this.postService.setCommandExecutor(this.commandExecutor);

		this.docService = new DocServiceImpl(sqlSessionFactory);
		this.docService.setCommandExecutor(this.commandExecutor);

		this.weixinUserServiceImpl = new WeixinUserServiceImpl(sqlSessionFactory);
		this.weixinUserServiceImpl.setCommandExecutor(this.commandExecutor);

		this.freeFlowInstanceService = new FreeFlowInstanceServiceImpl(sqlSessionFactory);
		this.freeFlowInstanceService.setCommandExecutor(this.commandExecutor);
		
		userFilterService=new UserFilterServiceImpl(sqlSessionFactory);
		userFilterService.setCommandExecutor(commandExecutor);

		this.bpmFormService = new com.yonyou.bpm.core.impl.BpmFormServiceImpl(sqlSessionFactory);
		((com.yonyou.bpm.core.impl.BpmFormServiceImpl) this.bpmFormService).setCommandExecutor(this.commandExecutor);

		this.variableService = new VariableServiceImpl(sqlSessionFactory);
		((VariableServiceImpl) this.variableService).setCommandExecutor(this.commandExecutor);

		this.bpmProcessAccessService = new ProcessAccessServiceImpl(sqlSessionFactory);
		((ProcessAccessServiceImpl) this.bpmProcessAccessService).setCommandExecutor(this.commandExecutor);
	}

	public IVariableService getVariableService() {
		return this.variableService;
	}

	public void setVariableService(IVariableService variableService) {
		this.variableService = variableService;
	}

	protected void initBeans() {
		if (getBeans() != null)
			return;
		setBeans(new SpringBeanFactoryProxyMap(this.applicationContext));
	}

	protected void initExpressionManager() {
		if ((getExpressionManager() == null) && (this.applicationContext != null)) {
			setExpressionManager(new SpringExpressionManager(this.applicationContext, getBeans()));
		}

		if (getExpressionManager() == null)
			setExpressionManager(new ExpressionManager(this.beans));
	}

	protected Collection<? extends Deployer> getDefaultDeployers() {
		List defaultDeployers = new ArrayList();

		if (this.bpmnDeployer == null) {
			this.bpmnDeployer = new BpmnDeployer();
		}

		this.bpmnDeployer.setExpressionManager(this.expressionManager);
		this.bpmnDeployer.setIdGenerator(this.idGenerator);

		if (this.bpmnParseFactory == null) {
			this.bpmnParseFactory = new DefaultBpmnParseFactory();
		}

		if (this.activityBehaviorFactory == null) {
			DefaultActivityBehaviorFactory defaultActivityBehaviorFactory = new DefaultActivityBehaviorFactory();
			defaultActivityBehaviorFactory.setExpressionManager(this.expressionManager);
			this.activityBehaviorFactory = defaultActivityBehaviorFactory;
		}

		if (this.listenerFactory == null) {
			DefaultListenerFactory defaultListenerFactory = new DefaultListenerFactory();
			defaultListenerFactory.setExpressionManager(this.expressionManager);
			this.listenerFactory = defaultListenerFactory;
		}

		if (this.bpmnParser == null) {
			this.bpmnParser = new BpmnParser();
		}

		this.bpmnParser.setExpressionManager(this.expressionManager);
		this.bpmnParser.setBpmnParseFactory(this.bpmnParseFactory);
		this.bpmnParser.setActivityBehaviorFactory(this.activityBehaviorFactory);
		this.bpmnParser.setListenerFactory(this.listenerFactory);

		List parseHandlers = new ArrayList();
		if (getPreBpmnParseHandlers() != null) {
			parseHandlers.addAll(getPreBpmnParseHandlers());
		}
		parseHandlers.addAll(getDefaultBpmnParseHandlers());
		if (getPostBpmnParseHandlers() != null) {
			parseHandlers.addAll(getPostBpmnParseHandlers());
		}

		BpmnParseHandlers bpmnParseHandlers = new BpmnParseHandlers();
		bpmnParseHandlers.addHandlers(parseHandlers);
		this.bpmnParser.setBpmnParserHandlers(bpmnParseHandlers);

		this.bpmnDeployer.setBpmnParser(this.bpmnParser);

		defaultDeployers.add(this.bpmnDeployer);
		RulesDeployer rulesDeployer = new RulesDeployer();
		defaultDeployers.add(rulesDeployer);
		return defaultDeployers;
	}

	private void extInitialization() {
		ImageIO.setUseCache(false);

		List formTypes = new ArrayList();
		formTypes.add(new UserFormType());
		formTypes.add(new ProcessDefinitionFormType());
		formTypes.add(new MonthFormType());
		setCustomFormTypes(formTypes);

		ClassLoader serverClassLoader = createServerClassLoader(Thread.currentThread().getContextClassLoader());

		setClassLoader(serverClassLoader);

		setCustomMybatisMappers(getCustomMyBatisMapper());

		setRuntimeService(new BpmRuntimeServiceImpl());
		setRepositoryService(new BpmRepositoryServiceImpl());
		setTaskService(new BpmTaskServiceImpl(this));
		setIdentityService(new BpmIdentityServiceImpl());
		setFormService(new com.yonyou.bpm.engine.service.BpmFormServiceImpl());
		setHistoryService(new BpmHistoryServiceImpl(this));
		setManagementService(new BpmManagementServiceImpl());

		setBpmProcessAccessService(this.bpmProcessAccessService);
	}

	private ClassLoader createServerClassLoader(ClassLoader parentClassLoader) {
		if (this.customLibDirectory == null)
			return parentClassLoader;
		try {
			File javaCodeDplDir = this.customLibDirectory.getFile();
			if (!(javaCodeDplDir.isDirectory())) {
				return parentClassLoader;
			}
			File[] jarFiles = javaCodeDplDir.listFiles(new FilenameFilter() {
				public boolean accept(File dir, String name) {
					return name.toLowerCase().endsWith(".jar");
				}
			});
			URL[] jarUrls = new URL[(jarFiles == null) ? 0 : jarFiles.length];
			for (int i = 0; i < jarUrls.length; ++i) {
				jarUrls[i] = jarFiles[i].toURI().toURL();
			}
			ClassLoader customerLoader = parentClassLoader;
			if (jarUrls.length > 0) {
				customerLoader = new URLClassLoader(jarUrls, parentClassLoader);
			}
			return customerLoader;
		} catch (MalformedURLException e) {
			throw new BpmException(e);
		} catch (IOException e) {
			throw new BpmException(e);
		}
	}

	private Set<Class<?>> getCustomMyBatisMapper() {
		Set mappers = new HashSet();
		mappers.add(MD5ResourceMapper.class);

		return mappers;
	}

	public BpmProcessEngine buildProcessEngine() {
		init();
		BpmProcessEngineImpl processEngine = new BpmProcessEngineImpl(this);
		ProcessEngines.setInitialized(true);
		return processEngine;
	}

	public void setTransactionSynchronizationAdapterOrder(Integer transactionSynchronizationAdapterOrder) {
		this.transactionSynchronizationAdapterOrder = transactionSynchronizationAdapterOrder;
	}

	protected void initDefaultCommandConfig() {
		if (this.defaultCommandConfig == null)
			this.defaultCommandConfig = new CommandConfig().setContextReusePossible(true);
	}

	protected CommandInterceptor createTransactionInterceptor() {
		if (this.transactionManager == null) {
			throw new ActivitiException(
					"transactionManager is required property for SpringProcessEngineConfiguration, use "
							+ StandaloneProcessEngineConfiguration.class.getName() + " otherwise");
		}

		return new SpringTransactionInterceptor(this.transactionManager);
	}

	protected void initTransactionContextFactory() {
		if ((this.transactionContextFactory == null) && (this.transactionManager != null))
			this.transactionContextFactory = new SpringTransactionContextFactory(this.transactionManager,
					this.transactionSynchronizationAdapterOrder);
	}

	protected void initJpa() {
		super.initJpa();
		if (this.jpaEntityManagerFactory != null)
			this.sessionFactories.put(EntityManagerSession.class, new SpringEntityManagerSessionFactory(
					this.jpaEntityManagerFactory, this.jpaHandleTransaction, this.jpaCloseEntityManager));
	}

	public ProcessEngineConfiguration setDatabaseType(String databaseType) {
		if (databaseType != null) {
			boolean isPredefinedType = false;
			for (String predefinedDBtype : DATABASE_TYPES) {
				if (databaseType.equalsIgnoreCase(predefinedDBtype)) {
					databaseType = predefinedDBtype;
					isPredefinedType = true;
					break;
				}
			}
			if (!(isPredefinedType)) {
				databaseType = null;
			}
		}
		return super.setDatabaseType(databaseType);
	}

	@Autowired
	@Qualifier("dataSource")
	public ProcessEngineConfiguration setDataSource(DataSource dataSource) {
		if (dataSource instanceof TransactionAwareDataSourceProxy) {
			return super.setDataSource(dataSource);
		}

		DataSource proxiedDataSource = new TransactionAwareDataSourceProxy(dataSource);

		return super.setDataSource(proxiedDataSource);
	}

	public PlatformTransactionManager getTransactionManager() {
		return this.transactionManager;
	}

	@Autowired
	@Qualifier("transactionManager")
	public void setTransactionManager(PlatformTransactionManager transactionManager) {
		this.transactionManager = transactionManager;
	}

	public ApplicationContext getApplicationContext() {
		return this.applicationContext;
	}

	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		this.applicationContext = applicationContext;
	}

	@Autowired(required = false)
	@Qualifier("idGenerator")
	public ProcessEngineConfigurationImpl setIdGenerator(IdGenerator idGenerator) {
		return super.setIdGenerator(idGenerator);
	}

	@Autowired(required = false)
	@Qualifier("expressionManager")
	public ProcessEngineConfigurationImpl setExpressionManager(ExpressionManager expressionManager) {
		return super.setExpressionManager(expressionManager);
	}

	@Autowired(required = false)
	@Qualifier("processDiagramGenerator")
	public ProcessEngineConfiguration setProcessDiagramGenerator(ProcessDiagramGenerator processDiagramGenerator) {
		return super.setProcessDiagramGenerator(processDiagramGenerator);
	}

	@Autowired(required = false)
	@Qualifier("processDefinitionCache")
	public ProcessEngineConfigurationImpl setProcessDefinitionCache(
			DeploymentCache<ProcessDefinitionEntity> processDefinitionCache) {
		return super.setProcessDefinitionCache(processDefinitionCache);
	}

	@Autowired(required = false)
	@Qualifier("knowledgeBaseCache")
	public ProcessEngineConfigurationImpl setKnowledgeBaseCache(DeploymentCache<Object> knowledgeBaseCache) {
		return super.setKnowledgeBaseCache(knowledgeBaseCache);
	}

	@Autowired(required = false)
	@Qualifier("jobExecutor")
	public ProcessEngineConfiguration setJobExecutor(JobExecutor jobExecutor) {
		return super.setJobExecutor(jobExecutor);
	}

	public List<ProcessEngineConfigurator> getConfigurators() {
		if (this.configurators == null) {
			this.configurators = new LinkedList();
		}
		return this.configurators;
	}

	@Autowired(required = false)
	public ProcessEngineConfigurationImpl setConfigurators(List<ProcessEngineConfigurator> configurators) {
		getConfigurators().addAll(configurators);
		return this;
	}

	public List<BpmnParseHandler> getPreBpmnParseHandlers() {
		if (this.preBpmnParseHandlers == null) {
			this.preBpmnParseHandlers = new LinkedList();
		}
		return this.preBpmnParseHandlers;
	}

	public ProcessEngineConfigurationImpl setPreBpmnParseHandlers(List<BpmnParseHandler> preBpmnParseHandlers) {
		getPreBpmnParseHandlers().addAll(preBpmnParseHandlers);
		return this;
	}

	public List<BpmnParseHandler> getPostBpmnParseHandlers() {
		if (this.postBpmnParseHandlers == null) {
			this.postBpmnParseHandlers = new LinkedList();
		}
		return this.postBpmnParseHandlers;
	}

	public ProcessEngineConfigurationImpl setPostBpmnParseHandlers(List<BpmnParseHandler> postBpmnParseHandlers) {
		getPostBpmnParseHandlers().addAll(postBpmnParseHandlers);
		return this;
	}

	public List<BpmnParseHandler> getCustomDefaultBpmnParseHandlers() {
		if (this.customDefaultBpmnParseHandlers == null) {
			this.customDefaultBpmnParseHandlers = new LinkedList();
		}
		return this.customDefaultBpmnParseHandlers;
	}

	public ProcessEngineConfigurationImpl setCustomDefaultBpmnParseHandlers(
			List<BpmnParseHandler> customDefaultBpmnParseHandlers) {
		getCustomDefaultBpmnParseHandlers().addAll(customDefaultBpmnParseHandlers);

		return this;
	}

	public boolean isLoggingTraceEnable() {
		return LoggingTracer.isEnable();
	}

	public void setLoggingTraceEnable(boolean loggingTraceEnable) {
		LoggingTracer.setEnable(loggingTraceEnable);
	}

	public ProcessEngineConfigurationImpl setActivityBehaviorFactory(ActivityBehaviorFactory activityBehaviorFactory) {
		this.activityBehaviorFactory = activityBehaviorFactory;
		if (this.bpmnParser != null) {
			this.bpmnParser.setActivityBehaviorFactory(activityBehaviorFactory);
		}
		return this;
	}

	public FreeFlowInstanceService getFreeFlowInstanceService() {
		return this.freeFlowInstanceService;
	}

	public void setFreeFlowInstanceService(FreeFlowInstanceService freeFlowInstanceService) {
		this.freeFlowInstanceService = freeFlowInstanceService;
	}

	public CategoryServiceImpl getCategoryService() {
		return this.categoryService;
	}

	public void setCategoryService(CategoryServiceImpl categoryService) {
		this.categoryService = categoryService;
	}

	public RegisterService getRegisterService() {
		return this.registerService;
	}

	public void setRegisterService(RegisterService registerService) {
		this.registerService = registerService;
	}

	public TenantServiceImpl getTenantService() {
		return this.tenantService;
	}

	public void setTenantService(TenantServiceImpl tenantService) {
		this.tenantService = tenantService;
	}

	public ParticipantService getParticipantService() {
		return this.participantService;
	}

	public void setParticipantService(ParticipantService participantService) {
		this.participantService = participantService;
	}

	public UserGroupServiceImpl getUserGroupService() {
		return this.userGroupService;
	}

	public void setUserGroupService(UserGroupServiceImpl userGroupService) {
		this.userGroupService = userGroupService;
	}

	public AgentServiceImpl getAgentService() {
		return this.agentService;
	}

	public void setAgentService(AgentServiceImpl agentService) {
		this.agentService = agentService;
	}

	public IUserService getUserService() {
		return this.userService;
	}

	public void setUserService(UserServiceImpl userService) {
		this.userService = userService;
	}

	public PostServiceImpl getPostService() {
		return this.postService;
	}

	public void setOrgService(PostServiceImpl postService) {
		this.postService = postService;
	}

	public OrgServiceImpl getOrgService() {
		return this.orgService;
	}

	public void setOrgService(OrgServiceImpl orgService) {
		this.orgService = orgService;
	}

	public IBpmFormService getBpmFormService() {
		return this.bpmFormService;
	}

	public void setBpmFormService(IBpmFormService bpmFormService) {
		this.bpmFormService = bpmFormService;
	}

	public Map<String, IListQuery> getListQueries() {
		return this.listQueries;
	}

	public void setListQueries(Map<String, IListQuery> listQueries) {
		this.listQueries = listQueries;
	}

	public List<String> getChiefAdminRoleCodes() {
		return this.chiefAdminRoleCodes;
	}

	public void setChiefAdminRoleCodes(List<String> chiefAdminRoleCodes) {
		this.chiefAdminRoleCodes = chiefAdminRoleCodes;
	}

	public Map<String, String[]> getChiefAdminViewAndAppCodes() {
		return this.chiefAdminViewAndAppCodes;
	}

	public void setChiefAdminViewAndAppCodes(Map<String, String[]> chiefAdminViewAndAppCodes) {
		this.chiefAdminViewAndAppCodes = chiefAdminViewAndAppCodes;
	}

	public String[] getGeneralAdminViewCodes() {
		return this.generalAdminViewCodes;
	}

	public void setGeneralAdminViewCodes(String[] generalAdminViewCodes) {
		this.generalAdminViewCodes = generalAdminViewCodes;
	}

	public IBpmProcessAccessService getBpmProcessAccessService() {
		return this.bpmProcessAccessService;
	}

	public void setBpmProcessAccessService(IBpmProcessAccessService bpmProcessAccessService) {
		this.bpmProcessAccessService = bpmProcessAccessService;
	}

	public MessageSendService getMessageSendService() {
		return this.messageSendService;
	}

	public void setMessageSendService(MessageSendService messageSendService) {
		this.messageSendService = messageSendService;
	}

	public Properties getMsgProperties() {
		return this.msgProperties;
	}

	public void setMsgProperties(Properties msgProperties) {
		this.msgProperties = msgProperties;
	}

	public Properties getMqProperties() {
		return this.mqProperties;
	}

	public void setMqProperties(Properties mqProperties) {
		this.mqProperties = mqProperties;
	}

	public MQSender getMqSender() {
		return this.mqSender;
	}

	public void setMqSender(MQSender mqSender) {
		this.mqSender = mqSender;
	}

	public WeixinUserService getWeixinUserService() {
		return this.weixinUserServiceImpl;
	}

	public void setWeixinUserService(WeixinUserServiceImpl weixinUserServiceImpl) {
		this.weixinUserServiceImpl = weixinUserServiceImpl;
	}

	public DocServiceImpl getDocService() {
		return this.docService;
	}

	public void setDocService(DocServiceImpl docService) {
		this.docService = docService;
	}
	
	public UserFilterServiceImpl getUserFilterService() {
		return userFilterService;
	}

	public void setUserFilterService(UserFilterServiceImpl userFilterService) {
		this.userFilterService = userFilterService;
	}
}