package com.yonyou.bpm.engine.listener;

import java.io.Serializable;
import java.util.Date;

import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;

import com.yonyou.bpm.core.assign.AssignInfo;
import com.yonyou.bpm.core.impl.AgentQueryParam;
import com.yonyou.bpm.engine.conf.BpmEngineConfiguration;
import com.yonyou.bpm.engine.impl.BpmAuthentication;
import com.yonyou.bpm.model.ApproveUserTask;
import com.yonyou.bpm.participant.context.ParticipantContext;
import com.yonyou.bpm.utils.BpmUtilsBean;
/**
 * 任务创建监听,任务代理
 * @author zhaohb
 *
 */
public class DefaultTaskCreateListener implements TaskListener,Serializable{

	private static final long serialVersionUID = 1L;

	@Override
	public void notify(DelegateTask delegateTask) {
		//设置默认超期时间
		setDefaultDueDate(delegateTask);
		//任务名称更新
		updateTask(delegateTask);
		//设置指派任务
		addAssignedBy(delegateTask);
		
		String assignee=delegateTask.getAssignee();
		if(assignee==null||"".equals(assignee.trim())){
			return;
		}
		
		AgentQueryParam queryParam = new AgentQueryParam();
		queryParam.setProcessDefinitionKey(delegateTask.getProcessDefinitionId().split(":")[0]);
		BpmEngineConfiguration bpmEngineConfiguration=(BpmEngineConfiguration)Context.getProcessEngineConfiguration();
		String newAssignee=bpmEngineConfiguration.getAgentService().getAgentUserId(assignee,queryParam);
		if(!(newAssignee==null||assignee.equals(newAssignee))){
			delegateTask.setAssignee(newAssignee);
			delegateTask.setOwner(assignee);
			
			delegateTask.addCandidateUser(newAssignee);
			delegateTask.addCandidateUser(assignee);
			
			delegateTask.setVariableLocal("redirectUser", newAssignee);
			
			String message=getClass().getName()+"->任务"+"["+delegateTask.getName()+"]"+"的代理人"+"["+assignee+"]"+"自动转办给了用户"+"["+newAssignee +"]";
			bpmEngineConfiguration.getTaskService().addComment(delegateTask.getId(), delegateTask.getProcessInstanceId(), "redirect", message);
		}

		String taskId=delegateTask.getId();
		//连岗合办
		TaskEntity taskEntity=(TaskEntity)delegateTask;
		if(taskEntity!=null&&taskEntity.getExecution().getParent()!=null
				&&taskEntity.getExecution().getTasks()!=null&&taskEntity.getExecution().getTasks().size()>0
				&&taskEntity.getExecution().getTasks().size()==1){
			Task currentTask=ParticipantContext.getTask();
			String currentUser=null;
			if(currentTask!=null)
				currentUser=currentTask.getAssignee();
			else
				currentUser=Authentication.getAuthenticatedUserId();
			//当前操作任务
			if(currentUser!=null&&delegateTask.getAssignee().equals(currentUser)){
				
				BpmnModel bpmnModel =bpmEngineConfiguration.getRepositoryService().getBpmnModel(delegateTask.getProcessDefinitionId());
	   			FlowElement flowElement = bpmnModel.getFlowElement(delegateTask.getTaskDefinitionKey());
	   			if(flowElement instanceof ApproveUserTask){
	   				String unionExe = ((ApproveUserTask) flowElement).getAttributeValue("http://activiti.org/bpmn", "samepostApprove");
	   				if(unionExe != null && "true".equals(unionExe)){
	   					Context.getProcessEngineConfiguration().getTaskService().complete(taskId);
	   				}
	   			}
				
			}
			
		}
		
	}
	
	private void updateTask(DelegateTask delegateTask) {
		// 任务名称更新
		Object nameObj = BpmUtilsBean.getProcessInstanceVar("taskname");
		if (nameObj != null) {
			String name = (String) nameObj;
			if (StringUtils.isNotBlank(name)) {
				String actName = (String) Context.getCommandContext().getExecutionEntityManager().findExecutionById(delegateTask.getExecutionId())
						.getProcessDefinition()
						.findActivity(delegateTask.getTaskDefinitionKey())
						.getProperty("name");
				delegateTask.setName(name + "-" + actName);
			}
		}

	}
	
   private void addAssignedBy(DelegateTask delegateTask){
	   Object assigninfoNeedObj=Context.getCommandContext().getAttribute(AssignInfo.ASSIGNINFO_NEED);
	   
	   Object assigninfoParam=Context.getCommandContext().getAttribute(AssignInfo.ASSIGNINFO_PARAM);
	   
	   if(assigninfoNeedObj!=null&&assigninfoParam!=null){
		   if(((Boolean)assigninfoNeedObj).booleanValue()){
			   if(ParticipantContext.getTask() != null){
				   String assignedById=ParticipantContext.getTask().getId();
				   delegateTask.setVariableLocal(AssignInfo.ASSIGNINFO_BY, assignedById);
			   }
		   }
	   }
   }
   @SuppressWarnings("deprecation")
  private void setDefaultDueDate(DelegateTask delegateTask){
	   Date duedateTime = Context.getCommandContext().getProcessEngineConfiguration().getClock().getCurrentTime();
	   
	   if(delegateTask.getDueDate()!=null)return;
	    //默认超期日期为999年之后
	    duedateTime.setYear(duedateTime.getYear()+999);
	    delegateTask.setDueDate(duedateTime);
   }
}
