package com.yonyou.bpm.participant;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.util.IoUtil;
import org.activiti.engine.impl.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

import com.yonyou.bpm.core.impl.UserFilterQueryParam;
import com.yonyou.bpm.core.userfilter.UserFilter;
import com.yonyou.bpm.engine.conf.BpmEngineConfiguration;
import com.yonyou.bpm.participant.config.ParticipantConfig;
import com.yonyou.bpm.participant.config.ParticipantFilterConfig;
import com.yonyou.bpm.participant.defaultImpl.ParticipantConfigImpl;
import com.yonyou.bpm.participant.defaultImpl.ParticipantFilterConfigImpl;

/**
 * 鍙備笌鑰呴厤缃伐鍘傜被
 * 
 * @author zhaohb
 *
 */
public class ParticipantFactory {
	public final static String RESOURCE="yonyou.participant.cfg.xml";
	private static Logger log = LoggerFactory
			.getLogger(ParticipantFactory.class);
	private Map<String, ParticipantConfig> participantConfigs;
	private Map<String, ParticipantFilterConfig> participantFilterConfigs;

	private static ParticipantFactory inst = new ParticipantFactory();

	public static ParticipantFactory getInstance() {
		return inst;
	}

	public synchronized Map<String, ParticipantFilterConfig> getParticipantFilterConfigs() {
			initConfig();
		return participantFilterConfigs;
	}

	public synchronized Map<String, ParticipantConfig> getParticipantConfigs() {
			initConfig();
		return participantConfigs;
	}

	public void setParticipantConfigs(
			Map<String, ParticipantConfig> participantConfigs) {
		this.participantConfigs = participantConfigs;
	}

	public void setParticipantFilterConfigs(
			Map<String, ParticipantFilterConfig> participantFilterConfigs) {
		this.participantFilterConfigs = participantFilterConfigs;
	}

	private void initParticipantConfigs(Resource springResource) {
		DefaultListableBeanFactory defaultListableBeanFactory = getDefaultListableBeanFactory(springResource);
		if (defaultListableBeanFactory != null) {
			Map<String, ParticipantConfig> beanMap = defaultListableBeanFactory
					.getBeansOfType(ParticipantConfig.class);
			if (beanMap != null && beanMap.size() > 0) {
				for (Map.Entry<String,ParticipantConfig> participantConfigTemp: beanMap.entrySet()) {
					ParticipantConfig participantConfig=participantConfigs.get(participantConfigTemp.getKey());
					
					if(participantConfig==null){
						boolean isEnable=participantConfigTemp.getValue().isEnable();
						if(!isEnable){
							log.info("鍙備笌鑰呴厤缃浉锛氱紪鐮佷负锛�"+participantConfigTemp.getKey()+"宸茶缃负涓嶅彲鐢�;");
							continue;
						}
						if(participantConfigTemp.getKey().equals("EXTENDROLE"))
						{
							BpmEngineConfiguration bpmEngineConfiguration=(BpmEngineConfiguration)Context.getProcessEngineConfiguration();
							if(bpmEngineConfiguration!=null)
							{
								
								
								
							}
						}
						else
							participantConfigs.put(participantConfigTemp.getKey(), participantConfigTemp.getValue());
					}else{
						
						int tempP1=participantConfigTemp.getValue().getPriority();
						int tempP2=participantConfig.getPriority();
						log.info("鍙備笌鑰呴厤缃浉涓瓨鍦ㄩ厤缃紪鐮佺浉鍚岀殑涓ら」锛氱紪鐮佷负锛�"+participantConfigTemp.getKey()+";浼樺厛绾у垎鍒负锛�"+tempP1+"銆�"+tempP2+"");
						log.info(";鏌ヨ瀹炵幇鍒嗗埆涓猴細"+participantConfigTemp.getValue().getAdapterClazz()+"銆�"+participantConfig.getAdapterClazz()+"");
						//宸茬粡瀛樺湪鐨勫弬涓庤�呴厤缃紝姣旇緝浼樺厛绾уぇ灏�,淇濈暀浼樺厛绾ф瘮杈冨ぇ鐨�
						if(tempP1>=tempP2){
							participantConfigs.put(participantConfigTemp.getKey(), participantConfigTemp.getValue());
						}
					}
				}
				participantConfigs.putAll(beanMap);
			}
			BpmEngineConfiguration bpmEngineConfiguration=(BpmEngineConfiguration)Context.getProcessEngineConfiguration();
			if(bpmEngineConfiguration!=null)
			{
				UserFilterQueryParam userFilterQueryParam=new UserFilterQueryParam();
				//搴旇鐢ㄧ鎴锋煡璇紝浣嗘病鍔炴硶鍙栧埌绉熸埛
				List<UserFilter> userFilterList= (List<UserFilter>) bpmEngineConfiguration.getUserFilterService().query(userFilterQueryParam);
				for(int i=0;i<userFilterList.size();i++)
				{
					ParticipantFilterConfigImpl participantFilterConfig=new ParticipantFilterConfigImpl();
					participantFilterConfig.setCode(userFilterList.get(i).getCode());
					participantFilterConfig.setName(userFilterList.get(i).getName());
					participantFilterConfig.setEnable(true);
					participantFilterConfig.setAdapterClazz(userFilterList.get(i).getAdapterClazz());
					participantFilterConfigs.put(userFilterList.get(i).getCode(), participantFilterConfig);
				}
			}
			Map<String, ParticipantFilterConfig> filterBeanMap = defaultListableBeanFactory
					.getBeansOfType(ParticipantFilterConfig.class);
			if (filterBeanMap != null && filterBeanMap.size() > 0) {
				participantFilterConfigs.putAll(filterBeanMap);
			}
		}
	}
	

	
	private void initConfig() {
		if (participantConfigs != null&&participantConfigs.size()!=0) {
			return;
		}else{
			participantConfigs=new HashMap<String, ParticipantConfig>(8);
			if(participantFilterConfigs==null){
				participantFilterConfigs=new HashMap<String, ParticipantFilterConfig>(8);
			}
		}
		ClassLoader classLoader = ReflectUtil.getClassLoader();
		Enumeration<URL> resources = null;
		try {
			resources = classLoader.getResources(RESOURCE);
		} catch (IOException e) {
			throw new IllegalArgumentException(
					"problem retrieving "+RESOURCE+" resources on the classpath: "
							+ System.getProperty("java.class.path"), e);
		}

		Set<URL> configUrls = new HashSet<URL>();
		while (resources.hasMoreElements()) {
			configUrls.add(resources.nextElement());
		}
		for (Iterator<URL> iterator = configUrls.iterator(); iterator.hasNext();) {
			URL resource = iterator.next();
			log.info(
					"Initializing participantFactory using configuration '{}'",
					resource.toString());
			InputStream inputStream = null;
			try {
				inputStream = resource.openStream();
				Resource springResource = new InputStreamResource(inputStream);
				initParticipantConfigs(springResource);
			} catch (IOException e) {
				throw new IllegalArgumentException(
						"couldn't open resource stream: " + e.getMessage(), e);
			} finally {
				IoUtil.closeSilently(inputStream);
			}

		}
	}
	private DefaultListableBeanFactory getDefaultListableBeanFactory(
			Resource springResource) {
		DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
		XmlBeanDefinitionReader xmlBeanDefinitionReader = new XmlBeanDefinitionReader(
				beanFactory);
		xmlBeanDefinitionReader
				.setValidationMode(XmlBeanDefinitionReader.VALIDATION_XSD);
		xmlBeanDefinitionReader.loadBeanDefinitions(springResource);
		return beanFactory;
	}

}
