package com.yonyou.bpm.participant;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ProcessParticipantItem
  implements Serializable
{
  private static final long serialVersionUID = 1L;
  public static final String TYPE_EXPANDTYPE = "EXTENDFIELD";
  private ProcessParticipantDetail[] details;
  private String type;
  private String[] filters;
  private Map<String, String> others;
  private boolean sameorg;
  private boolean samedept;
  private String userfilter;

  public ProcessParticipantItem() {
	}
  public ProcessParticipantItem(ProcessParticipantDetail[] details, String type)
  {
    this.details = details;
    this.type = type; }

  public ProcessParticipantItem(ProcessParticipantDetail[] details, String type, String[] filters) {
    this.details = details;
    this.type = type;
    this.filters = filters;
  }

  public ProcessParticipantDetail[] getDetails() {
    return this.details;
  }

  public void setDetails(ProcessParticipantDetail[] details) {
    this.details = details;
  }

  public String getType()
  {
    return this.type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String[] getFilters() {
    return this.filters;
  }

  public void setFilters(String[] filters) {
    this.filters = filters; }

  public Map<String, String> getOthers() {
    return this.others; }

  public void setOthers(Map<String, String> others) {
    this.others = others; }

  public void addOthers(String key, String value) {
    if ((key == null) || ("".equals(key.trim())) || 
      (value == null) || ("".equals(value.trim())))
      throw new IllegalArgumentException("'key'||'value' can not be null");

    if (this.others == null) {
      this.others = new HashMap(4);
    }

    this.others.put(key, value);
  }

  public String getFromOthers(String key) {
    if ((key == null) || ("".equals(key.trim())))
      throw new IllegalArgumentException("'key' can not be null");

    if ((this.others == null) || (this.others.size() == 0)) return null;
    return ((String)this.others.get(key));
  }

  public boolean isSameorg() {
    return this.sameorg;
  }

  public void setSameorg(boolean isSameorg) {
    this.sameorg = isSameorg;
  }

  public boolean isSamedept() {
    return this.samedept;
  }

  public void setSamedept(boolean samedept) {
    this.samedept = samedept;
  }

  public String getUserfilter() {
    return this.userfilter;
  }

  public void setUserfilter(String userfilter) {
    this.userfilter = userfilter;
  }
}
