/*
 * Decompiled with CFR 0.152.
 */
package mobset;

import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Properties;
import java.util.Random;
import mobset.IPConfig;
import mobset.str_KYSmsRet;
import mobset.str_RecvMsg;
import mobset.str_SendMsg;

public class smsSDK {
    final int SERVERTYPE = 1;
    String DEFAULT_HOST = "www.mobset.com";
    int DEFAULT_PORT = 2046;
    SmsSocket m_gSocket = null;
    boolean m_gRun = false;
    str_Login m_gLogin = new str_Login();
    int m_gCorpID;
    int m_gUserID;
    int m_gStatus = -1;
    int m_gStatus_Send = -1;
    long m_gTimeOut = 30000L;
    str_SendMsg[] m_gSendMsg;
    int m_gSendMsgCount;
    int m_gCMLocaltion = 0;
    int g_KYSmsUser = 0;
    int g_KYSmsMobset = 0;
    int g_KYSmsAdc = 0;
    boolean m_bWindows = false;
    str_Recv m_gMsgRecv = new str_Recv();
    str_Back m_gBack = new str_Back();
    str_Filt m_gFilt = new str_Filt();

    public smsSDK() {
        Properties prop = System.getProperties();
        String os = prop.getProperty("os.name");
        if (os.startsWith("win") || os.startsWith("Win")) {
            this.m_bWindows = true;
        }
    }

    public synchronized int Sms_Connect(String strHost, int iCorpID, String strLoginName, String strPasswd, int iTimeOut) {
        String Host = strHost;
        if (this.m_gSocket != null) {
            this.m_gSocket.DisConnect();
            this.m_gSocket = null;
        }
        this.m_gSocket = new SmsSocket();
        this.m_gTimeOut = iTimeOut * 1000;
        int iRet = this.m_gSocket.Connect(Host, this.DEFAULT_PORT);
        if (iRet >= 0) {
            this.m_gRun = true;
            this.m_gSocket.start();
        } else {
            IPConfig config = IPConfig.getInstance();
            if (iRet == -2 || iRet == -1) {
                String[] smsIPs = config.getSmsIP();
                if (smsIPs.length > 0 && smsIPs[0] != null) {
                    String[] stringArray = config.getSmsIP();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String smsIP = stringArray[n2];
                        Host = smsIP;
                        iRet = this.m_gSocket.Connect(Host, this.DEFAULT_PORT);
                        if (iRet >= 0) break;
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ++n2;
                    }
                } else {
                    if (100000 <= iCorpID && iCorpID <= 199999) {
                        Host = config.getSmsIP1();
                    }
                    if (200000 <= iCorpID && iCorpID <= 299999) {
                        Host = config.getSmsIP2();
                    }
                    if (300000 <= iCorpID && iCorpID <= 399999) {
                        Host = config.getSmsIP3();
                    }
                    iRet = this.m_gSocket.Connect(Host, this.DEFAULT_PORT);
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException smsIPs) {
                // empty catch block
            }
            if (iRet >= 0) {
                this.m_gRun = true;
                this.m_gSocket.start();
            } else {
                return -1;
            }
        }
        this.m_gCorpID = iCorpID;
        str_Login str = new str_Login();
        str.ucUserType = (byte)2;
        str.lCorpID = iCorpID;
        str.szUserName = strLoginName;
        str.szPasswd = "JAVA:" + strPasswd;
        this.m_gStatus = -1000;
        byte[] bTemp = new byte[256];
        int iLen = str.ToBytes(bTemp, 0);
        this.m_gSocket.SendFrame(1, bTemp, iLen);
        long lTime = System.currentTimeMillis();
        while (this.m_gStatus == -1000) {
            long lTime2 = System.currentTimeMillis();
            if (lTime2 - lTime >= this.m_gTimeOut) {
                this.m_gStatus = -2;
                break;
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.m_gStatus != 0 && this.m_gStatus != -2) {
            this.m_gStatus = this.m_gStatus == 6 ? -4 : (this.m_gStatus == 7 ? -5 : -3);
        }
        if (this.m_gStatus == 0) {
            str_Recv strRecv = new str_Recv();
            strRecv.lCorpID = this.m_gCorpID;
            strRecv.lUserID = this.m_gUserID;
            iLen = strRecv.ToBytes(bTemp, 0);
            this.m_gSocket.SendFrame(99, bTemp, iLen);
            this.m_gSocket.SendFrame(39, bTemp, iLen);
            str_Back strBack = new str_Back();
            strBack.lCorpID = this.m_gCorpID;
            strBack.lUserID = this.m_gUserID;
            iLen = strBack.ToBytes(bTemp, 0);
            this.m_gSocket.SendFrame(-17, bTemp, iLen);
            this.m_gStatus = -1000;
            lTime = System.currentTimeMillis();
            while (this.m_gStatus == -1000) {
                long lTime2 = System.currentTimeMillis();
                if (lTime2 - lTime >= this.m_gTimeOut) {
                    this.m_gStatus = -2;
                    break;
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.m_gStatus = 0;
        } else {
            this.m_gRun = false;
            this.m_gSocket.DisConnect();
        }
        return this.m_gStatus;
    }

    public int Sms_Send(str_SendMsg[] sendMsg, int iSendCount) {
        return this.Sms_Send_Base(sendMsg, iSendCount, false);
    }

    public int Sms_Send_LongSms(str_SendMsg[] sendMsg, int iSendCount) {
        return this.Sms_Send_Base(sendMsg, iSendCount, true);
    }

    public synchronized int Sms_Send_Base(str_SendMsg[] sendMsg, int iSendCount, boolean bLongSms) {
        block12: {
            block11: {
                if (this.m_gRun) break block11;
                return -1;
            }
            if (this.m_gSocket.m_bConnect) break block12;
            return -1;
        }
        try {
            String strRand = "00";
            Random random1 = new Random(System.currentTimeMillis());
            String strTemp = String.valueOf(12345 + Math.abs(random1.nextInt()) % 1000);
            strRand = strTemp.substring(strTemp.length() - 2);
            this.m_gStatus_Send = -1000;
            str_Send strSend = new str_Send();
            strSend.lRand = Integer.parseInt(strRand, 10);
            strSend.lCorpID = this.m_gCorpID;
            strSend.lUserID = this.m_gUserID;
            strSend.bLongSms = bLongSms ? 1 : 0;
            strSend.bFD = 0;
            strSend.lMaxMsgLen = this.m_gLogin.lMaxSmsLen;
            strSend.lMaxMsgLen_long = this.m_gLogin.lMaxSmsLen + this.m_gLogin.szQJCM.length() - 3;
            strSend.bCMFirst = this.m_gLogin.bCMFirst > 0 ? 1 : 0;
            if (this.m_gCMLocaltion == 1) {
                strSend.bCMFirst = 1;
            }
            if (this.m_gCMLocaltion == 2) {
                strSend.bCMFirst = 0;
            }
            strSend.strCM = this.m_gLogin.szQJCM;
            strSend.lMsgLen = 0;
            strSend.lCount = iSendCount;
            strSend.SendMsg = sendMsg;
            strSend.iSendMsgCount = iSendCount;
            this.m_gSendMsg = sendMsg;
            this.m_gSendMsgCount = iSendCount;
            byte[] bTemp = new byte[4096 * iSendCount];
            int iLen = strSend.ToBytes(bTemp, 0);
            this.m_gSocket.SendFrame(2109, bTemp, iLen);
            long lTime = System.currentTimeMillis();
            while (this.m_gStatus_Send == -1000) {
                long lTime2 = System.currentTimeMillis();
                if (lTime2 - lTime >= this.m_gTimeOut) {
                    this.m_gStatus_Send = -2;
                    break;
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.m_gSendMsgCount = 0;
            if (this.m_gStatus_Send == 0 && sendMsg[0].iSmsID < 0) {
                return sendMsg[0].iSmsID;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_gStatus_Send = -10;
        }
        return this.m_gStatus_Send;
    }

    public synchronized int Sms_Get(str_RecvMsg sendMsg) {
        int lSmsCount = this.m_gMsgRecv.GetNextMsg(sendMsg);
        return lSmsCount;
    }

    public synchronized int Sms_Status(int iMsgID) {
        if (!this.m_gRun) {
            return -1;
        }
        if (!this.m_gSocket.m_bConnect) {
            return -1;
        }
        this.m_gStatus = -1000;
        str_Status strStatus = new str_Status();
        strStatus.lCorpID = this.m_gCorpID;
        strStatus.lQUeryCount = 1;
        strStatus.lSendID = iMsgID;
        strStatus.lStatus = 1;
        byte[] bTemp = new byte[256];
        int iLen = strStatus.ToBytes(bTemp, 0);
        this.m_gSocket.SendFrame(51, bTemp, iLen);
        long lTime = System.currentTimeMillis();
        while (this.m_gStatus == -1000) {
            long lTime2 = System.currentTimeMillis();
            if (lTime2 - lTime >= this.m_gTimeOut) {
                this.m_gStatus = -2;
                break;
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.m_gStatus;
    }

    public synchronized int Sms_KYSms_Adc(str_KYSmsRet KYSmsRet) {
        int lRet = this.Sms_KYSms();
        if (lRet > 0) {
            lRet = 0;
        }
        KYSmsRet.iRet = lRet;
        KYSmsRet.iKYSms_User = this.g_KYSmsUser;
        KYSmsRet.iKYSms_Mobset = this.g_KYSmsMobset;
        KYSmsRet.iKYSms_Adc = this.g_KYSmsAdc;
        return lRet;
    }

    public synchronized int Sms_KYSms() {
        if (!this.m_gRun) {
            return -1;
        }
        if (!this.m_gSocket.m_bConnect) {
            return -1;
        }
        this.m_gStatus = -1000;
        str_KYSms strKYSms = new str_KYSms();
        strKYSms.lCorpID = this.m_gCorpID;
        strKYSms.lUserID = this.m_gUserID;
        byte[] bTemp = new byte[256];
        int iLen = strKYSms.ToBytes(bTemp, 0);
        this.m_gSocket.SendFrame(37, bTemp, iLen);
        long lTime = System.currentTimeMillis();
        while (this.m_gStatus == -1000) {
            long lTime2 = System.currentTimeMillis();
            if (lTime2 - lTime >= this.m_gTimeOut) {
                this.m_gStatus = -2;
                break;
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.m_gStatus;
    }

    public synchronized boolean Sms_IsLogined() {
        return this.m_gRun && this.m_gSocket != null;
    }

    public synchronized void Sms_DisConnect() {
        this.m_gRun = false;
        if (this.m_gSocket != null) {
            this.m_gSocket.DisConnect();
            this.m_gSocket = null;
        }
    }

    public synchronized String Sms_GetCM() {
        return this.m_gLogin.szQJCM;
    }

    public synchronized int Sms_GetMaxLen() {
        return this.m_gLogin.lMaxSmsLen;
    }

    public void Sms_SetCMLocation(int Location) {
        this.m_gCMLocaltion = Location;
    }

    private int BytesToInt(byte[] bT, int iStart) {
        int lRet = 0;
        int b = bT[iStart + 0];
        if (b < 0) {
            b += 256;
        }
        lRet = b;
        b = bT[iStart + 1];
        if (b < 0) {
            b += 256;
        }
        lRet += b * 256;
        b = bT[iStart + 2];
        if (b < 0) {
            b += 256;
        }
        lRet += b * 65536;
        b = bT[iStart + 3];
        if (b < 0) {
            b += 256;
        }
        return lRet += b * 0x1000000;
    }

    private int BytesToWord(byte[] bT, int iStart) {
        int lRet = 0;
        int b = bT[iStart + 0];
        if (b < 0) {
            b += 256;
        }
        lRet = b;
        b = bT[iStart + 1];
        if (b < 0) {
            b += 256;
        }
        return lRet += b * 256;
    }

    private int IntToBytes(int iValue, byte[] bT, int iStart) {
        bT[iStart + 0] = (byte)(iValue % 256);
        bT[iStart + 1] = (byte)(iValue / 256 % 256);
        bT[iStart + 2] = (byte)(iValue / 65536 % 256);
        bT[iStart + 3] = (byte)(iValue / 0x1000000);
        return iValue;
    }

    private int WordToBytes(int iValue, byte[] bT, int iStart) {
        bT[iStart + 0] = (byte)(iValue % 256);
        bT[iStart + 1] = (byte)(iValue / 256 % 256);
        return iValue;
    }

    private int StringToBytes(String strValue, byte[] bT, int iStart, int iMaxLen) {
        byte[] bT2 = new byte[]{};
        try {
            bT2 = strValue.getBytes("UNICODE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int i = 2;
        i = 2;
        while (i < bT2.length && i < iMaxLen - 2) {
            if (this.m_bWindows) {
                bT[iStart + i - 2] = bT2[i + 1];
                bT[iStart + i - 2 + 1] = bT2[i];
            } else {
                bT[iStart + i - 2] = bT2[i];
                bT[iStart + i - 2 + 1] = bT2[i + 1];
            }
            i += 2;
        }
        bT[iStart + i] = 0;
        bT[iStart + ++i] = 0;
        return ++i;
    }

    private String BytesToString(byte[] bT, int iStart, int iLen) {
        int iLen2 = 0;
        byte[] bT2 = new byte[iLen + 2];
        if (this.m_bWindows) {
            bT2[0] = -2;
            bT2[1] = -1;
        } else {
            bT2[0] = -1;
            bT2[1] = -2;
        }
        iLen2 += 2;
        int i = 0;
        while (i < iLen) {
            if (this.m_bWindows) {
                bT2[iLen2] = bT[iStart + i + 1];
                bT2[iLen2 + 1] = bT[iStart + i];
            } else {
                bT2[iLen2] = bT[iStart + i];
                bT2[iLen2 + 1] = bT[iStart + i + 1];
            }
            if (bT[iStart + i] == 0 && bT[iStart + i + 1] == 0) break;
            iLen2 += 2;
            i += 2;
        }
        String str = "";
        try {
            str = new String(bT2, 0, iLen2, "UNICODE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    private void writerLog(String log) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter("c:\\log.txt", true));
            bw.write(log);
            bw.newLine();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class SmsSocket
    extends Thread {
        final int RECV_BUF = 0x190000;
        byte[] m_recvBuf = new byte[0x190000];
        int m_iRecvLen = 0;
        int m_iMastRecvLen = 0;
        boolean m_bRecvHead = true;
        str_Socket_Head m_SocketHead;
        long m_lSendTime = 0L;
        long m_lRecvTime = 0L;
        long m_lRecvTimeOut = 45000L;
        long m_lRefreshTimeOut = 50000L;
        String m_strHost;
        int m_iPort;
        Socket m_Socket = null;
        DataOutputStream m_os = null;
        DataInputStream m_is = null;
        boolean m_bConnect = false;
        boolean m_bRecvFrame = false;
        int m_iUserID = 0;
        int m_iFrameid = 0;

        private SmsSocket() {
            this.m_SocketHead = new str_Socket_Head();
            this.m_strHost = smsSDK.this.DEFAULT_HOST;
            this.m_iPort = smsSDK.this.DEFAULT_PORT;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int Connect(String strHost, int iPort) {
            this.m_strHost = strHost;
            this.m_iPort = iPort;
            if (this.m_bConnect) {
                return 0;
            }
            this.m_iRecvLen = 0;
            this.m_iMastRecvLen = 0;
            this.m_bRecvHead = true;
            try {
                if (this.m_os != null) {
                    this.m_os.close();
                    this.m_os = null;
                }
                if (this.m_is != null) {
                    this.m_is.close();
                    this.m_is = null;
                }
                if (this.m_Socket != null) {
                    this.m_Socket.close();
                    this.m_Socket = null;
                }
                try {
                    this.m_Socket = new Socket(this.m_strHost, this.m_iPort);
                    this.m_os = new DataOutputStream(this.m_Socket.getOutputStream());
                    this.m_is = new DataInputStream(this.m_Socket.getInputStream());
                    this.m_bConnect = true;
                    return 0;
                }
                catch (UnknownHostException uhe) {
                    return -1;
                }
                catch (IOException ioe) {
                    return -2;
                }
            }
            catch (IOException e) {
                return -3;
            }
        }

        public int DisConnect() {
            this.m_iRecvLen = 0;
            this.m_iMastRecvLen = 0;
            this.m_bRecvHead = true;
            this.m_bConnect = false;
            try {
                if (this.m_os != null) {
                    this.m_os.close();
                    this.m_os = null;
                }
                if (this.m_is != null) {
                    this.m_is.close();
                    this.m_is = null;
                }
                if (this.m_Socket != null) {
                    this.m_Socket.close();
                    this.m_Socket = null;
                }
            }
            catch (IOException e) {
                return -1;
            }
            return 0;
        }

        public int SendFrame(int lFunc, byte[] bS, int lLen) {
            if (!this.m_bConnect) {
                return -2;
            }
            byte[] bTemp = new byte[256];
            str_Socket_Head str = new str_Socket_Head();
            str.lFuncType = lFunc;
            str.bCompress = 0;
            str.lUserID = this.m_iUserID;
            str.lUserType = (byte)2;
            str.lFrameLen = lLen;
            str.lCompressLen = 0;
            str.pFrame = 0;
            int iHeadLen = str.ToBytes(bTemp, 0);
            this.m_lSendTime = System.currentTimeMillis();
            this.m_bRecvFrame = false;
            try {
                this.m_os.write(bTemp, 0, iHeadLen);
                this.m_os.write(bS, 0, lLen);
            }
            catch (IOException e) {
                this.m_bConnect = false;
                return -1;
            }
            return 0;
        }

        public int Process_Login(byte[] bT, int iStart, int iLen) {
            smsSDK.this.m_gLogin.FromBytes(bT, iStart);
            smsSDK.this.m_gStatus = smsSDK.this.m_gLogin.ucState;
            smsSDK.this.m_gUserID = smsSDK.this.m_gLogin.lUserID;
            this.m_iUserID = smsSDK.this.m_gLogin.lUserID;
            return 1;
        }

        public int Process_Back(byte[] bT, int iStart, int iLen) {
            smsSDK.this.m_gBack.FromBytes(bT, iStart);
            return 1;
        }

        public int Process_Filt(byte[] bT, int iStart, int iLen) {
            smsSDK.this.m_gFilt.FromBytes(bT, iStart);
            smsSDK.this.m_gStatus = 0;
            return 1;
        }

        public int Process_Recv(byte[] bT, int iStart, int iLen, int iType) {
            smsSDK.this.m_gMsgRecv.FromBytes(bT, iStart, iType);
            return 1;
        }

        public int Process_Send(byte[] bT, int iStart, int iLen) {
            str_Send strSend = new str_Send();
            strSend.SendMsg = smsSDK.this.m_gSendMsg;
            strSend.iSendMsgCount = smsSDK.this.m_gSendMsgCount;
            strSend.FromBytes(bT, iStart);
            smsSDK.this.m_gStatus_Send = strSend.lRetCount;
            return 1;
        }

        public int Process_Status(byte[] bT, int iStart, int iLen) {
            str_Status strStatus = new str_Status();
            strStatus.FromBytes(bT, iStart);
            smsSDK.this.m_gStatus = strStatus.lStatus;
            return 1;
        }

        public int Process_KYSms(byte[] bT, int iStart, int iLen) {
            str_KYSms strKYSms = new str_KYSms();
            strKYSms.FromBytes(bT, iStart);
            smsSDK.this.m_gStatus = strKYSms.lSmsUsed;
            smsSDK.this.g_KYSmsUser = strKYSms.lUsedSmsUsed;
            smsSDK.this.g_KYSmsMobset = strKYSms.lCorpSmsUsed;
            smsSDK.this.g_KYSmsAdc = strKYSms.lCorpAdcSmsUsed;
            return 1;
        }

        public int Process_CloseClient(byte[] bT, int iStart, int iLen) {
            str_CloseClient strCloseClient = new str_CloseClient();
            strCloseClient.FromBytes(bT, iStart);
            if (strCloseClient.lUserID == smsSDK.this.m_gUserID && strCloseClient.lCloseType == 0) {
                smsSDK.this.Sms_DisConnect();
            }
            return 1;
        }

        public void run() {
            boolean bReConnect = false;
            while (smsSDK.this.m_gRun) {
                if (this.m_bConnect) {
                    bReConnect = false;
                    try {
                        int iLen = this.m_is.available();
                        if (iLen < 0) {
                            bReConnect = true;
                        }
                        if (iLen > 0) {
                            if (this.m_bRecvHead) {
                                if (this.m_iRecvLen + iLen > 30) {
                                    iLen = 30 - this.m_iRecvLen;
                                }
                            } else if (this.m_iRecvLen + iLen > this.m_iMastRecvLen) {
                                iLen = this.m_iMastRecvLen - this.m_iRecvLen;
                            }
                            int iLen2 = this.m_is.read(this.m_recvBuf, this.m_iRecvLen, iLen);
                            this.m_iRecvLen += iLen2;
                            if (this.m_bRecvHead && this.m_iRecvLen == 30) {
                                this.m_SocketHead.FromBytes(this.m_recvBuf, 0);
                                if (this.m_SocketHead.lFrameLen > 0 && this.m_SocketHead.lFrameLen < 0x190000) {
                                    this.m_iRecvLen = 0;
                                    this.m_bRecvHead = false;
                                    this.m_iMastRecvLen = this.m_SocketHead.lFrameLen;
                                } else {
                                    bReConnect = true;
                                }
                            }
                            if (!this.m_bRecvHead && this.m_iRecvLen == this.m_iMastRecvLen) {
                                this.m_bRecvHead = true;
                                this.m_iRecvLen = 0;
                                this.m_iMastRecvLen = 0;
                                this.m_lRecvTime = System.currentTimeMillis();
                                this.m_bRecvFrame = true;
                                switch (this.m_SocketHead.lFuncType) {
                                    case 1: {
                                        this.Process_Login(this.m_recvBuf, 0, this.m_iMastRecvLen);
                                        break;
                                    }
                                    case 53: {
                                        this.Process_Recv(this.m_recvBuf, 0, this.m_iMastRecvLen, 1);
                                        break;
                                    }
                                    case 99: {
                                        this.Process_Recv(this.m_recvBuf, 0, this.m_iMastRecvLen, 2);
                                        break;
                                    }
                                    case 239: {
                                        this.Process_Back(this.m_recvBuf, 0, this.m_iMastRecvLen);
                                        break;
                                    }
                                    case 39: {
                                        this.Process_Filt(this.m_recvBuf, 0, this.m_iMastRecvLen);
                                        break;
                                    }
                                    case 2109: {
                                        this.Process_Send(this.m_recvBuf, 0, this.m_iMastRecvLen);
                                        break;
                                    }
                                    case 51: {
                                        this.Process_Status(this.m_recvBuf, 0, this.m_iMastRecvLen);
                                        break;
                                    }
                                    case 37: {
                                        this.Process_KYSms(this.m_recvBuf, 0, this.m_iMastRecvLen);
                                        break;
                                    }
                                    case 255: {
                                        this.Process_CloseClient(this.m_recvBuf, 0, this.m_iMastRecvLen);
                                    }
                                    default: {
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        bReConnect = true;
                    }
                    long lTime = System.currentTimeMillis();
                    if (this.m_lSendTime > 0L && !this.m_bRecvFrame && lTime - this.m_lSendTime > this.m_lRecvTimeOut) {
                        bReConnect = true;
                    }
                    if (!bReConnect && this.m_lSendTime > 0L && lTime - this.m_lSendTime > this.m_lRefreshTimeOut) {
                        byte[] bT = new byte[10];
                        this.SendFrame(100, bT, 0);
                    }
                }
                if (bReConnect || !this.m_bConnect) {
                    this.m_bConnect = false;
                    this.m_bRecvFrame = true;
                    int ret = this.Connect(this.m_strHost, this.m_iPort);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException iLen2) {
                        // empty catch block
                    }
                    if (ret == 0) {
                        byte[] bT = new byte[10];
                        this.SendFrame(100, bT, 0);
                    }
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private class str_Back {
        public int lCorpID = 0;
        public int lUserID = 0;
        public int lRetCount = 0;
        String[] strMobile;
        int iMobileCount = 0;

        public int ToBytes(byte[] bT, int iStart) {
            int iLen = 0;
            smsSDK.this.IntToBytes(this.lCorpID, bT, iStart + iLen);
            smsSDK.this.IntToBytes(this.lUserID, bT, iStart + (iLen += 4));
            return iLen += 4;
        }

        public int FromBytes(byte[] bT, int iStart) {
            int iLen = 0;
            this.lRetCount = smsSDK.this.BytesToInt(bT, iStart + iLen);
            iLen += 4;
            if (this.lRetCount > 0) {
                this.strMobile = new String[this.lRetCount];
            }
            int i = 0;
            while (i < this.lRetCount) {
                this.strMobile[i] = smsSDK.this.BytesToString(bT, iStart + iLen, 64);
                iLen += 64;
                ++i;
            }
            this.iMobileCount = this.lRetCount;
            return iLen;
        }

        public boolean isInBack(String Mobile) {
            int i = 0;
            while (i < this.iMobileCount) {
                if (Mobile.compareTo(this.strMobile[i]) == 0) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private class str_CloseClient {
        public byte bUserType = 0;
        public int lUserID = 0;
        public int lCloseType = 0;

        public int ToBytes(byte[] bT, int iStart) {
            int iLen = 0;
            bT[iLen] = this.bUserType;
            smsSDK.this.IntToBytes(this.lUserID, bT, iStart + (iLen += 4));
            iLen += 4;
            return iLen += 128;
        }

        public int FromBytes(byte[] bT, int iStart) {
            int iLen = 0;
            this.bUserType = bT[iLen];
            this.lUserID = smsSDK.this.BytesToInt(bT, iStart + ++iLen);
            this.lCloseType = smsSDK.this.BytesToInt(bT, iStart + (iLen += 4));
            iLen += 4;
            return iLen += 120;
        }
    }

    private class str_Filt {
        public int lRetCount = 0;
        String[] strFilt;
        int iFiltCount = 0;

        public int ToBytes(byte[] bT, int iStart) {
            int iLen = 0;
            return iLen;
        }

        public int FromBytes(byte[] bT, int iStart) {
            int iLen = 0;
            this.lRetCount = smsSDK.this.BytesToInt(bT, iStart + iLen);
            iLen += 4;
            if (this.lRetCount > 0) {
                this.strFilt = new String[this.lRetCount];
            }
            int i = 0;
            while (i < this.lRetCount) {
                this.strFilt[i] = smsSDK.this.BytesToString(bT, iStart + iLen, 64);
                iLen += 64;
                ++i;
            }
            this.iFiltCount = this.lRetCount;
            return iLen;
        }

        public boolean isMsgInFilt(String strMsg) {
            int i = 0;
            while (i < this.iFiltCount) {
                if (strMsg.indexOf(this.strFilt[i]) >= 0) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private class str_KYSms {
        public int lCorpID = 0;
        public int lUserID = 0;
        public int lRetCount = 0;
        public int lSmsUsed = 0;
        public int lCorpSmsUsed = 0;
        public int lUsedSmsUsed = 0;
        public int lCorpAdcSmsUsed = 0;

        public int ToBytes(byte[] bT, int iStart) {
            int iLen = 0;
            smsSDK.this.IntToBytes(this.lCorpID, bT, iStart + iLen);
            smsSDK.this.IntToBytes(this.lUserID, bT, iStart + (iLen += 4));
            return iLen += 4;
        }

        public int FromBytes(byte[] bT, int iStart) {
            int iLen = 0;
            iLen += 4;
            iLen += 100;
            iLen += 32;
            this.lCorpSmsUsed = smsSDK.this.BytesToInt(bT, iStart + (iLen += 4));
            iLen += 4;
            iLen += 4;
            iLen += 32;
            iLen += 32;
            iLen += 32;
            this.lUsedSmsUsed = smsSDK.this.BytesToInt(bT, iStart + (iLen += 4));
            iLen += 4;
            iLen += 4;
            iLen += 60;
            iLen += 4;
            iLen += 4;
            iLen += 4;
            iLen += 4;
            this.lSmsUsed = this.lUsedSmsUsed;
            if (this.lUsedSmsUsed == -100) {
                this.lSmsUsed = this.lCorpSmsUsed;
            }
            if (this.lSmsUsed > this.lCorpSmsUsed) {
                this.lSmsUsed = this.lCorpSmsUsed;
            }
            return iLen;
        }
    }

    private class str_Login {
        public byte ucUserType = 0;
        public int lCorpVer = 0;
        public String szUserName = "";
        public String szPasswd = "";
        public int lCorpID = 0;
        public byte ucState = 0;
        public int ulPurviewType = 0;
        public int ulPurview = 0;
        public int lUserID = 0;
        public String szCorpName = "";
        public String szSmsNum = "";
        public int lUserNumLen = 0;
        public int lCorpSmsUsed = 0;
        public int lUserSmsUsed = 0;
        public int bCM = 0;
        public String szCM = "";
        public String szMsg = "";
        public byte lOverFilt = 0;
        public byte lOverBegin = 0;
        public byte lOverEnd = 0;
        public byte lOverPercent = 0;
        public int lFiltStep = 0;
        public int bSDK = 0;
        public String szQJCM = "";
        public int bCMFirst = 0;
        public int lMaxSmsLen = 0;
        public String szCorpCM = "";
        public String szUserCM = "";
        public int bOutAll = 0;
        public int lCorpAdcSmsUsed = 0;

        public int ToBytes(byte[] bT, int iStart) {
            int iLen = 0;
            bT[iStart + iLen] = this.ucUserType;
            bT[iStart + ++iLen] = 22;
            bT[iStart + ++iLen] = 39;
            bT[iStart + ++iLen] = -94;
            bT[iStart + ++iLen] = 23;
            smsSDK.this.StringToBytes(this.szUserName, bT, iStart + ++iLen, 64);
            smsSDK.this.StringToBytes(this.szPasswd, bT, iStart + (iLen += 64), 128);
            smsSDK.this.IntToBytes(this.lCorpID, bT, iStart + (iLen += 128));
            return iLen += 4;
        }

        public int FromBytes(byte[] bT, int iStart) {
            int iLen = 0;
            this.ucState = bT[iStart + iLen];
            this.ulPurviewType = smsSDK.this.BytesToInt(bT, iStart + ++iLen);
            this.ulPurview = smsSDK.this.BytesToInt(bT, iStart + (iLen += 4));
            this.lUserID = smsSDK.this.BytesToInt(bT, iStart + (iLen += 4));
            this.szCorpName = smsSDK.this.BytesToString(bT, iStart + (iLen += 4), 100);
            this.szSmsNum = smsSDK.this.BytesToString(bT, iStart + (iLen += 100), 16);
            iLen += 16;
            iLen += 4;
            iLen += 4;
            iLen += 4;
            iLen += 4;
            iLen += 60;
            iLen += 232;
            iLen += 4;
            iLen += 4;
            this.szQJCM = smsSDK.this.BytesToString(bT, iStart + (iLen += 4), 64);
            this.bCMFirst = smsSDK.this.BytesToInt(bT, iStart + (iLen += 64));
            this.lMaxSmsLen = smsSDK.this.BytesToInt(bT, iStart + (iLen += 4));
            iLen += 4;
            iLen += 32;
            iLen += 32;
            return iLen += 4;
        }
    }

    private class str_Recv {
        public int lCorpID = 0;
        public int lUserID = 0;
        public int lRetCount = 0;
        str_RecvMsg[] RecvMsg = new str_RecvMsg[1024];
        static final int iMsgAll = 1024;
        int iMsgBegin = 0;
        int iMsgEnd = 0;

        public int ToBytes(byte[] bT, int iStart) {
            int iLen = 0;
            smsSDK.this.IntToBytes(this.lCorpID, bT, iStart + iLen);
            smsSDK.this.IntToBytes(this.lUserID, bT, iStart + (iLen += 4));
            return iLen += 4;
        }

        public int FromBytes(byte[] bT, int iStart, int iType) {
            int iLen = 0;
            this.lRetCount = smsSDK.this.BytesToInt(bT, iStart + iLen);
            iLen += 4;
            int i = 0;
            while (i < this.lRetCount) {
                this.RecvMsg[this.iMsgEnd].iLogID = smsSDK.this.BytesToInt(bT, iStart + iLen);
                iLen += 4;
                if (iType == 1) {
                    this.RecvMsg[this.iMsgEnd].strSendNum = smsSDK.this.BytesToString(bT, iStart + iLen, 32);
                    this.RecvMsg[this.iMsgEnd].strRecvNum = smsSDK.this.BytesToString(bT, iStart + (iLen += 32), 32);
                    this.RecvMsg[this.iMsgEnd].strMsg = smsSDK.this.BytesToString(bT, iStart + (iLen += 32), 360);
                    iLen += 360;
                } else {
                    this.RecvMsg[this.iMsgEnd].strSendNum = smsSDK.this.BytesToString(bT, iStart + iLen, 48);
                    this.RecvMsg[this.iMsgEnd].strRecvNum = smsSDK.this.BytesToString(bT, iStart + (iLen += 48), 48);
                    this.RecvMsg[this.iMsgEnd].strMsg = smsSDK.this.BytesToString(bT, iStart + (iLen += 48), 416);
                    iLen += 416;
                    iLen += 24;
                    this.RecvMsg[this.iMsgEnd].strAddNum = smsSDK.this.BytesToString(bT, iStart + (iLen += 24), 40);
                    iLen += 40;
                    iLen += 8;
                }
                int iYear = smsSDK.this.BytesToWord(bT, iStart + iLen);
                int iMon = smsSDK.this.BytesToWord(bT, iStart + (iLen += 2));
                iLen += 2;
                int iDay = smsSDK.this.BytesToWord(bT, iStart + (iLen += 2));
                int iHour = smsSDK.this.BytesToWord(bT, iStart + (iLen += 2));
                int iMin = smsSDK.this.BytesToWord(bT, iStart + (iLen += 2));
                int iSec = smsSDK.this.BytesToWord(bT, iStart + (iLen += 2));
                iLen += 2;
                iLen += 2;
                this.RecvMsg[this.iMsgEnd].dRecvTime = Calendar.getInstance();
                this.RecvMsg[this.iMsgEnd].dRecvTime.set(iYear, iMon - 1, iDay, iHour, iMin, iSec);
                ++this.iMsgEnd;
                if (this.iMsgEnd >= 1024) {
                    this.iMsgEnd = 0;
                }
                ++i;
            }
            return iLen;
        }

        public int GetNextMsg(str_RecvMsg msg) {
            int iCount = -1;
            if (this.iMsgBegin == this.iMsgEnd) {
                return iCount;
            }
            if (this.iMsgBegin < this.iMsgEnd) {
                msg.iLogID = this.RecvMsg[this.iMsgBegin].iLogID;
                msg.dRecvTime = this.RecvMsg[this.iMsgBegin].dRecvTime;
                msg.strMsg = this.RecvMsg[this.iMsgBegin].strMsg;
                msg.strRecvNum = this.RecvMsg[this.iMsgBegin].strRecvNum;
                msg.strSendNum = this.RecvMsg[this.iMsgBegin].strSendNum;
                try {
                    msg.strAddNum = this.RecvMsg[this.iMsgBegin].strAddNum;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++this.iMsgBegin;
                iCount = this.iMsgEnd - this.iMsgBegin;
            } else {
                msg = this.RecvMsg[this.iMsgBegin];
                ++this.iMsgBegin;
                if (this.iMsgBegin >= 1024) {
                    this.iMsgBegin = 0;
                    iCount = this.iMsgEnd;
                } else {
                    iCount = 1024 - this.iMsgBegin;
                    iCount += this.iMsgEnd;
                }
            }
            return iCount;
        }

        public str_Recv() {
            int i = 0;
            while (i < 1024) {
                this.RecvMsg[i] = new str_RecvMsg();
                ++i;
            }
        }
    }

    private class str_Send {
        public int lRand = 0;
        public int lCorpID = 0;
        public int lUserID = 0;
        public int bLongSms;
        public int bFD;
        public int lMaxMsgLen_All;
        public int lMaxMsgLen = this.lMaxMsgLen_All = 70;
        public int lMaxMsgLen_long = 67;
        public int bCMFirst = 0;
        public String strCM = "";
        public int lMsgLen = 0;
        public int lCount = 0;
        public int lRetCount = 0;
        str_SendMsg[] SendMsg;
        public int iSendMsgCount;
        public String strErrMsg = "";

        public int ToBytes(byte[] bT, int iStart) {
            int iLen = 0;
            int iSendCount = 0;
            boolean bFilt = false;
            boolean bOneMsg = true;
            String strCheckMsg = "";
            int i = 0;
            while (i < this.iSendMsgCount) {
                if (i == 0) {
                    strCheckMsg = this.SendMsg[i].strMsg;
                } else if (strCheckMsg != this.SendMsg[i].strMsg) {
                    bOneMsg = false;
                    break;
                }
                ++i;
            }
            smsSDK.this.IntToBytes(this.lRand, bT, iStart + iLen);
            smsSDK.this.IntToBytes(this.lCorpID, bT, iStart + (iLen += 4));
            smsSDK.this.IntToBytes(this.lUserID, bT, iStart + (iLen += 4));
            smsSDK.this.IntToBytes(this.bLongSms, bT, iStart + (iLen += 4));
            smsSDK.this.IntToBytes(this.bFD, bT, iStart + (iLen += 4));
            smsSDK.this.IntToBytes(this.lMaxMsgLen, bT, iStart + (iLen += 4));
            smsSDK.this.IntToBytes(this.lMaxMsgLen_long, bT, iStart + (iLen += 4));
            smsSDK.this.IntToBytes(this.bCMFirst, bT, iStart + (iLen += 4));
            smsSDK.this.StringToBytes(this.strCM, bT, iStart + (iLen += 4), 64);
            int lMsgLen_Index = iLen += 64;
            smsSDK.this.IntToBytes(this.lCount, bT, iStart + (iLen += 4));
            iLen += 4;
            int lMsgLen_Len = smsSDK.this.StringToBytes(strCheckMsg, bT, iStart + (iLen += 32), 2400);
            iLen += lMsgLen_Len;
            smsSDK.this.IntToBytes(lMsgLen_Len, bT, iStart + lMsgLen_Index);
            int i2 = 0;
            while (i2 < this.iSendMsgCount) {
                smsSDK.this.IntToBytes(0, bT, iStart + iLen);
                smsSDK.this.IntToBytes(0, bT, iStart + (iLen += 4));
                iLen += 4;
                bFilt = false;
                String strMsg = this.SendMsg[i2].strMsg;
                if (smsSDK.this.m_gFilt.isMsgInFilt(strMsg)) {
                    bFilt = true;
                }
                if (smsSDK.this.m_gBack.isInBack(this.SendMsg[i2].strMobile)) {
                    this.SendMsg[i2].reserve = -1;
                    this.SendMsg[i2].iSmsID = -5;
                } else {
                    if (bFilt) {
                        smsSDK.this.IntToBytes(1, bT, iStart + iLen);
                    } else {
                        smsSDK.this.IntToBytes(0, bT, iStart + iLen);
                    }
                    iLen += 4;
                    if (this.SendMsg[i2].dTimer != null && this.SendMsg[i2].dTimer.get(1) > 2004) {
                        smsSDK.this.WordToBytes(this.SendMsg[i2].dTimer.get(1), bT, iStart + iLen);
                        smsSDK.this.WordToBytes(this.SendMsg[i2].dTimer.get(2), bT, iStart + (iLen += 2));
                        iLen += 2;
                        smsSDK.this.WordToBytes(this.SendMsg[i2].dTimer.get(5), bT, iStart + (iLen += 2));
                        smsSDK.this.WordToBytes(this.SendMsg[i2].dTimer.get(11), bT, iStart + (iLen += 2));
                        smsSDK.this.WordToBytes(this.SendMsg[i2].dTimer.get(12), bT, iStart + (iLen += 2));
                        smsSDK.this.WordToBytes(this.SendMsg[i2].dTimer.get(13), bT, iStart + (iLen += 2));
                        iLen += 2;
                        iLen += 2;
                    } else {
                        iLen += 16;
                    }
                    smsSDK.this.StringToBytes(this.SendMsg[i2].strExNum, bT, iStart + iLen, 64);
                    smsSDK.this.StringToBytes("JAVA", bT, iStart + (iLen += 64), 64);
                    smsSDK.this.StringToBytes(this.SendMsg[i2].strMobile, bT, iStart + (iLen += 64), 64);
                    lMsgLen_Index = iLen += 64;
                    iLen += 4;
                    lMsgLen_Len = 0;
                    if (!bOneMsg) {
                        lMsgLen_Len = smsSDK.this.StringToBytes(strMsg, bT, iStart + iLen, 2400);
                        iLen += lMsgLen_Len;
                    }
                    smsSDK.this.IntToBytes(lMsgLen_Len, bT, iStart + lMsgLen_Index);
                    this.SendMsg[i2].reserve = iSendCount++;
                }
                ++i2;
            }
            smsSDK.this.IntToBytes(iSendCount, bT, iStart);
            return iLen;
        }

        public int FromBytes(byte[] bT, int iStart) {
            int iLen = 0;
            int lRand = smsSDK.this.BytesToInt(bT, iStart + iLen);
            int lCorpID = smsSDK.this.BytesToInt(bT, iStart + (iLen += 4));
            int lUserID = smsSDK.this.BytesToInt(bT, iStart + (iLen += 4));
            this.lRetCount = smsSDK.this.BytesToInt(bT, iStart + (iLen += 4));
            this.strErrMsg = smsSDK.this.BytesToString(bT, iStart + (iLen += 4), 64);
            iLen += 64;
            iLen += 32;
            int i = 0;
            while (i < this.lRetCount) {
                int lStatus = smsSDK.this.BytesToInt(bT, iStart + iLen);
                iLen += 4;
                iLen += 4;
                int lSendID = smsSDK.this.BytesToInt(bT, iStart + (iLen += 4));
                iLen += 4;
                int j = 0;
                while (j < this.iSendMsgCount) {
                    if (this.SendMsg[j].reserve == i) {
                        this.SendMsg[j].iSmsID = lSendID;
                        break;
                    }
                    ++j;
                }
                String strSendNum = smsSDK.this.BytesToString(bT, iStart + (iLen += 4), 64);
                iLen += 64;
                ++i;
            }
            return iLen;
        }
    }

    private class str_Socket_Head {
        static final int RECV_SOCKET_HEAD_LEN = 30;
        public int lFuncType = 0;
        public byte bCompress = 0;
        public int lID = 0;
        public byte lUserType = 0;
        public int lUserID = 0;
        public int lFrameLen = 0;
        public int lCompressLen = 0;
        public int pFrame = 0;

        public int ToBytes(byte[] bT, int iStart) {
            int iLen = 0;
            smsSDK.this.IntToBytes(this.lFuncType, bT, iStart + iLen);
            bT[iStart + (iLen += 4)] = 0;
            bT[iStart + ++iLen] = -1;
            bT[iStart + ++iLen] = -81;
            bT[iStart + ++iLen] = -7;
            bT[iStart + ++iLen] = 10;
            bT[iStart + ++iLen] = 2;
            smsSDK.this.IntToBytes(this.lUserID, bT, iStart + ++iLen);
            smsSDK.this.IntToBytes(this.lFrameLen, bT, iStart + (iLen += 4));
            smsSDK.this.IntToBytes(this.lCompressLen, bT, iStart + (iLen += 4));
            bT[iStart + (iLen += 4)] = 0;
            bT[iStart + ++iLen] = 0;
            bT[iStart + ++iLen] = 0;
            bT[iStart + ++iLen] = 0;
            bT[iStart + ++iLen] = 0;
            bT[iStart + ++iLen] = 0;
            bT[iStart + ++iLen] = 0;
            bT[iStart + ++iLen] = 0;
            return ++iLen;
        }

        public int FromBytes(byte[] bT, int iStart) {
            int iLen = 0;
            this.lFuncType = smsSDK.this.BytesToInt(bT, iStart + iLen);
            this.bCompress = bT[iStart + (iLen += 4)];
            this.lID = smsSDK.this.BytesToInt(bT, iStart + ++iLen);
            this.lUserType = bT[iStart + (iLen += 4)];
            this.lUserID = smsSDK.this.BytesToInt(bT, iStart + ++iLen);
            this.lFrameLen = smsSDK.this.BytesToInt(bT, iStart + (iLen += 4));
            this.lCompressLen = smsSDK.this.BytesToInt(bT, iStart + (iLen += 4));
            iLen += 4;
            iLen += 4;
            return iLen += 4;
        }
    }

    private class str_Status {
        public int lCorpID = 0;
        public int lQUeryCount = 1;
        public int lSendID = 0;
        public int lItemID = 0;
        public int lStatus = 0;
        public int lRetCount = 0;

        public int ToBytes(byte[] bT, int iStart) {
            int iLen = 0;
            smsSDK.this.IntToBytes(this.lCorpID, bT, iStart + iLen);
            smsSDK.this.IntToBytes(this.lQUeryCount, bT, iStart + (iLen += 4));
            smsSDK.this.IntToBytes(this.lSendID, bT, iStart + (iLen += 4));
            smsSDK.this.IntToBytes(this.lItemID, bT, iStart + (iLen += 4));
            smsSDK.this.IntToBytes(this.lStatus, bT, iStart + (iLen += 4));
            iLen += 4;
            iLen += 16;
            return iLen += 16;
        }

        public int FromBytes(byte[] bT, int iStart) {
            int iLen = 0;
            this.lRetCount = smsSDK.this.BytesToInt(bT, iStart + iLen);
            iLen += 4;
            if (this.lRetCount > 0) {
                this.lSendID = smsSDK.this.BytesToInt(bT, iStart + iLen);
                this.lItemID = smsSDK.this.BytesToInt(bT, iStart + (iLen += 4));
                this.lStatus = smsSDK.this.BytesToInt(bT, iStart + (iLen += 4));
                iLen += 4;
            }
            return iLen;
        }
    }
}

