/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Service;

public class DefaultAuthenticationTransaction
implements AuthenticationTransaction {
    private static final long serialVersionUID = 6213904009424725484L;
    private final Service service;
    private final Collection<Credential> credentials;

    public static DefaultAuthenticationTransaction of(Service service, Credential ... credentials) {
        Set<Credential> creds = DefaultAuthenticationTransaction.sanitizeCredentials(credentials);
        return new DefaultAuthenticationTransaction(service, creds);
    }

    public static DefaultAuthenticationTransaction of(Credential ... credentials) {
        return DefaultAuthenticationTransaction.of(null, credentials);
    }

    private static Set<Credential> sanitizeCredentials(Credential[] credentials) {
        if (credentials != null && credentials.length > 0) {
            return Arrays.stream(credentials).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return new HashSet<Credential>(0);
    }

    @Override
    public Optional<Credential> getPrimaryCredential() {
        return this.credentials.stream().findFirst();
    }

    @Override
    public boolean hasCredentialOfType(Class<? extends Credential> type) {
        return this.credentials.stream().anyMatch(type::isInstance);
    }

    @Override
    @Generated
    public Service getService() {
        return this.service;
    }

    @Override
    @Generated
    public Collection<Credential> getCredentials() {
        return this.credentials;
    }

    @Generated
    public DefaultAuthenticationTransaction(Service service, Collection<Credential> credentials) {
        this.service = service;
        this.credentials = credentials;
    }

    @Generated
    public String toString() {
        return "DefaultAuthenticationTransaction(service=" + this.service + ", credentials=" + this.credentials + ")";
    }

    @Generated
    private DefaultAuthenticationTransaction() {
        this.service = null;
        this.credentials = null;
    }
}

