/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthenticationAttributeReleasePolicy
implements AuthenticationAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthenticationAttributeReleasePolicy.class);
    private final Collection<String> onlyReleaseAttributes;
    private final Collection<String> neverReleaseAttributes;
    private final String authenticationContextAttribute;

    public DefaultAuthenticationAttributeReleasePolicy(String authenticationContextAttribute) {
        this(new ArrayList<String>(), new ArrayList<String>(), authenticationContextAttribute);
    }

    public Map<String, Object> getAuthenticationAttributesForRelease(Authentication authentication, Assertion assertion, Map<String, Object> model, RegisteredService service) {
        String contextProvider;
        if (!service.getAttributeReleasePolicy().isAuthorizedToReleaseAuthenticationAttributes()) {
            LOGGER.debug("Attribute release policy for service [{}] is configured to never release any attributes", (Object)service);
            return new LinkedHashMap<String, Object>(0);
        }
        LinkedHashMap<String, Object> attrs = new LinkedHashMap<String, Object>(authentication.getAttributes());
        attrs.keySet().removeAll(this.neverReleaseAttributes);
        if (this.onlyReleaseAttributes != null && !this.onlyReleaseAttributes.isEmpty()) {
            attrs.keySet().retainAll(this.onlyReleaseAttributes);
        }
        if (this.isAttributeAllowedForRelease("authenticationDate")) {
            attrs.put("authenticationDate", CollectionUtils.wrap((Object)authentication.getAuthenticationDate()));
        }
        if (assertion != null) {
            if (this.isAttributeAllowedForRelease("isFromNewLogin")) {
                attrs.put("isFromNewLogin", CollectionUtils.wrap((Object)assertion.isFromNewLogin()));
            }
            if (this.isAttributeAllowedForRelease("longTermAuthenticationRequestTokenUsed")) {
                attrs.put("longTermAuthenticationRequestTokenUsed", CollectionUtils.wrap((Object)CoreAuthenticationUtils.isRememberMeAuthentication((Authentication)authentication, (Assertion)assertion)));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.authenticationContextAttribute) && model.containsKey(this.authenticationContextAttribute) && StringUtils.isNotBlank((CharSequence)(contextProvider = model.get(this.authenticationContextAttribute).toString())) && this.isAttributeAllowedForRelease(this.authenticationContextAttribute)) {
            attrs.put(this.authenticationContextAttribute, CollectionUtils.wrap((Object)contextProvider));
        }
        this.decideIfCredentialPasswordShouldBeReleasedAsAttribute(attrs, authentication, service);
        this.decideIfProxyGrantingTicketShouldBeReleasedAsAttribute(attrs, model, service);
        LOGGER.debug("Processed protocol/authentication attributes from the output model to be [{}]", attrs.keySet());
        return attrs;
    }

    protected boolean isAttributeAllowedForRelease(String attributeName) {
        return !this.neverReleaseAttributes.contains(attributeName);
    }

    protected void decideIfCredentialPasswordShouldBeReleasedAsAttribute(Map<String, Object> attributes, Authentication authentication, RegisteredService service) {
        RegisteredServiceAttributeReleasePolicy policy = service.getAttributeReleasePolicy();
        boolean isAuthorized = policy != null && policy.isAuthorizedToReleaseCredentialPassword() && this.isAttributeAllowedForRelease("credential");
        Optional element = CollectionUtils.firstElement(authentication.getAttributes().get("credential"));
        String credential = element.map(Object::toString).orElse(null);
        this.decideAttributeReleaseBasedOnServiceAttributePolicy(attributes, credential, "credential", service, isAuthorized);
    }

    protected void decideIfProxyGrantingTicketShouldBeReleasedAsAttribute(Map<String, Object> attributes, Map<String, Object> model, RegisteredService service) {
        RegisteredServiceAttributeReleasePolicy policy = service.getAttributeReleasePolicy();
        boolean isAuthorized = policy != null && policy.isAuthorizedToReleaseProxyGrantingTicket() && this.isAttributeAllowedForRelease("proxyGrantingTicket");
        String pgtId = (String)model.get("proxyGrantingTicket");
        this.decideAttributeReleaseBasedOnServiceAttributePolicy(attributes, pgtId, "proxyGrantingTicket", service, isAuthorized);
    }

    protected void decideAttributeReleaseBasedOnServiceAttributePolicy(Map<String, Object> attributes, String attributeValue, String attributeName, RegisteredService service, boolean doesAttributePolicyAllow) {
        if (StringUtils.isNotBlank((CharSequence)attributeValue)) {
            LOGGER.debug("Obtained [{}] as an authentication attribute", (Object)attributeName);
            if (doesAttributePolicyAllow) {
                LOGGER.debug("Obtained [{}] is passed to the CAS validation payload", (Object)attributeName);
                attributes.put(attributeName, CollectionUtils.wrap((Object)attributeValue));
            } else {
                LOGGER.debug("Attribute release policy for [{}] does not authorize the release of [{}]", (Object)service.getServiceId(), (Object)attributeName);
                attributes.remove(attributeName);
            }
        } else {
            LOGGER.trace("[{}] is not available and will not be released to the validation response.", (Object)attributeName);
        }
    }

    @Generated
    public DefaultAuthenticationAttributeReleasePolicy(Collection<String> onlyReleaseAttributes, Collection<String> neverReleaseAttributes, String authenticationContextAttribute) {
        this.onlyReleaseAttributes = onlyReleaseAttributes;
        this.neverReleaseAttributes = neverReleaseAttributes;
        this.authenticationContextAttribute = authenticationContextAttribute;
    }
}

