/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.PostLoad;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.DefaultPrincipalAttributesRepository;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalAttributesRepository;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeFilter;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceConsentPolicy;
import org.apereo.cas.services.consent.DefaultRegisteredServiceConsentPolicy;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class AbstractRegisteredServiceAttributeReleasePolicy
implements RegisteredServiceAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRegisteredServiceAttributeReleasePolicy.class);
    private static final long serialVersionUID = 5325460875620586503L;
    private RegisteredServiceAttributeFilter attributeFilter;
    private PrincipalAttributesRepository principalAttributesRepository = new DefaultPrincipalAttributesRepository();
    private RegisteredServiceConsentPolicy consentPolicy = new DefaultRegisteredServiceConsentPolicy();
    private boolean authorizedToReleaseCredentialPassword;
    private boolean authorizedToReleaseProxyGrantingTicket;
    private boolean excludeDefaultAttributes;
    private boolean authorizedToReleaseAuthenticationAttributes = true;
    private String principalIdAttribute;

    @PostLoad
    public void postLoad() {
        if (this.principalAttributesRepository == null) {
            this.principalAttributesRepository = new DefaultPrincipalAttributesRepository();
        }
        if (this.consentPolicy == null) {
            this.consentPolicy = new DefaultRegisteredServiceConsentPolicy();
        }
    }

    public Map<String, Object> getConsentableAttributes(Principal p, Service selectedService, RegisteredService service) {
        if (this.consentPolicy != null && !this.consentPolicy.isEnabled()) {
            LOGGER.debug("Consent is disabled for service [{}]", (Object)service);
            return new LinkedHashMap<String, Object>(0);
        }
        Map<String, Object> attributes = this.getAttributes(p, selectedService, service);
        LOGGER.debug("Initial set of consentable attributes are [{}]", attributes);
        if (this.consentPolicy != null) {
            LOGGER.debug("Activating consent policy [{}] for service [{}]", (Object)this.consentPolicy, (Object)service);
            if (this.consentPolicy.getExcludedAttributes() != null && !this.consentPolicy.getExcludedAttributes().isEmpty()) {
                this.consentPolicy.getExcludedAttributes().forEach(attributes::remove);
                LOGGER.debug("Consentable attributes after removing excluded attributes are [{}]", attributes);
            } else {
                LOGGER.debug("No attributes are defined per the consent policy to be excluded from the consentable attributes");
            }
            if (this.consentPolicy.getIncludeOnlyAttributes() != null && !this.consentPolicy.getIncludeOnlyAttributes().isEmpty()) {
                attributes.keySet().retainAll(this.consentPolicy.getIncludeOnlyAttributes());
                LOGGER.debug("Consentable attributes after force-including attributes are [{}]", attributes);
            } else {
                LOGGER.debug("No attributes are defined per the consent policy to forcefully be included in the consentable attributes");
            }
        } else {
            LOGGER.debug("No consent policy is defined for service [{}]. Using the collection of attributes released for consent", (Object)service);
        }
        LOGGER.debug("Finalized set of consentable attributes are [{}]", attributes);
        return attributes;
    }

    public Map<String, Object> getAttributes(Principal principal, Service selectedService, RegisteredService registeredService) {
        LOGGER.debug("Initiating attributes release phase for principal [{}] accessing service [{}] defined by registered service [{}]...", new Object[]{principal.getId(), selectedService, registeredService.getServiceId()});
        LOGGER.debug("Locating principal attributes for [{}]", (Object)principal.getId());
        Map<String, Object> principalAttributes = this.resolveAttributesFromPrincipalAttributeRepository(principal);
        LOGGER.debug("Found principal attributes [{}] for [{}]", principalAttributes, (Object)principal.getId());
        LOGGER.debug("Calling attribute policy [{}] to process attributes for [{}]", (Object)this.getClass().getSimpleName(), (Object)principal.getId());
        Map<String, Object> policyAttributes = this.getAttributesInternal(principal, principalAttributes, registeredService);
        LOGGER.debug("Attribute policy [{}] allows release of [{}] for [{}]", new Object[]{this.getClass().getSimpleName(), policyAttributes, principal.getId()});
        LOGGER.debug("Attempting to merge policy attributes and default attributes");
        TreeMap<String, Object> attributesToRelease = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        if (this.isExcludeDefaultAttributes()) {
            LOGGER.debug("Ignoring default attribute policy attributes");
        } else {
            LOGGER.debug("Checking default attribute policy attributes");
            Map<String, Object> defaultAttributes = this.getReleasedByDefaultAttributes(principal, principalAttributes);
            LOGGER.debug("Default attributes found to be released are [{}]", defaultAttributes);
            if (!defaultAttributes.isEmpty()) {
                LOGGER.debug("Adding default attributes first to the released set of attributes");
                attributesToRelease.putAll(defaultAttributes);
            }
        }
        LOGGER.trace("Adding policy attributes to the released set of attributes");
        attributesToRelease.putAll(policyAttributes);
        this.insertPrincipalIdAsAttributeIfNeeded(principal, attributesToRelease, selectedService, registeredService);
        if (this.getAttributeFilter() != null) {
            LOGGER.debug("Invoking attribute filter [{}] on the final set of attributes", (Object)this.getAttributeFilter());
            return this.getAttributeFilter().filter(attributesToRelease);
        }
        LOGGER.debug("Finalizing attributes release phase for principal [{}] accessing service [{}] defined by registered service [{}]...", new Object[]{principal.getId(), selectedService, registeredService.getServiceId()});
        return this.returnFinalAttributesCollection(attributesToRelease, registeredService);
    }

    protected Map<String, Object> resolveAttributesFromPrincipalAttributeRepository(Principal principal) {
        PrincipalAttributesRepository repository = (PrincipalAttributesRepository)ObjectUtils.defaultIfNull((Object)this.principalAttributesRepository, (Object)AbstractRegisteredServiceAttributeReleasePolicy.getPrincipalAttributesRepositoryFromApplicationContext());
        if (repository != null) {
            LOGGER.debug("Using principal attribute repository [{}] to retrieve attributes", (Object)repository);
            return repository.getAttributes(principal);
        }
        return principal.getAttributes();
    }

    private static PrincipalAttributesRepository getPrincipalAttributesRepositoryFromApplicationContext() {
        ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
        if (applicationContext != null) {
            if (applicationContext.containsBean("globalPrincipalAttributeRepository")) {
                LOGGER.trace("Loading global principal attribute repository with caching policies...");
                return (PrincipalAttributesRepository)applicationContext.getBean("globalPrincipalAttributeRepository", PrincipalAttributesRepository.class);
            }
            LOGGER.warn("No global principal attribute repository can be located from the application context.");
        }
        return null;
    }

    protected void insertPrincipalIdAsAttributeIfNeeded(Principal principal, Map<String, Object> attributesToRelease, Service service, RegisteredService registeredService) {
        if (StringUtils.isNotBlank((CharSequence)this.getPrincipalIdAttribute())) {
            LOGGER.debug("Attempting to resolve the principal id for service [{}]", (Object)registeredService.getServiceId());
            String id = registeredService.getUsernameAttributeProvider().resolveUsername(principal, service, registeredService);
            LOGGER.debug("Releasing resolved principal id [{}] as attribute [{}]", (Object)id, (Object)this.getPrincipalIdAttribute());
            attributesToRelease.put(this.getPrincipalIdAttribute(), principal.getId());
        }
    }

    protected Map<String, Object> returnFinalAttributesCollection(Map<String, Object> attributesToRelease, RegisteredService service) {
        LOGGER.debug("Final collection of attributes allowed are: [{}]", attributesToRelease);
        return attributesToRelease;
    }

    protected Map<String, Object> getReleasedByDefaultAttributes(Principal p, Map<String, Object> attributes) {
        ApplicationContext ctx = ApplicationContextProvider.getApplicationContext();
        if (ctx != null) {
            LOGGER.trace("Located application context. Retrieving default attributes for release, if any");
            CasConfigurationProperties props = (CasConfigurationProperties)ctx.getAutowireCapableBeanFactory().getBean(CasConfigurationProperties.class);
            Set defaultAttrs = props.getAuthn().getAttributeRepository().getDefaultAttributesToRelease();
            LOGGER.debug("Default attributes for release are: [{}]", (Object)defaultAttrs);
            TreeMap<String, Object> defaultAttributesToRelease = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            defaultAttrs.forEach(key -> {
                if (attributes.containsKey(key)) {
                    LOGGER.debug("Found and added default attribute for release: [{}]", key);
                    defaultAttributesToRelease.put((String)key, attributes.get(key));
                }
            });
            return defaultAttributesToRelease;
        }
        return new TreeMap<String, Object>();
    }

    public abstract Map<String, Object> getAttributesInternal(Principal var1, Map<String, Object> var2, RegisteredService var3);

    @Generated
    public String toString() {
        return "AbstractRegisteredServiceAttributeReleasePolicy(attributeFilter=" + this.attributeFilter + ", principalAttributesRepository=" + this.principalAttributesRepository + ", consentPolicy=" + this.consentPolicy + ", authorizedToReleaseCredentialPassword=" + this.authorizedToReleaseCredentialPassword + ", authorizedToReleaseProxyGrantingTicket=" + this.authorizedToReleaseProxyGrantingTicket + ", excludeDefaultAttributes=" + this.excludeDefaultAttributes + ", authorizedToReleaseAuthenticationAttributes=" + this.authorizedToReleaseAuthenticationAttributes + ", principalIdAttribute=" + this.principalIdAttribute + ")";
    }

    @Generated
    public RegisteredServiceAttributeFilter getAttributeFilter() {
        return this.attributeFilter;
    }

    @Generated
    public PrincipalAttributesRepository getPrincipalAttributesRepository() {
        return this.principalAttributesRepository;
    }

    @Generated
    public RegisteredServiceConsentPolicy getConsentPolicy() {
        return this.consentPolicy;
    }

    @Generated
    public boolean isAuthorizedToReleaseCredentialPassword() {
        return this.authorizedToReleaseCredentialPassword;
    }

    @Generated
    public boolean isAuthorizedToReleaseProxyGrantingTicket() {
        return this.authorizedToReleaseProxyGrantingTicket;
    }

    @Generated
    public boolean isExcludeDefaultAttributes() {
        return this.excludeDefaultAttributes;
    }

    @Generated
    public boolean isAuthorizedToReleaseAuthenticationAttributes() {
        return this.authorizedToReleaseAuthenticationAttributes;
    }

    @Generated
    public String getPrincipalIdAttribute() {
        return this.principalIdAttribute;
    }

    @Generated
    public void setAttributeFilter(RegisteredServiceAttributeFilter attributeFilter) {
        this.attributeFilter = attributeFilter;
    }

    @Generated
    public void setPrincipalAttributesRepository(PrincipalAttributesRepository principalAttributesRepository) {
        this.principalAttributesRepository = principalAttributesRepository;
    }

    @Generated
    public void setConsentPolicy(RegisteredServiceConsentPolicy consentPolicy) {
        this.consentPolicy = consentPolicy;
    }

    @Generated
    public void setAuthorizedToReleaseCredentialPassword(boolean authorizedToReleaseCredentialPassword) {
        this.authorizedToReleaseCredentialPassword = authorizedToReleaseCredentialPassword;
    }

    @Generated
    public void setAuthorizedToReleaseProxyGrantingTicket(boolean authorizedToReleaseProxyGrantingTicket) {
        this.authorizedToReleaseProxyGrantingTicket = authorizedToReleaseProxyGrantingTicket;
    }

    @Generated
    public void setExcludeDefaultAttributes(boolean excludeDefaultAttributes) {
        this.excludeDefaultAttributes = excludeDefaultAttributes;
    }

    @Generated
    public void setAuthorizedToReleaseAuthenticationAttributes(boolean authorizedToReleaseAuthenticationAttributes) {
        this.authorizedToReleaseAuthenticationAttributes = authorizedToReleaseAuthenticationAttributes;
    }

    @Generated
    public void setPrincipalIdAttribute(String principalIdAttribute) {
        this.principalIdAttribute = principalIdAttribute;
    }

    @Generated
    public AbstractRegisteredServiceAttributeReleasePolicy() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractRegisteredServiceAttributeReleasePolicy)) {
            return false;
        }
        AbstractRegisteredServiceAttributeReleasePolicy other = (AbstractRegisteredServiceAttributeReleasePolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RegisteredServiceAttributeFilter this$attributeFilter = this.attributeFilter;
        RegisteredServiceAttributeFilter other$attributeFilter = other.attributeFilter;
        if (this$attributeFilter == null ? other$attributeFilter != null : !this$attributeFilter.equals(other$attributeFilter)) {
            return false;
        }
        PrincipalAttributesRepository this$principalAttributesRepository = this.principalAttributesRepository;
        PrincipalAttributesRepository other$principalAttributesRepository = other.principalAttributesRepository;
        if (this$principalAttributesRepository == null ? other$principalAttributesRepository != null : !this$principalAttributesRepository.equals(other$principalAttributesRepository)) {
            return false;
        }
        RegisteredServiceConsentPolicy this$consentPolicy = this.consentPolicy;
        RegisteredServiceConsentPolicy other$consentPolicy = other.consentPolicy;
        if (this$consentPolicy == null ? other$consentPolicy != null : !this$consentPolicy.equals(other$consentPolicy)) {
            return false;
        }
        if (this.authorizedToReleaseCredentialPassword != other.authorizedToReleaseCredentialPassword) {
            return false;
        }
        if (this.authorizedToReleaseProxyGrantingTicket != other.authorizedToReleaseProxyGrantingTicket) {
            return false;
        }
        if (this.excludeDefaultAttributes != other.excludeDefaultAttributes) {
            return false;
        }
        if (this.authorizedToReleaseAuthenticationAttributes != other.authorizedToReleaseAuthenticationAttributes) {
            return false;
        }
        String this$principalIdAttribute = this.principalIdAttribute;
        String other$principalIdAttribute = other.principalIdAttribute;
        return !(this$principalIdAttribute == null ? other$principalIdAttribute != null : !this$principalIdAttribute.equals(other$principalIdAttribute));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractRegisteredServiceAttributeReleasePolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RegisteredServiceAttributeFilter $attributeFilter = this.attributeFilter;
        result = result * 59 + ($attributeFilter == null ? 43 : $attributeFilter.hashCode());
        PrincipalAttributesRepository $principalAttributesRepository = this.principalAttributesRepository;
        result = result * 59 + ($principalAttributesRepository == null ? 43 : $principalAttributesRepository.hashCode());
        RegisteredServiceConsentPolicy $consentPolicy = this.consentPolicy;
        result = result * 59 + ($consentPolicy == null ? 43 : $consentPolicy.hashCode());
        result = result * 59 + (this.authorizedToReleaseCredentialPassword ? 79 : 97);
        result = result * 59 + (this.authorizedToReleaseProxyGrantingTicket ? 79 : 97);
        result = result * 59 + (this.excludeDefaultAttributes ? 79 : 97);
        result = result * 59 + (this.authorizedToReleaseAuthenticationAttributes ? 79 : 97);
        String $principalIdAttribute = this.principalIdAttribute;
        result = result * 59 + ($principalIdAttribute == null ? 43 : $principalIdAttribute.hashCode());
        return result;
    }
}

