/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events.dao;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.dao.CasEvent;

public abstract class AbstractCasEventRepository
implements CasEventRepository {
    protected static final String TYPE_PARAM = "type";
    protected static final String CREATION_TIME_PARAM = "creationTime";
    protected static final String PRINCIPAL_ID_PARAM = "principalId";

    public Collection<? extends CasEvent> getEventsOfType(String type) {
        Collection events = this.load();
        return events.stream().filter(event -> event.getType().equals(type)).collect(Collectors.toSet());
    }

    public Collection<? extends CasEvent> getEventsOfType(String type, ZonedDateTime dateTime) {
        return this.getEventsOfType(type).stream().filter(e -> e.getCreationZonedDateTime().isEqual(dateTime) || e.getCreationZonedDateTime().isAfter(dateTime)).collect(Collectors.toSet());
    }

    public Collection<? extends CasEvent> getEventsOfTypeForPrincipal(String type, String principal) {
        return this.getEventsForPrincipal(principal).stream().filter(event -> event.getType().equals(type)).collect(Collectors.toSet());
    }

    public Collection<? extends CasEvent> getEventsOfTypeForPrincipal(String type, String principal, ZonedDateTime dateTime) {
        return this.getEventsOfTypeForPrincipal(type, principal).stream().filter(e -> e.getCreationZonedDateTime().isEqual(dateTime) || e.getCreationZonedDateTime().isAfter(dateTime)).collect(Collectors.toSet());
    }

    public Collection<? extends CasEvent> load(ZonedDateTime dateTime) {
        return this.load().stream().filter(e -> e.getCreationZonedDateTime().isEqual(dateTime) || e.getCreationZonedDateTime().isAfter(dateTime)).collect(Collectors.toSet());
    }

    public Collection<? extends CasEvent> getEventsForPrincipal(String id, ZonedDateTime dateTime) {
        return this.getEventsForPrincipal(id).stream().filter(e -> e.getCreationZonedDateTime().isEqual(dateTime) || e.getCreationZonedDateTime().isAfter(dateTime)).collect(Collectors.toSet());
    }

    public Collection<? extends CasEvent> getEventsForPrincipal(String id) {
        return this.load().stream().filter(e -> e.getPrincipalId().equalsIgnoreCase(id)).collect(Collectors.toSet());
    }
}

