/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events.listener;

import lombok.Generated;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.support.events.AbstractCasEvent;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.authentication.CasAuthenticationPolicyFailureEvent;
import org.apereo.cas.support.events.authentication.CasAuthenticationTransactionFailureEvent;
import org.apereo.cas.support.events.authentication.adaptive.CasRiskyAuthenticationDetectedEvent;
import org.apereo.cas.support.events.dao.CasEvent;
import org.apereo.cas.support.events.ticket.CasTicketGrantingTicketCreatedEvent;
import org.apereo.cas.util.AsciiArtUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.serialization.TicketIdSanitizationUtils;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;

public class DefaultCasEventListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasEventListener.class);
    private final CasEventRepository casEventRepository;

    private static CasEvent prepareCasEvent(AbstractCasEvent event) {
        CasEvent dto = new CasEvent();
        dto.setType(event.getClass().getCanonicalName());
        dto.putTimestamp(Long.valueOf(event.getTimestamp()));
        dto.setCreationTime(DateTimeUtils.zonedDateTimeOf((long)event.getTimestamp()).toString());
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        dto.putClientIpAddress(clientInfo.getClientIpAddress());
        dto.putServerIpAddress(clientInfo.getServerIpAddress());
        dto.putAgent(WebUtils.getHttpServletRequestUserAgentFromRequestContext());
        GeoLocationRequest location = WebUtils.getHttpServletRequestGeoLocationFromRequestContext();
        if (location != null) {
            dto.putGeoLocation(location);
        }
        return dto;
    }

    @EventListener
    public void handleApplicationReadyEvent(ApplicationReadyEvent event) {
        AsciiArtUtils.printAsciiArtInfo((Logger)LOGGER, (String)"READY", (String)"");
        LOGGER.info("Ready to process requests @ [{}]", (Object)DateTimeUtils.zonedDateTimeOf((long)event.getTimestamp()));
    }

    @EventListener
    public void handleCasTicketGrantingTicketCreatedEvent(CasTicketGrantingTicketCreatedEvent event) {
        if (this.casEventRepository != null) {
            CasEvent dto = DefaultCasEventListener.prepareCasEvent((AbstractCasEvent)event);
            dto.setCreationTime(event.getTicketGrantingTicket().getCreationTime().toString());
            dto.putEventId(TicketIdSanitizationUtils.sanitize((String)event.getTicketGrantingTicket().getId()));
            dto.setPrincipalId(event.getTicketGrantingTicket().getAuthentication().getPrincipal().getId());
            this.casEventRepository.save(dto);
        }
    }

    @EventListener
    public void handleCasAuthenticationTransactionFailureEvent(CasAuthenticationTransactionFailureEvent event) {
        if (this.casEventRepository != null) {
            CasEvent dto = DefaultCasEventListener.prepareCasEvent((AbstractCasEvent)event);
            dto.setPrincipalId(event.getCredential().getId());
            dto.putEventId(CasAuthenticationPolicyFailureEvent.class.getSimpleName());
            this.casEventRepository.save(dto);
        }
    }

    @EventListener
    public void handleCasAuthenticationPolicyFailureEvent(CasAuthenticationPolicyFailureEvent event) {
        if (this.casEventRepository != null) {
            CasEvent dto = DefaultCasEventListener.prepareCasEvent((AbstractCasEvent)event);
            dto.setPrincipalId(event.getAuthentication().getPrincipal().getId());
            dto.putEventId(CasAuthenticationPolicyFailureEvent.class.getSimpleName());
            this.casEventRepository.save(dto);
        }
    }

    @EventListener
    public void handleCasRiskyAuthenticationDetectedEvent(CasRiskyAuthenticationDetectedEvent event) {
        if (this.casEventRepository != null) {
            CasEvent dto = DefaultCasEventListener.prepareCasEvent((AbstractCasEvent)event);
            dto.putEventId(event.getService().getName());
            dto.setPrincipalId(event.getAuthentication().getPrincipal().getId());
            this.casEventRepository.save(dto);
        }
    }

    @Generated
    public DefaultCasEventListener(CasEventRepository casEventRepository) {
        this.casEventRepository = casEventRepository;
    }

    @Generated
    public CasEventRepository getCasEventRepository() {
        return this.casEventRepository;
    }
}

