package com.yycc.common.service;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.springframework.data.jpa.domain.Specification;

import com.yycc.common.base.entity.AbsIdEntity;

/**
 * 包含一些公用的查询条件，例如是否被删除等
 * 
 * @author lifan
 */
@SuppressWarnings("rawtypes")
public class CommonSpecification<T extends AbsIdEntity> implements
		Specification {

	private Integer delete = new Integer(0);// 默认查询未删除的数据
	private Integer check;//是否审核通过

	public CommonSpecification() {
		this.delete = 0;
	}

	@SuppressWarnings("unchecked")
	@Override
	public Predicate toPredicate(Root root, CriteriaQuery query,
			CriteriaBuilder cb) {
		List<Predicate> list = new ArrayList<Predicate>();
		list.add(cb.equal(root.get("dr").as(Integer.class), delete));
		if(check != null){
			list.add(cb.equal(root.get("check").as(Integer.class), check));
		}
		Predicate[] predicates = new Predicate[list.size()];
		return cb.and(list.toArray(predicates));
	}

	public Integer getDelete() {
		return delete;
	}

	public void setDelete(Integer delete) {
		this.delete = delete;
	}

	public Integer getCheck() {
		return check;
	}

	public void setCheck(Integer check) {
		this.check = check;
	}

}
