package com.yycc.common.service;

import com.yycc.common.pojo.bpm.ApprovelBack;
import com.yycc.common.pojo.bpm.CallBackBack;
import com.yycc.common.pojo.bpm.CommitBack;
import com.yycc.common.pojo.bpm.HistoryBack;
import com.yycc.common.pojo.bpm.RejectBack;
import com.yycc.common.pojo.bpm.RejectListBack;

/**
 * 单据操作接口
 * 
 * @author Zhi
 * @time 2016年6月14日11:58:20
 *
 */
public interface IBillOperate {
	/**
	 * 获取一个完整的单据信息
	 * 
	 * @param billType
	 *            单据类型
	 * @param billId
	 *            单据ID
	 * @return
	 */
	Object getBillItem(String billType, String billId) throws Exception;

	/**
	 * 单据提交
	 * 
	 * @param billType
	 *            单据类型
	 * @param billId
	 *            单据ID
	 * @param commiter
	 *            提交人ID
	 * @return
	 * @throws Exception
	 */
	CommitBack commit(String billType, String billId, String commiter) throws Exception;

	/**
	 * 收回单据
	 * 
	 * @param billType
	 *            单据类型
	 * @param billId
	 *            单据ID
	 * @param revoker
	 *            收回人
	 * @return
	 * @throws Exception
	 */
	CallBackBack callback(String billType, String billId, String revoker) throws Exception;

	/**
	 * 单据审批
	 * 
	 * @param billType
	 *            单据类型
	 * @param billId
	 *            单据ID
	 * @param approvaler
	 *            审批人
	 * @param action
	 *            审批动作
	 * @param comment
	 *            审批意见
	 * @return
	 * @throws Exception
	 */
	ApprovelBack approval(String billType, String billId, String approvaler, String action, String comment)
			throws Exception;

	/**
	 * 单据驳回
	 * 
	 * @param billType
	 *            单据类型
	 * @param billId
	 *            单据ID
	 * @param userId
	 *            用户ID
	 * @param activityId
	 *            审批节点
	 * @param comment
	 *            审批意见
	 * @return
	 * @throws Exception
	 */
	RejectBack reject(String billType, String billId, String userId, String activityId, String comment)
			throws Exception;

	/**
	 * 获取可驳回列表
	 * 
	 * @param billType
	 * @param billId
	 * @param userId
	 * @return
	 * @throws Exception
	 */
	RejectListBack rejectList(String billType, String billId, String userId) throws Exception;

	/**
	 * 根据单据类型和单据ID查询审批记录
	 * 
	 * @param billType
	 * @param billId
	 * @param userId
	 * @return
	 * @throws Exception
	 */
	HistoryBack approvalHistory(String billType, String billId, String userId) throws Exception;
}
