package com.yycc.common.service;

import com.yycc.common.pojo.bpm.ApprovelBack;
import com.yycc.common.pojo.bpm.ApprovelParas;
import com.yycc.common.pojo.bpm.CallBackBack;
import com.yycc.common.pojo.bpm.CallBackParas;
import com.yycc.common.pojo.bpm.CommitBack;
import com.yycc.common.pojo.bpm.CommitParas;
import com.yycc.common.pojo.bpm.HistoryBack;
import com.yycc.common.pojo.bpm.HistoryParas;
import com.yycc.common.pojo.bpm.RejectBack;
import com.yycc.common.pojo.bpm.RejectListBack;
import com.yycc.common.pojo.bpm.RejectListParas;
import com.yycc.common.pojo.bpm.RejectParas;

/**
 * 与工作流对接的操作接口
 * 
 * @author Zhi
 * @time 2016年6月16日10:32:07
 *
 */
public interface IBpmChange {
	/**
	 * 单据提交
	 * 
	 * @param paras
	 */
	CommitBack commit(CommitParas paras) throws Exception;

	/**
	 * 收回
	 * 
	 * @param paras
	 */
	CallBackBack callback(CallBackParas paras) throws Exception;

	/**
	 * 单据审批
	 * 
	 * @param paras
	 */
	ApprovelBack approval(ApprovelParas paras) throws Exception;

	/**
	 * 单据驳回
	 * 
	 * @param paras
	 */
	RejectBack reject(RejectParas paras) throws Exception;

	/**
	 * 单据可驳回节点列表
	 * 
	 * @param paras
	 */
	RejectListBack rejectList(RejectListParas paras) throws Exception;

	/**
	 * 审批记录
	 * 
	 * @return
	 * @throws Exception
	 */
	HistoryBack approvalHistory(HistoryParas paras) throws Exception;
}
