package com.yycc.common.service.exchange;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yycc.common.exception.BusinessException;
import com.yycc.common.pojo.basedoc.EnumItem;
import com.yycc.common.utils.HttpClientUtils;

/**
 * 获取枚举档案的服务
 * 
 * @author 张远志
 * @time 2016年7月4日15:21:45
 *
 */
public class BaseEnumService {
	/**
	 * portal路径
	 */
	private String portalUrl;

	private final ObjectMapper mapper = new ObjectMapper();

	public String getPortalUrl() {
		return portalUrl;
	}

	public void setPortalUrl(String portalUrl) {
		this.portalUrl = portalUrl;
	}

	/**
	 * 根据枚举类型列表获取该类型下的所有枚举值
	 * 
	 * @param types
	 *            枚举类型编码列表
	 * @return
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public Map<String, List<EnumItem>> getEnumsAllItems(List<String> types) throws Exception {
		String url = portalUrl + "/baseEnum/getEnumsByTypeCodes";
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("etypeCode", types);
		String data = mapper.writeValueAsString(map);
		String content = HttpClientUtils.doPostJson(url, data);
		boolean success = JSON.parseObject(content).getBoolean("success");
		String message = JSON.parseObject(content).getString("message");
		if (!success) {
			throw new BusinessException(message);
		} else {
			return (Map<String, List<EnumItem>>) mapper.readValue(message,
					new TypeReference<Map<String, List<EnumItem>>>() {
					});
		}
	}

	/**
	 * 根据枚举类型获取该类型下的所有枚举值
	 * 
	 * @param type
	 *            枚举类型编码
	 * @return
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public List<EnumItem> getEnumAllItems(String type) throws Exception {
		String url = portalUrl + "/baseEnum/getAllEnums?code=" + type;
		String content = HttpClientUtils.doHttpGet(url);
		boolean success = JSON.parseObject(content).getBoolean("success");
		String message = JSON.parseObject(content).getString("message");
		if (!success) {
			throw new BusinessException(message);
		} else {
			return (List<EnumItem>) mapper.readValue(message,
					mapper.getTypeFactory().constructParametricType(List.class, EnumItem.class));
		}
	}

	/**
	 * 获取枚举类型下制定枚举编号的枚举项
	 * 
	 * @param type
	 *            枚举项
	 * @param codes
	 *            枚举项编码
	 * @return
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public List<EnumItem> getEnumItems(String type, List<String> codes) throws Exception {
		String url = portalUrl + "/baseEnum/getEnumsByTypeCodeAndCode";
		Map<String, Object> paras = new HashMap<String, Object>();
		paras.put("etypeCode", type);
		paras.put("enumcodeList", codes);
		String content = HttpClientUtils.doPost(url, paras);
		boolean success = JSON.parseObject(content).getBoolean("success");
		if (success) {
			String message = JSON.parseObject(content).getString("message");
			return (List<EnumItem>) mapper.readValue(message,
					mapper.getTypeFactory().constructParametricType(List.class, EnumItem.class));
		} else {
			throw new BusinessException(JSON.parseObject(content).getString("msg"));
		}
	}

	/**
	 * 根据枚举类型编码和枚举编码获取一个枚举项
	 * 
	 * @param type
	 * @param code
	 * @return
	 * @throws Exception
	 */
	public EnumItem getEnumItem(String type, String code) throws Exception {
		List<String> codes = new ArrayList<String>();
		codes.add(code);
		List<EnumItem> list = getEnumItems(type, codes);
		return (list == null || list.isEmpty()) ? null : list.get(0);
	}

	/**
	 * 根据枚举类型编号和枚举编号获取枚举名称
	 * 
	 * @param type
	 *            枚举类型编号
	 * @param code
	 *            枚举编号
	 * @return
	 * @throws Exception
	 */
	public String getEnumItemName(String type, String code) throws Exception {
		EnumItem item = getEnumItem(type, code);
		if (item != null) {
			return item.getName();
		}
		return null;
	}

	public static void main(String[] args) {
		BaseEnumService aa = new BaseEnumService();
		aa.setPortalUrl("http://123.103.9.205:8191/yycc-portal");

		try {
			System.out.println(aa.getEnumItemName("poursite", "01"));
			List<String> paras = new ArrayList<String>();
			paras.add("currency");
			paras.add("invoice");
			Map<String, List<EnumItem>> map = aa.getEnumsAllItems(paras);
			System.out.println(map);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
