package com.yycc.common.service.exchange;

import java.io.IOException;
import java.util.Map;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yycc.common.utils.HttpClientUtils;

/**
 * 单据类型服务类
 * 
 * @author 张远志
 * @time 2016年7月1日14:00:13
 *
 */
public class BillNoService {
	/**
	 * portal路径
	 */
	private String portalUrl;

	private final ObjectMapper mapper = new ObjectMapper();

	public String getPortalUrl() {
		return portalUrl;
	}

	public void setPortalUrl(String portalUrl) {
		this.portalUrl = portalUrl;
	}

	/**
	 * 根据单据类型获取一个单据号
	 * 
	 * @param bizType
	 *            单据类型
	 * @return
	 * @throws IOException
	 * @throws JsonMappingException
	 * @throws JsonParseException
	 */
	@SuppressWarnings("unchecked")
	public String getBillNo(String bizType) throws JsonParseException, JsonMappingException, IOException {
		String url = portalUrl + "/getbc/" + bizType;
		String content = HttpClientUtils.doHttpGet(url);
		Map<String, String> back = mapper.readValue(content, Map.class);
		return back.get("code");
	}
}
