package com.yycc.common.service.impl;

import javax.annotation.PostConstruct;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yycc.common.pojo.bpm.ApprovelBack;
import com.yycc.common.pojo.bpm.ApprovelParas;
import com.yycc.common.pojo.bpm.CallBackBack;
import com.yycc.common.pojo.bpm.CallBackParas;
import com.yycc.common.pojo.bpm.CommitBack;
import com.yycc.common.pojo.bpm.CommitParas;
import com.yycc.common.pojo.bpm.HistoryBack;
import com.yycc.common.pojo.bpm.HistoryParas;
import com.yycc.common.pojo.bpm.RejectBack;
import com.yycc.common.pojo.bpm.RejectListBack;
import com.yycc.common.pojo.bpm.RejectListParas;
import com.yycc.common.pojo.bpm.RejectParas;
import com.yycc.common.service.IBpmChange;
import com.yycc.common.utils.HttpClientUtils;

/**
 * BPM流程接口
 * 
 * @author Zhi
 * @time 2016年6月16日10:38:55
 *
 */
public class BpmChangeImpl implements IBpmChange {
	/**
	 * portal路径
	 */
	private String portalUrl;
	/**
	 * 提交动作的URL路径
	 */
	private String commitUrl;
	/**
	 * 收回动作的URL路径
	 */
	private String callbackUrl;
	/**
	 * 审批动作的URL路径
	 */
	private String approveUrl;
	/**
	 * 驳回动作的URL路径
	 */
	private String rejectlistUrl;
	/**
	 * 驳回动作的URL路径
	 */
	private String rejectUrl;
	/**
	 * 查询历史审批记录
	 */
	private String approveHistoryUrl;

	private final ObjectMapper mapper = new ObjectMapper();

	public String getPortalUrl() {
		return portalUrl;
	}

	public void setPortalUrl(String portalUrl) {
		this.portalUrl = portalUrl;
	}

	@PostConstruct
	private void initialize() {
		commitUrl = portalUrl + "/bpm/doSubmit";
		callbackUrl = portalUrl + "/bpm/doCallBack";
		approveUrl = portalUrl + "/bpm/doApprove";
		rejectlistUrl = portalUrl + "/bpm/beforeReject";
		rejectUrl = portalUrl + "/bpm/doReject";
		approveHistoryUrl = portalUrl + "/bpm/queryHistoricProcessInfo";
	}

	@Override
	public CommitBack commit(CommitParas paras) throws Exception {
		String data = mapper.writeValueAsString(paras);
		String content = HttpClientUtils.doPostJson(commitUrl, data);
		return (CommitBack) mapper.readValue(content, CommitBack.class);
	}

	@Override
	public CallBackBack callback(CallBackParas paras) throws Exception {
		String data = mapper.writeValueAsString(paras);
		String content = HttpClientUtils.doPostJson(callbackUrl, data);
		return (CallBackBack) mapper.readValue(content, CallBackBack.class);
	}

	@Override
	public ApprovelBack approval(ApprovelParas paras) throws Exception {
		String data = mapper.writeValueAsString(paras);
		String content = HttpClientUtils.doPostJson(approveUrl, data);
		return (ApprovelBack) mapper.readValue(content, ApprovelBack.class);
	}

	@Override
	public RejectListBack rejectList(RejectListParas paras) throws Exception {
		String data = mapper.writeValueAsString(paras);
		String content = HttpClientUtils.doPostJson(rejectlistUrl, data);
		return (RejectListBack) mapper.readValue(content, RejectListBack.class);
	}

	@Override
	public RejectBack reject(RejectParas paras) throws Exception {
		String data = mapper.writeValueAsString(paras);
		String content = HttpClientUtils.doPostJson(rejectUrl, data);
		return (RejectBack) mapper.readValue(content, RejectBack.class);
	}

	@Override
	public HistoryBack approvalHistory(HistoryParas paras) throws Exception {
		String data = mapper.writeValueAsString(paras);
		String content = HttpClientUtils.doPostJson(approveHistoryUrl, data);
		return (HistoryBack) mapper.readValue(content, HistoryBack.class);
	}
}
