package com.yycc.common.tools.excel.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

//import org.apache.poi.hssf.usermodel.HSSFCell;
//import org.apache.poi.hssf.usermodel.HSSFDataFormatter;
//import org.apache.poi.hssf.usermodel.HSSFWorkbook;
//import org.apache.poi.ss.usermodel.Cell;
//import org.apache.poi.ss.usermodel.Row;
//import org.apache.poi.ss.usermodel.Sheet;
//import org.apache.poi.ss.usermodel.Workbook;
//import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelReaderUtil {

    /**
     * 总行数
     */
    private int totalRows = 0;
    /** 总列数 */
	private int totalCells = 0;
    /** 错误信息 */
    private String errorInfo;
	
	
//	public static void main(String[] args) throws Exception {
//		//Pattern pattern = Pattern.compile("^(-?\\d+)(\\.\\d+)?$");
//		//Matcher isNum = pattern.matcher("9");
//		//System.out.println("---->" + isNum.matches());
//		
//		ExcelReaderUtil poi = new ExcelReaderUtil();
//		//List<List<String>> list = poi.read("C:\\a.xlsx");
//		List<List<String>> list = poi.read("C:\\data.xls");
//		if (list != null) {
//			for (int i = 0; i < list.size(); i++) {
//				System.out.print("第" + (i) + "行");
//				List<String> cellList = list.get(i);
//				for (int j = 0; j < cellList.size(); j++) {
//					// System.out.print(" 第" + (j + 1) + "列值：");
//					System.out.print("    " + cellList.get(j));
//				}
//				System.out.println();
//            }
//        }
//	}

    /**
	 * @描述：根据文件名读取excel文件
	 * @参数：@param filePath 文件完整路径
     * @返回值：List
     */
//	public List<List<String>> read(String filePath) {
//		List<List<String>> dataLst = new ArrayList<List<String>>();
//		InputStream is = null;
//        try {
//            /** 验证文件是否合法 */
//            if (!validateExcel(filePath)) {
//				System.out.println(errorInfo);
//				return null;
//            }
//
//            /** 判断文件的类型，是2003还是2007 */
//            boolean isExcel2003 = true;
//			if (isExcel2007(filePath)) {
//				isExcel2003 = false;
//            }
//
//            /** 调用本类提供的根据流读取的方法 */
//            File file = new File(filePath);
//			is = new FileInputStream(file);
//			dataLst = read(is, isExcel2003);
//			is.close();
//		} catch (Exception ex) {
//			ex.printStackTrace();
//		} finally {
//			if (is != null) {
//				try {
//					is.close();
//				} catch (IOException e) {
//					is = null;
//					e.printStackTrace();
//                }
//            }
//        }
//        /** 返回最后读取的结果 */
//        return dataLst;
//
//	}

	/**
     * @描述：根据流读取Excel文件
	 * @参数：@param inputStream
	 * @参数：@param isExcel2003
     * @返回值：List
     */
//	public List<List<String>> read(InputStream inputStream, boolean isExcel2003) {
//		List<List<String>> dataLst = null;
//        try {
//            /** 根据版本选择创建Workbook的方式 */
//            Workbook wb = null;
//			if (isExcel2003) {
//				wb = new HSSFWorkbook(inputStream);
//			} else {
//				wb = new XSSFWorkbook(inputStream);
//			}
//			dataLst = read(wb);
//		} catch (IOException e) {
//			e.printStackTrace();
//		}
//		return dataLst;
//	}
//
//	/**
//     * @描述：读取数据
//	 * @参数：@param Workbook
//	 * @返回值：List<List<String>>
//     */
//	private List<List<String>> read(Workbook wb) {
//		List<List<String>> dataLst = new ArrayList<List<String>>();
//        /** 得到第一个shell */
//        Sheet sheet = wb.getSheetAt(0);
//        /** 得到Excel的行数 */
//        this.totalRows = sheet.getPhysicalNumberOfRows();
//        /** 得到Excel的列数 */
//        if (this.totalRows >= 1 && sheet.getRow(0) != null) {
//			this.totalCells = sheet.getRow(0).getPhysicalNumberOfCells();
//        }
//        /** 循环Excel的行 */
//        for (int r = 0; r < this.totalRows; r++) {
//			Row row = sheet.getRow(r);
//			if (row == null) continue;
//			List<String> rowLst = new ArrayList<String>();
//            /** 循环Excel的列 */
//            for (int c = 0; c < this.getTotalCells(); c++) {
//				Cell cell = row.getCell(c);
//				String cellValue = "";
//				if (null != cell) {
//					//以下是判断数据的类型
//					switch (cell.getCellType()) {
//						case HSSFCell.CELL_TYPE_NUMERIC: //数字
//							int dataFormat = cell.getCellStyle().getDataFormat();
//							//System.out.println(cell.getNumericCellValue()+":\tdataFormat:"+dataFormat);
//							if (dataFormat == 14 || dataFormat == 28 || dataFormat == 22 || dataFormat == 178
//									|| dataFormat == 58 || dataFormat == 180 || dataFormat == 181 || dataFormat == 182) {
//								Date date = cell.getDateCellValue();
//								if (null != date) {
//									cellValue = new SimpleDateFormat("yyyy-MM-dd").format(date);
//								}
//							}else if(dataFormat == 0){
//								HSSFDataFormatter dataFormatter = new HSSFDataFormatter();
//								cellValue = dataFormatter.formatCellValue(cell);
//							}else{
//								cellValue = new DecimalFormat("0.0000").format(cell.getNumericCellValue());
//							}
//							break;
//						case HSSFCell.CELL_TYPE_STRING: //字符串
//							cellValue = cell.getStringCellValue();
//							break;
//						case HSSFCell.CELL_TYPE_BOOLEAN: //Boolean
//							cellValue = cell.getBooleanCellValue() + "";
//							break;
//						case HSSFCell.CELL_TYPE_FORMULA: //公式
//							cellValue = cell.getCellFormula() + "";
//							break;
//						case HSSFCell.CELL_TYPE_BLANK: //空值
//							cellValue = "";
//							break;
//						case HSSFCell.CELL_TYPE_ERROR: //故障
//							cellValue = "非法字符";
//							break;
//						default:
//							cellValue = "未知类型";
//							break;
//					}
//				}
//				rowLst.add(cellValue);
//            }
//            /** 保存第r行的第c列 */
//            dataLst.add(rowLst);
//		}
//		return dataLst;
//	}

    /**
	 * @描述：验证excel文件
	 * @参数：@param filePath 文件完整路径
	 * @返回值：boolean
     */
	public boolean validateExcel(String filePath) {
        /** 检查文件名是否为空或者是否是Excel格式的文件 */
        if (filePath == null || !(isExcel2003(filePath) || isExcel2007(filePath))) {
			errorInfo = "文件名不是excel格式";
			return false;
        }

        /** 检查文件是否存在 */
        File file = new File(filePath);
		if (file == null || !file.exists()) {
			errorInfo = "文件不存在";
			return false;
		}
		return true;
	}

    /**
	 * @描述：得到总行数
     * @返回值：int
     */
	public int getTotalRows() {
		return totalRows;
	}

	/**
     * @描述：得到总列数
     * @返回值：int
     */
	public int getTotalCells() {
		return totalCells;
	}

	/**
     * @描述：得到错误信息
	 * @返回值：String
     */
	public String getErrorInfo() {
		return errorInfo;
	}

	/**
     * @描述：是否是2003的excel，返回true是2003
	 * @参数：@param filePath 文件完整路径
	 * @返回值：boolean
     */
	public boolean isExcel2003(String filePath) {
		return filePath.matches("^.+\\.(?i)(xls)$");
	}

	/**
     * @描述：是否是2007的excel，返回true是2007
	 * @参数：@param filePath 文件完整路径
	 * @返回值：boolean
     */
	public boolean isExcel2007(String filePath) {
		return filePath.matches("^.+\\.(?i)(xlsx)$");
	}
	
	public static Date toDateFormat(String format, String datetime) throws java.text.ParseException{
		SimpleDateFormat sdf = new SimpleDateFormat(format);
		java.util.Date d = sdf.parse(datetime);
		return d;
	}

    /**
	 * @描述：判断是否为数字
	 * 
	 * http://blog.csdn.net/wj_j2ee/article/details/8090303
     */
	public static boolean isNumeric(String str) {
		Pattern pattern = Pattern.compile("^(-?\\d+)(\\.\\d+)?$");
		Matcher isNum = pattern.matcher(str);
		if (!isNum.matches()) return false;
		return true;
	}

    /**
	 * @描述：判断是否为日期
	 * 
	 * 参考判断日期的正则表达式链接
	 * http://blog.sina.com.cn/s/blog_491997ee0100av3m.html
     */
	public static boolean isDate(String str) {//
		Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))");
		Matcher isNum = pattern.matcher(str);
		if (!isNum.matches()) return false;
		return true;
	}
}
