package com.yycc.common.utils;

import java.lang.reflect.Field;
import java.util.Collection;

import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.yycc.common.base.entity.AbsIdEntity;
import com.yycc.common.base.vo.SuperVO;

/**
 *
 * @ClassName: SimpleBeanUtils 
 * @Description:
 * @author liYang liyangs@yonyou.com 
 * @date 2016年7月25日 下午6:50:49    
 */
public class SimpleBeanUtils {

	private static Logger logger = LoggerFactory.getLogger(SimpleBeanUtils.class);

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static Object convert(Object src, Object dest) {
		try {
			// 普通屬性copy
			BeanUtils.copyProperties(dest, src);
			logger.info("复制实体：" + src.getClass().getSimpleName() + " 结束");
			for (Field field : dest.getClass().getDeclaredFields()) {
				// 普通对象
				// 如果目标类中有关联的实体对象，则复制它
				if (SuperVO.class.isAssignableFrom(field.getType())
						|| AbsIdEntity.class.isAssignableFrom(field.getType())) {
					field.setAccessible(true);
					Object o = field.getType().newInstance();
					BeanUtils.copyProperties(o, src.getClass().getField(field.getName()).get(src));
					for (Field f : o.getClass().getDeclaredFields()) {
						if (SuperVO.class.isAssignableFrom(f.getType())
								|| AbsIdEntity.class.isAssignableFrom(f.getType())) {
							f.set(o, null);
						}
					}
					field.set(dest, o);
					logger.info("复制关系实体：" + field.getType().getName() + " 结束");
					continue;
				}
				// 如果目标类中有集合关联的实体对象，则复制它
				if (Collection.class.isAssignableFrom(field.getType())) {
					// 获取源对象的集合属性
					Collection scl = (Collection) src.getClass().getField(field.getName()).get(src);
					// 获取目标对象的集合属性
					Collection tcl = (Collection) field.get(dest);
					tcl.clear();
					for (Object object : scl) {
						Object po = new Object();
						BeanUtils.copyProperties(po, object);
						for (Field f : po.getClass().getDeclaredFields()) {
							if (SuperVO.class.isAssignableFrom(f.getType())
									|| AbsIdEntity.class.isAssignableFrom(f.getType())) {
								f.set(po, null);
							}
						}
						tcl.add(po);
					}
				}
			}

		} catch (Exception e) {
			throw new RuntimeException(e.getCause());
		}
		return dest;
	}

}
