package com.yycc.common.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * String 工具类
 * 
 * @version 1.0 ,before 2012-9-13
 */
public class StringUtils
{

    private static final String hexDigits[] = { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f" };
    private static final String CONTEXT_REGEX = "\\$P\\{\\w+}";

    /**
     * 检查字符串是否为空:
     * <p>
     * Checks if a String is empty ("") or null. 示例:
     * <ul>
     * <li>StringUtils.isEmpty(null) true
     * <li>StringUtils.isEmpty("") = true
     * <li>StringUtils.isEmpty(" ") = false
     * <li>StringUtils.isEmpty("123") = false
     * <li>StringUtils.isEmpty("  123  ") = false
     * </ul>
     * Parameters: str the String to check, may be null Returns: true if the
     * String is empty or null
     * 
     * @str 需要检查的字符串.
     * @return 如果为空或者null则返回真,其它为假
     */
    // public static boolean isEmpty(String str)
    // {
    // return org.apache.commons.lang.StringUtils.isEmpty(str);
    // }

    /**
     * 函数描述:判断指定的字符是否为空,返回 true|false
     * 
     * @param obj
     * @return 如果对象为空或者Null则返回true,否则为false
     * @author Ken
     * @since 2012-8-2
     * 
     * @author Ken
     * @since 2012-12-17
     * @see 　{@link #isNull(Object)}
     */
    @Deprecated
    public static boolean isEmpty(Object obj)
    {
        return null == obj ? true : ((null == obj || "".equals(obj)) ? true : false);
    }

    /**
     * 判断对象是否为空,形如 if( null == {@code str}) return true;
     * 
     * @param str
     * @return 返回对象是否为null
     */
    public static boolean isNull(Object str)
    {
        return null == str ? true : false;
    }

    /**
     * From JAC I.
     * 
     * @param b
     * @return
     */
    public static String byteArrayToHexString(byte b[])
    {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; i++)
            resultSb.append(byteToHexString(b[i]));

        return resultSb.toString();
    }

    /**
     * From JAC I.
     * 
     * @param b
     * @return
     */
    public static String byteToHexString(byte b)
    {
        int n = b;
        if (n < 0)
            n += 256;
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }

    /**
     * From JAC I.
     * 
     * @param origin
     * @return
     */
    public static String MD5Encode(String origin)
    {
        String resultString = null;
        try
        {
            resultString = new String(origin);
            MessageDigest md = MessageDigest.getInstance("MD5");
            resultString = byteArrayToHexString(md.digest(resultString.getBytes()));
        } catch (Exception exception)
        {
        }
        return resultString;
    }

    /**
     * From JAC I. 测试{@code str1}中的每一个字符是否在{@code str2}
     * 中是否有出现？全有则返回真，有任何一个不存在则返回假.
     * 
     * @param str1
     * @param str2
     */
    public static boolean isInvalid(String str1, String str2)
    {
        boolean flag = true;
        for (int count = 0; count < str1.length(); count++)
        {
            String temp = str1.substring(count, count + 1);
            if (str2.indexOf(temp, 0) != -1)
            {
                continue;
            }
            flag = false;
            break;
        }

        return flag;
    }

    /**
     * From JAC I.
     * 
     * @param str
     * @return
     */
    public static double convertToDig(String str)
    {
        double result = 0.0D;
        int strLen = str.length();
        for (int count = strLen; count > 0; count--)
        {
            String tempstr = str.substring(strLen - count, (strLen - count) + 1);
            if (tempstr.equals("0"))
                result += 0.0D * Math.pow(16D, count - 1);
            else if (tempstr.equals("1"))
                result += 1.0D * Math.pow(16D, count - 1);
            else if (tempstr.equals("2"))
                result += 2D * Math.pow(16D, count - 1);
            else if (tempstr.equals("3"))
                result += 3D * Math.pow(16D, count - 1);
            else if (tempstr.equals("4"))
                result += 4D * Math.pow(16D, count - 1);
            else if (tempstr.equals("5"))
                result += 5D * Math.pow(16D, count - 1);
            else if (tempstr.equals("6"))
                result += 6D * Math.pow(16D, count - 1);
            else if (tempstr.equals("7"))
                result += 7D * Math.pow(16D, count - 1);
            else if (tempstr.equals("8"))
                result += 8D * Math.pow(16D, count - 1);
            else if (tempstr.equals("9"))
                result += 9D * Math.pow(16D, count - 1);
            else if (tempstr.equals("A"))
                result += 10D * Math.pow(16D, count - 1);
            else if (tempstr.equals("B"))
                result += 11D * Math.pow(16D, count - 1);
            else if (tempstr.equals("C"))
                result += 12D * Math.pow(16D, count - 1);
            else if (tempstr.equals("D"))
                result += 13D * Math.pow(16D, count - 1);
            else if (tempstr.equals("E"))
                result += 14D * Math.pow(16D, count - 1);
            else
                result += 15D * Math.pow(16D, count - 1);
        }

        return result;
    }

    /**
     * From JAC I.
     * 
     * @param lots
     * @return
     */
    public static final String transToReportString(String lots)
    {
        // Map map = new HashMap();
        lots = lots.trim();
        String rLots = null;
        String head = null;
        String end = null;
        Integer headI = null;
        Integer endI = null;
        if (lots != null)
        {
            String each[] = lots.split(",");

            int index = 0;
            for (int i = 0; i < each.length; i++)
            {
                each[i] = each[i].trim();
                index = each[i].indexOf("~");
                if (index > 0)
                {
                    head = each[i].substring(0, index);
                    end = each[i].substring(index + 1, each[i].length());
                    headI = Integer.valueOf(head);
                    endI = Integer.valueOf(end);
                    while (headI <= endI)
                    {
                        if (rLots == null)
                            rLots = headI.toString() + ",";
                        else
                            rLots = rLots + headI.toString() + ",";
                        headI++;
                    }
                } else
                {
                    if (rLots == null)
                        rLots = each[i] + ",";
                    else
                        rLots = rLots + each[i].toString() + ",";
                }
            }

        }
        return rLots;
    }

    /**
     * 替换中文空格
     * 
     * @param anyStr
     * @return
     */
    public static String replaceZhSpaces(String anyStr)
    {
        anyStr = anyStr.replaceAll(" ", " ");
        return anyStr;
    }

    /**
     * Clob字段转String
     * 
     * @param clob
     * @return
     * @throws SQLException
     * @throws IOException
     */
    public static String ClobToString(Clob clob) throws SQLException, IOException
    {

        String reString = "";
        Reader is = clob.getCharacterStream();// 得到流
        BufferedReader br = new BufferedReader(is);
        String s = br.readLine();
        StringBuffer sb = new StringBuffer();
        while (s != null)
        {// 执行循环将字符串全部取出付值给StringBuffer由StringBuffer转成STRING
            sb.append(s);
            s = br.readLine();
        }
        reString = sb.toString();
        return reString;
    }

    /**
     * <p>
     * Gets a substring from the specified String avoiding exceptions.
     * </p>
     * 
     * <p>
     * A negative start position can be used to start/end <code>n</code>
     * characters from the end of the String.
     * </p>
     * 
     * <p>
     * The returned substring starts with the character in the
     * <code>start</code> position and ends before the <code>end</code>
     * position. All position counting is zero-based -- i.e., to start at the
     * beginning of the string use <code>start = 0</code>. Negative start and
     * end positions can be used to specify offsets relative to the end of the
     * String.
     * </p>
     * 
     * <p>
     * If <code>start</code> is not strictly to the left of <code>end</code>, ""
     * is returned.
     * </p>
     * 
     * <pre>
     * StringUtils.substring(null, *, *)    = null
     * StringUtils.substring("", * ,  *)    = "";
     * StringUtils.substring("abc", 0, 2)   = "ab"
     * StringUtils.substring("abc", 2, 0)   = ""
     * StringUtils.substring("abc", 2, 4)   = "c"
     * StringUtils.substring("abc", 4, 6)   = ""
     * StringUtils.substring("abc", 2, 2)   = ""
     * StringUtils.substring("abc", -2, -1) = "b"
     * StringUtils.substring("abc", -4, 2)  = "ab"
     * </pre>
     * 
     * @param str
     *            the String to get the substring from, may be null
     * @param start
     *            the position to start from, negative means count back from the
     *            end of the String by this many characters
     * @param end
     *            the position to end at (exclusive), negative means count back
     *            from the end of the String by this many characters
     * @return substring from start position to end positon, <code>null</code>
     *         if null String input
     */
    public static String substring(String str, int start, int end)
    {
        if (str == null)
        {
            return null;
        }

        // handle negatives
        if (end < 0)
        {
            end = str.length() + end; // remember end is negative
        }
        if (start < 0)
        {
            start = str.length() + start; // remember start is negative
        }

        // check length next
        if (end > str.length())
        {
            end = str.length();
        }

        // if start is greater than end, return ""
        if (start > end)
        {
            return "";
        }

        if (start < 0)
        {
            start = 0;
        }
        if (end < 0)
        {
            end = 0;
        }

        return str.substring(start, end);
    }

    public static final String EMPTY = "";
    public static final String BLANK = " ";

    public static boolean isEmpty(String paramString)
    {
        return (paramString == null) || (paramString.length() == 0);
    }

    public static boolean isNotEmpty(String paramString)
    {
        return !isEmpty(paramString);
    }

    public static boolean isBlank(String paramString)
    {
        int i;
        if ((paramString == null) || ((i = paramString.length()) == 0))
            return true;
        for (int j = 0; j < i; j++)
            if (!Character.isWhitespace(paramString.charAt(j)))
                return false;
        return true;
    }

    public static boolean isNotBlank(String paramString)
    {
        return !isBlank(paramString);
    }

    public static String trim(String paramString)
    {
        return paramString == null ? null : paramString.trim();
    }

    public static String trimToNull(String paramString)
    {
        String str = trim(paramString);
        return isEmpty(str) ? null : str;
    }

    public static String trimToEmpty(String paramString)
    {
        return paramString == null ? "" : paramString.trim();
    }

    public static int stringToInt(String paramString)
    {
        return stringToInt(paramString, 0);
    }

    public static int stringToInt(String paramString, int paramInt)
    {
        try
        {
            return Integer.parseInt(paramString);
        } catch (NumberFormatException localNumberFormatException)
        {
        }
        return paramInt;
    }

    /**
     * 找出符合正则表达式的所有字符.
     * 
     * @param str
     *            [String] 源字符串.
     * @param regex
     *            [String] 匹配的正则表达式.
     * @param distinct
     *            [boolean]是否去重.
     * @return
     */
    public static String[] matches(String str, String regex, boolean distinct)
    {

        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        StringBuffer rsb = new StringBuffer();
        while (matcher.find())
        {
            rsb.append(matcher.group(0) + "~_~");
        }
        String[] mths = null;
        if (!"".equals(rsb.toString()))
        {
            mths = rsb.toString().split("~_~");
        }

        // 去重.
        if (mths != null && distinct)
        {
            mths = array_unique(mths);
        }

        return mths;
    }

    /**
     * String数组去重.
     * 
     * @param a
     * @return
     */
    public static String[] array_unique(String[] a)
    {
        Set<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(a));
        return set.toArray(new String[0]);
    }

    /**
     * 合并模板与数据. 参数以"$P{variableName}"形式
     * 
     * @param template
     * @param variables
     * @return
     */
    public static String mergeContent(String template, Map<String, String> variables)
    {
        if (template == null)
        {
            return null;
        }
        Set<String> keySet = (Set<String>) variables.keySet();
        String mergeResult = template;

        for (String key : keySet)
        {
            String replaceValue = variables.get(key);
            if (replaceValue == null)
            {
                continue;
            }
            String replaceName = "$P{" + key + "}";
            mergeResult = mergeResult.replace(replaceName, replaceValue);
        }
        return mergeResult;
    }
    /**
     * encoded in utf-8
     * 
     * <pre>
     * utf8Encode(null)        =   null
     * utf8Encode("")          =   "";
     * utf8Encode("aa")        =   "aa";
     * utf8Encode("啊啊啊啊")   = "%E5%95%8A%E5%95%8A%E5%95%8A%E5%95%8A";
     * </pre>
     * 
     * @param str
     * @return
     * @throws UnsupportedEncodingException if an error occurs
     */
    public static String utf8Encode(String str) {
        if (!isEmpty(str) && str.getBytes().length != str.length()) {
            try {
                return URLEncoder.encode(str, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UnsupportedEncodingException occurred. ", e);
            }
        }
        return str;
    }

    /**
     * encoded in utf-8, if exception, return defultReturn
     * 
     * @param str
     * @param defultReturn
     * @return
     */
    public static String utf8Encode(String str, String defultReturn) {
        if (!isEmpty(str) && str.getBytes().length != str.length()) {
            try {
                return URLEncoder.encode(str, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                return defultReturn;
            }
        }
        return str;
    }
    /**
     * 数组转换为List
     * @param array
     * @return
     */
    public static List<String> toList(String[] array){
    	List<String> list = new ArrayList<String>();
    	if(array!=null&&array.length>0){
    		for(String s : array){
    			list.add(s);
    		}
    	}
    	return list;
    }
}
