package com.yyjz.icop.approve;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.yyjz.icop.pub.business.ISysBizService;
import com.yyjz.icop.pub.utils.JsonBackData;

/**
 * 审批流控制器
 *
 * @ClassName: ApprovalController 
 * @Description:
 * @author liYang liyangs@yonyou.com 
 * @date 2016年12月5日 下午3:12:46    
 */
@RestController
@RequestMapping("/bpm")
public class ApprovalController {

	private final Logger logger = LoggerFactory.getLogger(ApprovalController.class);

	@Autowired
	ISysBizService approvalService;

	@RequestMapping(value = "/updateBillstate", method = RequestMethod.POST)
	public JsonBackData updateState(HttpServletRequest req, HttpServletResponse res) {
		logger.debug("UpdateBillState starting ... ");
		String billTypeId = req.getParameter("billTypeId");
		String billId = req.getParameter("billId");
		String state = req.getParameter("state");
		String bpmId = req.getParameter("bpmId");
		String userId = req.getParameter("userId");
		logger.debug(new StringBuffer().append("BillTpeId:").append(billTypeId).append(", BillId:").append(bpmId)
				.append(", State:").append(state).append(", BpmId:").append(bpmId).append(", UserId:").append(userId)
				.toString());
		JsonBackData backdata = null;
		try {
			backdata = approvalService.updateBillState(billTypeId, billId, state, bpmId, userId);
		} catch (Exception e) {
			logger.error("bpm 回调业务处理报错：", e);
			backdata = new JsonBackData();
			backdata.setBackMsg(e.getMessage());
			backdata.setSuccess(false);
			return backdata;
		}
		if (backdata == null) {
			backdata = new JsonBackData();
			backdata.setSuccess(true);
		}
		return backdata;
	}

	@RequestMapping(value = "/afterAppr", method = RequestMethod.POST)
	public JsonBackData afterApprovalProcessor(HttpServletRequest req) {
		// String billTypeId = req.getParameter("billTypeId");
		// String billId = req.getParameter("billId");
		// String state = req.getParameter("state");
		// try {
		// approvalService.updateBillState(billTypeId, billId, state);
		// } catch (Exception e) {
		// return JsonBackData.fail(e.getMessage());
		// }
		// return JsonBackData.success();
		return JsonBackData.success();
	}

}
