package com.yyjz.icop.approve.util;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import com.alibaba.fastjson.JSONObject;

public class AppConfigUtils {
	
	/**
	 * 返回map类型，key为单据类型，value为查询详细信息的url
	 * @return
	 */
	public static Map<String,JSONObject> getBilltypeUrl(){
		Map<String,JSONObject> map = new HashMap<String,JSONObject>();
		try {
			String path = Thread.currentThread().getContextClassLoader()
					.getResource("officeAppConfig.xml").getPath();
			SAXReader reader = new SAXReader();
			File file = new File(path);
			Document document = reader.read(file);
			Element root = document.getRootElement();

			List<Element> element = root.element("approveList").elements("approvebill");
			for(Element elem:element){
				JSONObject json = new JSONObject();
				json.put("url", elem.elementText("url"));
				json.put("urlType", elem.elementText("urlType"));
				map.put(elem.elementText("billtype"),json);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return map;
	}
	/**
	 * 私有获取根标签下的第一级子标签内容
	 * @param configName
	 * @return
	 */
	public static String getConfigUrl(String configName){
		String result = null;
		try {
			String path = Thread.currentThread().getContextClassLoader()
					.getResource("officeAppConfig.xml").getPath();
			SAXReader reader = new SAXReader();
			File file = new File(path);
			Document document = reader.read(file);
			Element root = document.getRootElement();

			result =  root.elementText(configName);
		} catch (Exception e) {
			e.printStackTrace();
		}	
		return result;
	}
	/**
	 * 返回MA地址
	 * @return
	 */
	public static String getMaUrl(){
		String result = getConfigUrl("maUrl");
		return result;
	}
	/**
	 * 返回优办云的url地址
	 * @return
	 */
	public static String getOfficeUrl(){
		String result = getConfigUrl("officeUrl");
		return result;
	}
}
