package com.yyjz.icop.exception;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.alibaba.dubbo.rpc.RpcException;
import com.yyjz.icop.pub.utils.JsonBackData;

@ControllerAdvice
public class ControllerExceptionHandler {
	
	private static final Logger logger = LoggerFactory.getLogger(ControllerExceptionHandler.class);
	
	@ExceptionHandler(BusinessException.class)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonBackData processBusinessException(BusinessException e) {
		logger.error(e.getMessage(), e.getCause());
		return JsonBackData.fail(e.getMessage()); 
	}
	
	@ExceptionHandler(RpcException.class)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonBackData processRpcException(RpcException e) {
		logger.error(e.getMessage(), e.getCause());
		return JsonBackData.fail("调用RPC服务异常，请稍后重试"); 
	}

}
