package com.yyjz.icop.office.message.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.codec.binary.Base64;

import com.alibaba.fastjson.JSONObject;
import com.yycc.common.exception.BusinessException;
import com.yycc.common.utils.HttpClientUtils;
import com.yyjz.icop.approve.util.AppConfigUtils;
import com.yyjz.icop.office.message.vo.ImgMessageVO;
import com.yyjz.icop.office.message.vo.MessageVO;

public class SendMessageUtil {
	
	private static String newMaMessageUrl = AppConfigUtils.getMaUrl()+"/maservlet/IM/sendMsg";
//	private final static String newMaMessageUrl = "http://192.168.88.3:9080/maservlet/IM/sendMsg";
	/**
	 * 发送文字消息
	 * @param vo
	 * @return
	 * @throws BusinessException
	 */
	public static String sendMessageNew(MessageVO vo) throws BusinessException{
		if (vo == null) {
			return null;
		}
		JSONObject json = new JSONObject();
		json.put("msgtype", vo.getMsgType());
		json.put("target", vo.getReceiver());// 接收人
		json.put("from", vo.getSender());
		json.put("target_type", vo.getTargetType());
		json.put("msg", vo.getContent());

		json.put("appid", vo.getAppid());
		json.put("redirect", vo.getRedirect());

		if ("0".equals(vo.getRedirect())) {
			json.put("url", vo.getUrl());
		}

		String content = null;
		try {
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("params", json.toString());
			System.out.println("############"+json.toJSONString());
			content = HttpClientUtils.doPost(newMaMessageUrl, map);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return content;
	
	}
	/**
	 * 发送图文消息
	 * @param vo
	 * @return
	 * @throws BusinessException
	 */
	public static String sendImgMessageNew(ImgMessageVO vo) throws BusinessException{

		if (vo == null) {
			return null;
		}

		JSONObject json = new JSONObject();
		json.put("msgtype", vo.getMsgType());
		json.put("target", vo.getReceiver());// 接收人
		json.put("from", vo.getSender());
		json.put("target_type", vo.getTargetType());
		json.put("msg", vo.getContent());

		json.put("appid", vo.getAppid());
		json.put("redirect", vo.getRedirect());

		if ("0".equals(vo.getRedirect())) {
			json.put("url", vo.getUrl());
		}

		byte[] data = vo.getFileContent();
		// json.put("filename", );
		String base64file = Base64.encodeBase64String(data);
		json.put("fileContent", base64file);
		json.put("picdesc", vo.getPicdesc());
		json.put("width", vo.getWidth());
		json.put("height", vo.getHeight());
		json.put("ext", vo.getExt());

		String content = null;
		try {
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("params", json.toString());
			content = HttpClientUtils.doPost(newMaMessageUrl, map);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return content;
	
	}

	public static void main(String[] args) {

		// 发送文字消息
//		 sendTxtMsg();
		// 发送图文消息
//
		File file = new File("D:/123.png");// 存储在服务器上的文件
		FileInputStream fileStream;
		try {
			fileStream = new FileInputStream(file);
			int length = fileStream.available();
			byte[] content = new byte[length];
			fileStream.read(content);
			sendImgMsg(content);
		} catch (Exception e) {
			e.printStackTrace();
		}
		// ssoLogin();
		// getPsnInfo();
		// String[] str =
		// "ff808081557b14e501557b2f61060005,ff808081557b14e501557b2fac0e0006".split(",");
		// System.out.println(str.length);
//		 checkToken();
	}

	private static void checkToken() {
		String url = "http://123.103.9.200:9080/maservlet/ssoLogin/checkToken";
		JSONObject json = new JSONObject();
		json.put("appid", "office-news");
		json.put("token", "NDBlNGQ2MTZkOGVjNDQ0YWJkMjQ2Mzk1NWZlM2JhNmM=");
		Map<String, String> map = new HashMap<String, String>();
		map.put("params", json.toString());
		String result = HttpClientUtils.doHttpPost(url, map);
		System.out.println("result=========" + result);
		JSONObject resultJson = new JSONObject();
		resultJson = (JSONObject) JSONObject.parse(result);
		resultJson = resultJson.getJSONObject("data");
		System.out.println("resultJson===============" + resultJson);
		String resultExt = resultJson.getString("ext");
		System.out.println("resultExt===========" + resultExt);
		JSONObject extDataJson = (JSONObject) JSONObject.parse(resultExt);
		System.out.println("extDataJson=====" + extDataJson);

		System.out.println(extDataJson.getJSONObject("data").getJSONObject(
				"staff"));
	}

	/**
	 * 发送文字消息例子
	 */
	public static void sendTxtMsg() {
		MessageVO vo = new MessageVO();
		vo.setAppid("office-news");
		vo.setContent("有新闻发布啦");

		List<String> list = new ArrayList<String>();
		list.add("bpmuser3");
		vo.setReceiver(list);

		vo.setRedirect("0");
		vo.setMsgType("0");
		vo.setUrl("http://123.103.9.206:7023/icop-office-web/mobile/#/news/newsList/newsList");

		vo.setSender("系统管理员");

		try {
			String result = sendMessageNew(vo);
			System.out.println(result + "@@@@@@@@");
		} catch (BusinessException e) {
			e.printStackTrace();
		}
	}

	/**
	 * 发送图文消息例子
	 */
	public static void sendImgMsg(byte[] byt) {
		ImgMessageVO vo = new ImgMessageVO();
		vo.setHeight("200");
		vo.setWidth("200");
		vo.setPicdesc("图片描述22222222");
		vo.setFileContent(byt);

		vo.setMsgType("1");//标志图文消息
		List<String> list = new ArrayList<String>();
		list.add("bpmuser3");
		vo.setReceiver(list);
		
		vo.setAppid("office-news");
		vo.setRedirect("1");
		vo.setSender("我是发送人");
		try {
//			String result = sendImgMessage(vo);
			String result = sendImgMessageNew(vo);
			System.out.println(result + "@@@@@@@");
		} catch (BusinessException e) {
			e.printStackTrace();
		}
	}

}
